<?php
/**
 * WebhookIgnoreTrackResponse
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Model;

use ArrayAccess;
use Infobip\ObjectSerializer;

/**
 * WebhookIgnoreTrackResponse Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class WebhookIgnoreTrackResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WebhookIgnoreTrackResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'notificationType' => 'string',
        'domain' => 'string',
        'recipient' => 'string',
        'url' => 'string',
        'sendDateTime' => 'string',
        'messageId' => 'string',
        'bulkId' => 'string',
        'recipientInfo' => '\Infobip\Model\WebhookIgnoreRecipientInfo',
        'geoLocation' => '\Infobip\Model\WebhookIgnoreGeoLocation'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'notificationType' => null,
        'domain' => null,
        'recipient' => null,
        'url' => null,
        'sendDateTime' => null,
        'messageId' => null,
        'bulkId' => null,
        'recipientInfo' => null,
        'geoLocation' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'notificationType' => 'notificationType',
        'domain' => 'domain',
        'recipient' => 'recipient',
        'url' => 'url',
        'sendDateTime' => 'sendDateTime',
        'messageId' => 'messageId',
        'bulkId' => 'bulkId',
        'recipientInfo' => 'recipientInfo',
        'geoLocation' => 'geoLocation'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'notificationType' => 'setNotificationType',
        'domain' => 'setDomain',
        'recipient' => 'setRecipient',
        'url' => 'setUrl',
        'sendDateTime' => 'setSendDateTime',
        'messageId' => 'setMessageId',
        'bulkId' => 'setBulkId',
        'recipientInfo' => 'setRecipientInfo',
        'geoLocation' => 'setGeoLocation'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'notificationType' => 'getNotificationType',
        'domain' => 'getDomain',
        'recipient' => 'getRecipient',
        'url' => 'getUrl',
        'sendDateTime' => 'getSendDateTime',
        'messageId' => 'getMessageId',
        'bulkId' => 'getBulkId',
        'recipientInfo' => 'getRecipientInfo',
        'geoLocation' => 'getGeoLocation'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }





    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['notificationType'] = $data['notificationType'] ?? null;
        $this->container['domain'] = $data['domain'] ?? null;
        $this->container['recipient'] = $data['recipient'] ?? null;
        $this->container['url'] = $data['url'] ?? null;
        $this->container['sendDateTime'] = $data['sendDateTime'] ?? null;
        $this->container['messageId'] = $data['messageId'] ?? null;
        $this->container['bulkId'] = $data['bulkId'] ?? null;
        $this->container['recipientInfo'] = $data['recipientInfo'] ?? null;
        $this->container['geoLocation'] = $data['geoLocation'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets notificationType
     *
     * @return string|null
     */
    public function getNotificationType()
    {
        return $this->container['notificationType'];
    }

    /**
     * Sets notificationType
     *
     * @param string|null $notificationType Tells the type of user event that took place. Possible events: `OPENED`, `CLICKED`, `COMPLAINED`, `UNSUBSCRIBED`.
     *
     * @return self
     */
    public function setNotificationType($notificationType)
    {
        $this->container['notificationType'] = $notificationType;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string|null $domain The sending domain used to send the email to the recipient.
     *
     * @return self
     */
    public function setDomain($domain)
    {
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets recipient
     *
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->container['recipient'];
    }

    /**
     * Sets recipient
     *
     * @param string|null $recipient Recipient of the email.
     *
     * @return self
     */
    public function setRecipient($recipient)
    {
        $this->container['recipient'] = $recipient;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url The link the recipient has clicked. This attribute will only be present only if the event is of the type `CLICKED`.
     *
     * @return self
     */
    public function setUrl($url)
    {
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets sendDateTime
     *
     * @return string|null
     */
    public function getSendDateTime()
    {
        return $this->container['sendDateTime'];
    }

    /**
     * Sets sendDateTime
     *
     * @param string|null $sendDateTime The time at which the email was sent. Time is in milliseconds.
     *
     * @return self
     */
    public function setSendDateTime($sendDateTime)
    {
        $this->container['sendDateTime'] = $sendDateTime;

        return $this;
    }

    /**
     * Gets messageId
     *
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->container['messageId'];
    }

    /**
     * Sets messageId
     *
     * @param string|null $messageId The ID that uniquely identifies the message sent to the recipient.
     *
     * @return self
     */
    public function setMessageId($messageId)
    {
        $this->container['messageId'] = $messageId;

        return $this;
    }

    /**
     * Gets bulkId
     *
     * @return string|null
     */
    public function getBulkId()
    {
        return $this->container['bulkId'];
    }

    /**
     * Sets bulkId
     *
     * @param string|null $bulkId The ID that uniquely identifies a list of email messages. This is either defined by user in the request or auto generated.
     *
     * @return self
     */
    public function setBulkId($bulkId)
    {
        $this->container['bulkId'] = $bulkId;

        return $this;
    }

    /**
     * Gets recipientInfo
     *
     * @return \Infobip\Model\WebhookIgnoreRecipientInfo|null
     */
    public function getRecipientInfo()
    {
        return $this->container['recipientInfo'];
    }

    /**
     * Sets recipientInfo
     *
     * @param \Infobip\Model\WebhookIgnoreRecipientInfo|null $recipientInfo Recipient information such as device type, OS, device name.
     *
     * @return self
     */
    public function setRecipientInfo($recipientInfo)
    {
        $this->container['recipientInfo'] = $recipientInfo;

        return $this;
    }

    /**
     * Gets geoLocation
     *
     * @return \Infobip\Model\WebhookIgnoreGeoLocation|null
     */
    public function getGeoLocation()
    {
        return $this->container['geoLocation'];
    }

    /**
     * Sets geoLocation
     *
     * @param \Infobip\Model\WebhookIgnoreGeoLocation|null $geoLocation Geolocation data such as Country, City, Latitude and Longitude. This data will be available only for opens and clicks.
     *
     * @return self
     */
    public function setGeoLocation($geoLocation)
    {
        $this->container['geoLocation'] = $geoLocation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize(): mixed
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
