<?php $__env->startSection('page_title', __('Manages Page')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Frontend'); ?></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Pages'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Pages'); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="d-grid gap-3 gap-lg-3">

                    <div class="text-start d-none">
                        <ul class="nav nav-segment " role="tablist">
                            <?php $__currentLoopData = $allTemplate; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item">
                                    <a class="nav-link <?php echo e($template == "light" ? 'active' : ''); ?>" id="nav-one-eg1-tab"
                                       href="#nav-<?php echo e($key); ?>-eg1"
                                       data-bs-toggle="pill" data-bs-target="#nav-one-eg1" role="tab"
                                       aria-controls="nav-one-eg1" aria-selected="true">
                                        <?php echo app('translator')->get(ucwords($template)); ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>

                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title"><?php echo app('translator')->get("Pages"); ?></h4>
                            <a href="<?php echo e(route("admin.create.page", $theme)); ?>"
                               class="btn btn-primary"><?php echo app('translator')->get("Create Page"); ?></a>
                        </div>

                        <?php if(count($allPages) < 1): ?>
                            <div class="card-body">
                                <div class="text-center p-4">
                                    <img class="dataTables-image mb-3"
                                         src="<?php echo e(asset("assets/admin/img/oc-error.svg")); ?>"
                                         alt="Image Description"
                                         data-hs-theme-appearance="default">
                                    <img class="dataTables-image mb-3"
                                         src="<?php echo e(asset("assets/admin/img/oc-error-light.svg")); ?>"
                                         alt="Image Description" data-hs-theme-appearance="dark">
                                    <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(count($allPages) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-thead-bordered table-nowrap table-align-middle card-table">
                                    <thead class="thead-light">
                                    <tr>
                                        <th><?php echo app('translator')->get("Sl."); ?></th>
                                        <th><?php echo app('translator')->get("Name"); ?></th>
                                        <th><?php echo app('translator')->get("Template"); ?></th>
                                        <th><?php echo app('translator')->get("Created At"); ?></th>
                                        <th><?php echo app('translator')->get("Status"); ?></th>
                                        <th class="text-center">
                                            <?php $__currentLoopData = $allLanguage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <img class="avatar avatar-xss avatar-square me-2"
                                                     src="<?php echo e(getFile($language->flag_driver, $language->flag)); ?>"
                                                     alt="<?php echo e($language->name); ?> Flag">
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </th>
                                        <th><?php echo app('translator')->get("Action"); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $allPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($loop->index + 1); ?></td>
                                            <td> <?php echo app('translator')->get(ucwords(optional($page->details)->name ?? $page->name)); ?> </td>
                                            <td>
                                                <?php echo app('translator')->get(ucfirst($page->template_name)); ?>
                                            </td>
                                            <td><?php echo app('translator')->get(dateTime($page->created_at)); ?></td>

                                            <td>
                                                <?php if($page->status == 0): ?>
                                                    <span class="badge bg-soft-warning text-warning">
                                                    <span class="legend-indicator bg-warning"></span><?php echo app('translator')->get("Unpublish"); ?>
                                                  </span>
                                                <?php elseif($page->status == 1): ?>
                                                    <span class="badge bg-soft-success text-success">
                                                    <span class="legend-indicator bg-success"></span><?php echo app('translator')->get("Publish"); ?>
                                                  </span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center">
                                                <?php if($page->type !== 1): ?>
                                                    <?php $__currentLoopData = $allLanguage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="<?php echo e(route('admin.edit.page', [$page->id, $theme, $language->id])); ?>"
                                                           class="btn btn-white btn-icon btn-sm flag-btn"
                                                           target="_blank">
                                                            <i class="bi <?php echo e($page->getLanguageEditClass($page->id, $language->id)); ?>"></i>
                                                        </a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    
                                                    <?php if($page->type == 0): ?>
                                                        <a class="btn btn-white btn-sm"
                                                           href="<?php echo e(route('admin.edit.page', [$page->id, $theme, $defaultLanguage->id])); ?>">
                                                            <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get("Edit"); ?>
                                                        </a>
                                                    <?php else: ?>
                                                        <a class="btn btn-white btn-sm"
                                                           href="<?php echo e(route('admin.edit.static.page', $page->id)); ?>">
                                                            <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get("Edit"); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                    <div class="btn-group">
                                                        <button type="button"
                                                                class="btn btn-white btn-icon btn-sm dropdown-toggle dropdown-toggle-empty"
                                                                id="pageEditDropdown" data-bs-toggle="dropdown"
                                                                aria-expanded="false"></button>
                                                        <div class="dropdown-menu dropdown-menu-end mt-1"
                                                             aria-labelledby="pageEditDropdown">
                                                            <a class="dropdown-item"
                                                               href="<?php echo e(route("admin.page.seo", $page->id)); ?>">
                                                                <i class="fa-light fa-magnifying-glass dropdown-item-icon"></i>
                                                                <?php echo app('translator')->get("SEO"); ?>
                                                            </a>
                                                            <?php if($page->type == 0): ?>
                                                                <a class="dropdown-item deleteBtn text-danger"
                                                                   href="javascript:void(0)"
                                                                   data-pagename="<?php echo e(optional($page->details)->name); ?>"
                                                                   data-route="<?php echo e(route("admin.page.delete", $page->id)); ?>"
                                                                   data-bs-toggle="modal" data-bs-target="#deleteModal">
                                                                    <i class="bi-trash dropdown-item-icon text-danger"></i> <?php echo app('translator')->get("Delete"); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    
                                                    

                                                    
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <div class="text-center p-4">
                                                <img class="dataTables-image mb-3"
                                                     src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                                                     alt="Image Description" data-hs-theme-appearance="default">
                                                <img class="dataTables-image mb-3"
                                                     src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>"
                                                     alt="Image Description" data-hs-theme-appearance="dark">
                                                <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                            </div>
                                        </tr>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
         data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteModalLabel"><i
                            class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="post" class="setRoute">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field("delete"); ?>
                    <div class="modal-body">
                        <p><?php echo app('translator')->get("Do you want to delete"); ?> `<span class="page-name"></span>` <?php echo app('translator')->get("Page?"); ?> </p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Delete Modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use script";
        $(document).ready(function () {
            $('.deleteBtn').on('click', function () {
                let page_name = $(this).data('pagename');
                $(".page-name").text(page_name);
                let route = $(this).data('route');
                $('.setRoute').attr('action', route);
            })
        })
    </script>
<?php $__env->stopPush(); ?>






<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\swift-send\project\resources\views/admin/frontend_management/page/index.blade.php ENDPATH**/ ?>