<div class="card mb-3 mb-lg-5">
    <div class="row col-lg-divider">
        <div class="col-lg-6" id="automationRecord">
            <!-- Body -->
            <div class="card-body">
                <h4><?php echo app('translator')->get('Total Automation'); ?> <i class="bi-question-circle text-body ms-1"
                                                 data-bs-toggle="tooltip"
                                                 data-bs-placement="top"
                                                 title="<?php echo app('translator')->get('The bar chart depicts the evolution of Email Marketing Automation, with each bar representing the increasing level of automation in email campaigns over time'); ?>"></i>
                </h4>

                <div class="row align-items-sm-center mt-4 mt-sm-0 mb-5">
                    <div class="col-sm mb-3 mb-sm-0">
                        <span class="display-5 text-dark me-2 totalAutomationCount"></span>
                    </div>
                    <!-- End Col -->
                </div>
                <!-- End Row -->

                <!-- Bar Chart -->
                <div class="chartjs-custom mb-4 bar-chart-height">
                    <canvas class="" id="chartAutomationRecordsGraph">
                    </canvas>
                </div>
                <!-- End Bar Chart -->

                <!-- Legend Indicators -->
                <div class="row justify-content-center">
                    <div class="col-auto">
                        <span class="legend-indicator"></span> <?php echo app('translator')->get('Yesterday'); ?>
                    </div>
                    <!-- End Col -->

                    <div class="col-auto">
                        <span class="legend-indicator bg-primary"></span> <?php echo app('translator')->get('Today'); ?>
                    </div>
                    <!-- End Col -->
                </div>
                <!-- End Legend Indicators -->
            </div>
            <!-- End Body -->
        </div>
        <!-- End Col -->

        <div class="col-lg-6" id="singleSendRecord">
            <!-- Body -->
            <div class="card-body">
                <h4><?php echo app('translator')->get('Total Single Sends'); ?></h4>

                <div class="row align-items-sm-center mt-4 mt-sm-0 mb-5">
                    <div class="col-sm mb-3 mb-sm-0">
                        <span class="display-5 text-dark me-2 totalSingleSendCount"></span>
                    </div>
                </div>
                <!-- End Row -->

                <!-- Bar Chart -->
                <div class="chartjs-custom mb-4 bar-chart-height">
                    <canvas class="" id="chartSingleSendRecordsGraph">
                    </canvas>
                </div>
                <!-- End Bar Chart -->

                <!-- Legend Indicators -->
                <div class="row justify-content-center">
                    <div class="col-auto">
                        <span class="legend-indicator"></span> <?php echo app('translator')->get('Yesterday'); ?>
                    </div>
                    <!-- End Col -->

                    <div class="col-auto">
                        <span class="legend-indicator bg-primary"></span> <?php echo app('translator')->get('Today'); ?>
                    </div>
                    <!-- End Col -->
                </div>
                <!-- End Legend Indicators -->
            </div>
            <!-- End Body -->
        </div>
        <!-- End Col -->
    </div>
    <!-- End Row -->
</div>

<?php $__env->startPush('script'); ?>
    <script>
        Notiflix.Block.standard('#automationRecord');
        HSCore.components.HSChartJS.init(document.querySelector('#chartAutomationRecordsGraph'), {
            type: "line",
            data: {
                labels: [],
                datasets: [{
                    data: [],
                    backgroundColor: "transparent",
                    borderColor: "#377dff",
                    borderWidth: 2,
                    pointRadius: 0,
                    hoverBorderColor: "#377dff",
                    pointBackgroundColor: "#377dff",
                    pointBorderColor: "#fff",
                    pointHoverRadius: 0,
                    tension: 0.4
                },
                    {
                        data: [],
                        backgroundColor: "transparent",
                        borderColor: "#e7eaf3",
                        borderWidth: 2,
                        pointRadius: 0,
                        hoverBorderColor: "#e7eaf3",
                        pointBackgroundColor: "#e7eaf3",
                        pointBorderColor: "#fff",
                        pointHoverRadius: 0,
                        tension: 0.4
                    }]
            },
            options: {
                scales: {
                    y: {
                        grid: {
                            color: "#e7eaf3",
                            drawBorder: false,
                            zeroLineColor: "#e7eaf3"
                        },
                        ticks: {
                            beginAtZero: true,
                            stepSize: 100,
                            color: "#97a4af",
                            font: {
                                size: 12,
                                family: "Open Sans, sans-serif"
                            },
                            padding: 10,
                            prefix: "$",
                            postfix: "k"
                        }
                    },
                    x: {
                        grid: {
                            display: false,
                            drawBorder: false
                        },
                        ticks: {
                            color: "#97a4af",
                            font: {
                                size: 12,
                                family: "Open Sans, sans-serif"
                            },
                            padding: 5
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        prefix: "",
                        postfix: "",
                        hasIndicator: true,
                        mode: "index",
                        intersect: false,
                        lineMode: true,
                        lineWithLineColor: "rgba(19, 33, 68, 0.075)"
                    }
                },
                hover: {
                    mode: "nearest",
                    intersect: true
                }
            }
        });
        const chartAutomationRecordsGraph = HSCore.components.HSChartJS.getItem('chartAutomationRecordsGraph');

        updateChartAutomationRecordsGraph();

        async function updateChartAutomationRecordsGraph() {
            let $url = "<?php echo e(route('admin.chartAutomationRecords')); ?>"
            await axios.get($url)
                .then(function (res) {

                    $('.totalAutomationCount').text(res.data.automationRecord.totalAutomations);

                    chartAutomationRecordsGraph.data.labels = res.data.automationRecord.automationToday.hours;
                    chartAutomationRecordsGraph.data.datasets[0].data = res.data.automationRecord.automationToday.counts;
                    chartAutomationRecordsGraph.data.datasets[1].data = res.data.automationRecord.automationYesterday.counts;
                    chartAutomationRecordsGraph.update();
                    Notiflix.Block.remove('#automationRecord');
                })
                .catch(function (error) {
                });
        }
    </script>

    <script>
        Notiflix.Block.standard('#singleSendRecord');
        HSCore.components.HSChartJS.init(document.querySelector('#chartSingleSendRecordsGraph'), {
            type: "line",
            data: {
                labels: [],
                datasets: [{
                    data: [],
                    backgroundColor: "transparent",
                    borderColor: "#377dff",
                    borderWidth: 2,
                    pointRadius: 0,
                    hoverBorderColor: "#377dff",
                    pointBackgroundColor: "#377dff",
                    pointBorderColor: "#fff",
                    pointHoverRadius: 0,
                    tension: 0.4
                },
                    {
                        data: [],
                        backgroundColor: "transparent",
                        borderColor: "#e7eaf3",
                        borderWidth: 2,
                        pointRadius: 0,
                        hoverBorderColor: "#e7eaf3",
                        pointBackgroundColor: "#e7eaf3",
                        pointBorderColor: "#fff",
                        pointHoverRadius: 0,
                        tension: 0.4
                    }]
            },
            options: {
                scales: {
                    y: {
                        grid: {
                            color: "#e7eaf3",
                            drawBorder: false,
                            zeroLineColor: "#e7eaf3"
                        },
                        ticks: {
                            beginAtZero: true,
                            stepSize: 100,
                            color: "#97a4af",
                            font: {
                                size: 12,
                                family: "Open Sans, sans-serif"
                            },
                            padding: 10,
                            prefix: "$",
                            postfix: "k"
                        }
                    },
                    x: {
                        grid: {
                            display: false,
                            drawBorder: false
                        },
                        ticks: {
                            color: "#97a4af",
                            font: {
                                size: 12,
                                family: "Open Sans, sans-serif"
                            },
                            padding: 5
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        prefix: "",
                        postfix: "",
                        hasIndicator: true,
                        mode: "index",
                        intersect: false,
                        lineMode: true,
                        lineWithLineColor: "rgba(19, 33, 68, 0.075)"
                    }
                },
                hover: {
                    mode: "nearest",
                    intersect: true
                }
            }
        });
        const chartSingleSendRecordsGraph = HSCore.components.HSChartJS.getItem('chartSingleSendRecordsGraph');

        updateChartSingleSendRecordsGraph();

        async function updateChartSingleSendRecordsGraph() {
            let $url = "<?php echo e(route('admin.chartSingleSendRecords')); ?>"
            await axios.get($url)
                .then(function (res) {

                    $('.totalSingleSendCount').text(res.data.singleSendRecord.totalSingleSend);

                    chartSingleSendRecordsGraph.data.labels = res.data.singleSendRecord.singleSendToday.hours;
                    chartSingleSendRecordsGraph.data.datasets[0].data = res.data.singleSendRecord.singleSendToday.counts;
                    chartSingleSendRecordsGraph.data.datasets[1].data = res.data.singleSendRecord.singleSendYesterday.counts;
                    chartSingleSendRecordsGraph.update();
                    Notiflix.Block.remove('#singleSendRecord');
                })
                .catch(function (error) {
                     
                });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\xamp\htdocs\swift-send\resources\views/admin/partials/dashboard/automation-singlesend.blade.php ENDPATH**/ ?>