<?php $__env->startSection('title',trans('Subscription')); ?>

<?php $__env->startSection('content'); ?>
    <section class="payment-section">
        <div class="container">
            <form action="<?php echo e(route('user.subscriptionPurchase').'?id='.$subscriptionPlan->id); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="row g-5">
                    <div class="col-lg-7 col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="mb-15"><?php echo app('translator')->get('How would you like to pay?'); ?></h4>
                                <ul class="payment-container-list">
                                    <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="item">
                                            <input class="form-check-input methodId" type="radio" name="methodId"
                                                   id="flexRadioDefault<?php echo e($key); ?>" value="<?php echo e($method->id); ?>"
                                                <?php echo e(old('methodId') == $method->id || $key == 0 ? ' checked' : ''); ?>>
                                            <label class="form-check-label" for="flexRadioDefault<?php echo e($key); ?>">
                                                <div class="image-area">
                                                    <img src="<?php echo e(getFile($method->driver,$method->image )); ?>" alt="...">
                                                </div>
                                                <div class="content-area">
                                                    <h5><?php echo app('translator')->get($method->name); ?></h5>
                                                    <span><?php echo app('translator')->get($method->description); ?></span>
                                                </div>
                                            </label>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <!-- Transfer details section start -->
                                <div class="transfer-details-section">
                                    <ul class="transfer-list">
                                        <div>
                                            <label for=""><?php echo app('translator')->get('Select Currency'); ?></label>
                                            <select class="js-example-basic-single form-control mt-2"
                                                    name="supported_currency"
                                                    id="supported_currency">
                                            </select>
                                        </div>
                                        <hr>
                                        <li class="item title">
                                            <h6><?php echo app('translator')->get('Purchase summary'); ?></h6>
                                        </li>
                                        <div class="showCharge">
                                        </div>
                                    </ul>
                                    <button type="submit" class="cmn-btn w-100"><?php echo app('translator')->get('confirm and continue'); ?></button>
                                </div>
                                <!-- Transfer details section end -->
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
    <input type="hidden" id="amount" value="<?php echo e($subscriptionPlan->price); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
    <script>
        'use strict'
        $(document).ready(function () {
            let amountField = $('#amount');
            let amountStatus = false;
            let selectedGateway = "<?php echo e($methods[0]->id); ?>";
            supportCurrency(selectedGateway);

            function clearMessage(fieldId) {
                $(fieldId).removeClass('is-valid')
                $(fieldId).removeClass('is-invalid')
                $(fieldId).closest('div').find(".invalid-feedback").html('');
                $(fieldId).closest('div').find(".is-valid").html('');
            }

            $(document).on('click', '.methodId', function () {
                let id = this.id;

                selectedGateway = $(this).val();
                supportCurrency(selectedGateway);
            });

            function supportCurrency(selectedGateway) {
                if (!selectedGateway) {
                    console.error('Selected Gateway is undefined or null.');
                    return;
                }

                $('#supported_currency').empty();

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('supported.currency')); ?>",
                    data: {gateway: selectedGateway},
                    type: "GET",
                    success: function (data) {
                        if (data === "") {
                            let markup = `<option value="USD">USD</option>`;
                            $('#supported_currency').append(markup);
                        }

                        let markup = '<option value="">Selected Currency</option>';
                        $('#supported_currency').append(markup);

                        $(data).each(function (index, value) {

                            let markup = `<option value="${value}">${value}</option>`;
                            $('#supported_currency').append(markup);
                        });
                    },
                    error: function (error) {
                        console.error('AJAX Error:', error);
                    }
                });
            }


            $(document).on('change, input', "#amount, #supported_currency, .selectPayment", function (e) {
                let amount = amountField.val();
                let selectedCurrency = $('#supported_currency').val();
                let currency_type = 1;


                if (!isNaN(amount) && amount > 0) {

                    let fraction = amount.split('.')[1];
                    let limit = currency_type == 0 ? 8 : 2;


                    if (fraction && fraction.length > limit) {
                        amount = (Math.floor(amount * Math.pow(10, limit)) / Math.pow(10, limit)).toFixed(limit);
                        amountField.val(amount);
                    }

                    checkAmount(amount, selectedCurrency, selectedGateway)

                    if (selectedCurrency != null) {

                    }
                } else {
                    clearMessage(amountField)
                    $('.showCharge').html('')
                }
            });


            function checkAmount(amount, selectedCurrency, selectGateway) {

                $.ajax({
                    method: "GET",
                    url: "<?php echo e(route('deposit.checkAmount')); ?>",
                    dataType: "json",
                    data: {
                        'amount': amount,
                        'selected_currency': selectedCurrency,
                        'select_gateway': selectGateway,
                    }
                }).done(function (response) {



                    let amountField = $('#amount');
                    if (response.status) {
                        clearMessage(amountField);
                        $(amountField).addClass('is-valid');
                        $(amountField).closest('div').find(".valid-feedback").html(response.message);
                        amountStatus = true;
                        // submitButton();
                        showCharge(response, response.currency);
                    } else {
                        amountStatus = false;
                        // submitButton();
                        $('.showCharge').html('');
                        clearMessage(amountField);
                        $(amountField).addClass('is-invalid');
                        $(amountField).closest('div').find(".invalid-feedback").html(response.message);
                    }


                });
            }

            function showCharge(response, currency) {
                let txnDetails = `<li class="item"><span><?php echo e($subscriptionPlan->plan_name); ?></span><span><?php echo e($subscriptionPlan->price); ?> <?php echo e(basicControl()->base_currency); ?></span></li>
                <li class="item"><span><?php echo e(__('Payment Method')); ?></span><h6>${response.gatewayName}</span></li>
            <li class="item text-danger"><span><?php echo e(__('Transfer Charge')); ?></span><span>${response.percentage_charge} + ${response.fixed_charge} = ${response.charge} ${response.base_currency}</span></li>
            <li class="item"><span><?php echo e(__('Exchange Rate')); ?></span><span>1  ${response.base_currency} <i class="fa-light fa-arrow-right-arrow-left fa-sm"></i>  ${response.conversion_rate} ${currency}</span></li>
            <li class="item"><span><strong><?php echo e(__('You will pay')); ?></strong></span><span><strong>${response.payable_amount} ${response.currency}</strong></span></li>
            `;
                $('.showCharge').html(txnDetails)
            }

        });
    </script>

    <?php if($errors->any()): ?>
        <?php
            $collection = collect($errors->all());
            $errors = $collection->unique();
        ?>
        <script>
            "use strict";
            <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.failure("<?php echo e(trans($error)); ?>");
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xamp\htdocs\swift-send\resources\views/themes/light/user/subscription/create.blade.php ENDPATH**/ ?>