<!-- Navbar Vertical -->
<aside
    class="js-navbar-vertical-aside navbar navbar-vertical-aside navbar-vertical navbar-vertical-fixed navbar-expand-xl navbar-vertical-aside-initialized
    <?php echo e(in_array(session()->get('themeMode'), [null, 'auto'] )?  'navbar-dark bg-dark ' : 'navbar-light bg-white'); ?>">
    <div class="navbar-vertical-container">
        <div class="navbar-vertical-footer-offset">
            <!-- Logo -->
            <a class="navbar-brand" href="<?php echo e(route('admin.dashboard')); ?>" aria-label="<?php echo e($basicControl->site_title); ?>">
                <img class="navbar-brand-logo navbar-brand-logo-auto"
                     src="<?php echo e(getFile(session()->get('themeMode') == 'auto'?$basicControl->admin_dark_mode_logo_driver : $basicControl->admin_logo_driver, session()->get('themeMode') == 'auto'?$basicControl->admin_dark_mode_logo:$basicControl->admin_logo, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="default">

                <img class="navbar-brand-logo"
                     src="<?php echo e(getFile($basicControl->admin_dark_mode_logo_driver, $basicControl->admin_dark_mode_logo, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="dark">

                <img class="navbar-brand-logo-mini"
                     src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="default">
                <img class="navbar-brand-logo-mini"
                     src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                     alt="Logo"
                     data-hs-theme-appearance="dark">
            </a>
            <!-- End Logo -->

            <!-- Navbar Vertical Toggle -->
            <button type="button" class="js-navbar-vertical-aside-toggle-invoker navbar-aside-toggler">
                <i class="bi-arrow-bar-left navbar-toggler-short-align"
                   data-bs-template='<div class="tooltip d-none d-md-block" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                   data-bs-toggle="tooltip"
                   data-bs-placement="right"
                   title="Collapse">
                </i>
                <i
                    class="bi-arrow-bar-right navbar-toggler-full-align"
                    data-bs-template='<div class="tooltip d-none d-md-block" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                    data-bs-toggle="tooltip"
                    data-bs-placement="right"
                    title="Expand"
                ></i>
            </button>
            <!-- End Navbar Vertical Toggle -->


            <!-- Content -->
            <div class="navbar-vertical-content">
                <div id="navbarVerticalMenu" class="nav nav-pills nav-vertical card-navbar-nav">

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.dashboard'])); ?>"
                           href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="bi-house-door nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Dashboard"); ?>
                            </span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.country.index','admin.country.edit','admin.country.create',
                                       'admin.countryState','admin.state.create','admin.state.edit',
                                       'admin.stateCity','admin.city.create', 'admin.city.edit',
                                       'admin.countryBank','admin.bank.create', 'admin.bank.edit',
                                       'admin.countryService','admin.service.create', 'admin.service.edit',
                                       ])); ?>"
                           href="<?php echo e(route('admin.country.index')); ?>">
                            <i class="bi bi-globe nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Countries"); ?>
                            </span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-4"><?php echo app('translator')->get('Manage Plan'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.plan','admin.planCreate','admin.planEdit','admin.planUpdate'])); ?>"
                           href="<?php echo e(route('admin.plan')); ?>" data-placement="left">
                            <i class="fa-light fa-recycle nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Subscription Plan"); ?></span>
                        </a>

                        <a class="nav-link <?php echo e(menuActive(['admin.subscription.list'])); ?>"
                           href="<?php echo e(route('admin.subscription.list')); ?>" data-placement="left">
                            <i class="fa-light fa-paper-plane nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Subscription List"); ?></span>
                        </a>

                        <a class="nav-link <?php echo e(menuActive(['admin.prepaidCredits','admin.prepaidCreditCreate','admin.prepaidCreditUpdate'])); ?>"
                           href="<?php echo e(route('admin.prepaidCredits')); ?>" data-placement="left">
                            <i class="fa-light fas fa-cubes nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Verification Credits"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-4"><?php echo app('translator')->get('Generated History'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.automation','admin.automation.show','admin.automationStatics','admin.automationDelete'])); ?>"
                           href="<?php echo e(route('admin.automation')); ?>" data-placement="left">
                            <i class="fal fa-tachometer-alt-slow nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Automations"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.singleSendList','admin.singleSendStats'])); ?>"
                           href="<?php echo e(route('admin.singleSendList')); ?>" data-placement="left">
                            <i class="fal fa-paper-plane nav-icon "></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Single Send"); ?></span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.contactGroup'])); ?>"
                           href="<?php echo e(route('admin.contactGroup')); ?>" data-placement="left">
                            <i class="fal fa-tags nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Contact Group"); ?></span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.contactList'])); ?>"
                           href="<?php echo e(route('admin.contactList')); ?>" data-placement="left">
                            <i class="fal fa-id-card-alt nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Contacts"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.segmentList'])); ?>"
                           href="<?php echo e(route('admin.segmentList')); ?>" data-placement="left">
                            <i class="fal fa-tools nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Segments"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.customField'])); ?>"
                           href="<?php echo e(route('admin.customField')); ?>" data-placement="left">
                            <i class="fas fa-tasks nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Custom Field"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.senderList'])); ?>"
                           href="<?php echo e(route('admin.senderList')); ?>" data-placement="left">
                            <i class="far fa-envelope nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Senders"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.emailNotification'])); ?>"
                           href="<?php echo e(route('admin.emailNotification')); ?>" data-placement="left">
                            <i class="fal fa-bell-on nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Notification"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.unsubscribesGroup'])); ?>"
                           href="<?php echo e(route('admin.unsubscribesGroup')); ?>" data-placement="left">
                            <i class="fal fa-layer-group nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Unsubscribe Group"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.globalUnsubscribes'])); ?>"
                           href="<?php echo e(route('admin.globalUnsubscribes')); ?>" data-placement="left">
                            <i class="fal fa-users nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Global Unsubscribers"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.apiRecipient'])); ?>"
                           href="<?php echo e(route('admin.apiRecipient')); ?>" data-placement="left">
                            <i class="fal fa-key nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Api Recipients"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-4"><?php echo app('translator')->get('Transactions'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.transaction'])); ?>"
                           href="<?php echo e(route('admin.transaction')); ?>" data-placement="left">
                            <i class="bi bi-send nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Transaction"); ?></span>
                        </a>
                    </div>

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.payment.log'])); ?>"
                           href="<?php echo e(route('admin.payment.log')); ?>" data-placement="left">
                            <i class="bi bi-credit-card-2-front nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Payment Log"); ?></span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.payment.pending'])); ?>"
                           href="<?php echo e(route('admin.payment.pending')); ?>" data-placement="left">
                            <i class="bi bi-cash nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Payment Request"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-4"> <?php echo app('translator')->get("Ticket Panel"); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.ticket','admin.ticket.*'], 3)); ?>"
                           href="#navbarVerticalTicketMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalTicketMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalTicketMenu">
                            <i class="fa-light fa-headset nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Support Ticket"); ?></span>
                        </a>
                        <div id="navbarVerticalTicketMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.ticket','admin.ticket.*'], 2)); ?>"
                             data-bs-parent="#navbarVerticalTicketMenu">
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/all') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'all')); ?>"><?php echo app('translator')->get("All Tickets"); ?>
                            </a>
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/answered') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'answered')); ?>"><?php echo app('translator')->get("Answered Ticket"); ?></a>
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/replied') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'replied')); ?>"><?php echo app('translator')->get("Replied Ticket"); ?></a>
                            <a class="nav-link <?php echo e(request()->is('admin/tickets/closed') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.ticket', 'closed')); ?>"><?php echo app('translator')->get("Closed Ticket"); ?></a>
                        </div>
                    </div>

                    <span class="dropdown-header mt-4"><?php echo app('translator')->get('Subscribers'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.subscriber.index'])); ?>"
                           href="<?php echo e(route('admin.subscriber.index')); ?>" data-placement="left">
                            <i class="fa-light fa-mail-bulk nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Subscriber"); ?></span>
                        </a>
                    </div>

                    <span class="dropdown-header mt-4"> <?php echo app('translator')->get('Kyc Management'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.kyc.form.list'])); ?>"
                           href="<?php echo e(route('admin.kyc.form.list')); ?>" data-placement="left">
                            <i class="bi-stickies nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('KYC Setting'); ?></span>
                        </a>
                    </div>

                    <div class="nav-item" <?php echo e(menuActive(['admin.kyc.list'], 3)); ?>>
                        <a class="nav-link dropdown-toggle collapsed" href="#navbarVerticalKycRequestMenu"
                           role="button"
                           data-bs-toggle="collapse" data-bs-target="#navbarVerticalKycRequestMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalKycRequestMenu">
                            <i class="bi bi-person-lines-fill nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("KYC Request"); ?></span>
                        </a>
                        <div id="navbarVerticalKycRequestMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.kyc.list'], 2)); ?>"
                             data-bs-parent="#navbarVerticalKycRequestMenu">
                            <a class="nav-link <?php echo e(Request::is('admin/kyc/pending') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'pending')); ?>">
                                <?php echo app('translator')->get('Pending KYC'); ?>
                            </a>
                            <a class="nav-link <?php echo e(Request::is('admin/kyc/approve') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'approve')); ?>">
                                <?php echo app('translator')->get('Approved KYC'); ?>
                            </a>
                            <a class="nav-link <?php echo e(Request::is('admin/kyc/rejected') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'rejected')); ?>">
                                <?php echo app('translator')->get('Rejected KYC'); ?>
                            </a>
                        </div>
                    </div>

                    <span class="dropdown-header mt-4"> <?php echo app('translator')->get("User Panel"); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>

                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.users','admin.mail.all.user'], 3)); ?>"
                           href="#navbarVerticalUserPanelMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalUserPanelMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalUserPanelMenu">
                            <i class="bi-people nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('User Management'); ?></span>
                        </a>
                        <div id="navbarVerticalUserPanelMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.users','admin.mail.all.user'], 2)); ?>"
                             data-bs-parent="#navbarVerticalUserPanelMenu">
                            <a class="nav-link <?php echo e(menuActive(['admin.users'])); ?>" href="<?php echo e(route('admin.users')); ?>">
                                <?php echo app('translator')->get('All User'); ?>
                            </a>
                            <a class="nav-link <?php echo e(menuActive(['admin.mail.all.user'])); ?>"
                               href="<?php echo e(route("admin.mail.all.user")); ?>"><?php echo app('translator')->get('Mail To Users'); ?></a>
                        </div>
                    </div>


                    <span class="dropdown-header mt-4"> <?php echo app('translator')->get('SETTINGS PANEL'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(controlPanelRoutes())); ?>"
                           href="<?php echo e(route('admin.settings')); ?>" data-placement="left">
                            <i class="bi bi-gear nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Control Panel'); ?></span>
                        </a>
                    </div>

                    <div
                        class="nav-item <?php echo e(menuActive(['admin.payment.methods','admin.edit.payment.methods','admin.update.payment.methods', 'admin.deposit.manual.index','admin.deposit.manual.create','admin.deposit.manual.edit'], 3)); ?>">
                        <a class="nav-link dropdown-toggle"
                           href="#navbarVerticalGatewayMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalGatewayMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalGatewayMenu">
                            <i class="bi-briefcase nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Payment Setting'); ?></span>
                        </a>
                        <div id="navbarVerticalGatewayMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.payment.methods','admin.edit.payment.methods','admin.update.payment.methods', 'admin.deposit.manual.index','admin.deposit.manual.create','admin.deposit.manual.edit'], 2)); ?>"
                             data-bs-parent="#navbarVerticalGatewayMenu">
                            <a class="nav-link <?php echo e(menuActive(['admin.payment.methods','admin.edit.payment.methods','admin.update.payment.methods'])); ?>"
                               href="<?php echo e(route('admin.payment.methods')); ?>"><?php echo app('translator')->get('Payment Gateway'); ?></a>
                            <a class="nav-link <?php echo e(menuActive(['admin.deposit.manual.index','admin.deposit.manual.create','admin.deposit.manual.edit'])); ?>"
                               href="<?php echo e(route('admin.deposit.manual.index')); ?>"><?php echo app('translator')->get('Manual Gateway'); ?></a>
                        </div>
                    </div>

                    <span class="dropdown-header mt-4"><?php echo app('translator')->get("Themes Settings"); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div id="navbarVerticalThemeMenu">
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.page.index'])); ?>"
                               href="<?php echo e(route('admin.page.index', basicControl()->theme)); ?>"
                               data-placement="left">
                                <i class="fa-light fa-list nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Pages'); ?></span>
                            </a>
                        </div>

                        <div class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('admin.manage.menu')); ?>" data-placement="left">
                                <i class="bi-folder2-open nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Manage Menu'); ?></span>
                            </a>
                        </div>
                    </div>

                    <?php
                        $segments = request()->segments();
                        $last  = end($segments);
                    ?>
                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.manage.content', 'admin.manage.content.multiple', 'admin.content.item.edit*'], 3)); ?>"
                           href="#navbarVerticalContentsMenu"
                           role="button" data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalContentsMenu" aria-expanded="false"
                           aria-controls="navbarVerticalContentsMenu">
                            <i class="fa-light fa-section nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Manage Content'); ?></span>
                        </a>
                        <div id="navbarVerticalContentsMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.manage.content', 'admin.manage.content.multiple', 'admin.content.item.edit*'], 2)); ?>"
                             data-bs-parent="#navbarVerticalContentsMenu">
                            <?php $__currentLoopData = array_diff(array_keys(config('contents')), ['message','content_media']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="talk-nav-link">
                                    <a class="nav-link <?php echo e(($last == $name) ? 'active' : ''); ?>"
                                       href="<?php echo e(route('admin.manage.content', $name)); ?>"><?php echo app('translator')->get(stringToTitle($name)); ?></a>
                                    <?php
                                        $previewImg = @asset(config('contents')[$name]['preview']);
                                    ?>
                                    <?php if($previewImg): ?>
                                        <div class="talk-nav-link-icon">
                                            <a href="<?php echo e($previewImg); ?>"
                                               data-fancybox="gallery"><i class="fa-light fa-eye"></i></a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <?php $__currentLoopData = collect(config('generalsettings.settings')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="nav-item d-none">
                            <a class="nav-link  <?php echo e(isMenuActive($setting['route'])); ?>"
                               href="<?php echo e(getRoute($setting['route'], $setting['route_segment'] ?? null)); ?>">
                                <i class="<?php echo e($setting['icon']); ?> nav-icon"></i>
                                <span class="nav-link-title"><?php echo e(__(getTitle($key.' '.'Settings'))); ?></span>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>

                <div class="navbar-vertical-footer">
                    <ul class="navbar-vertical-footer-list">
                        <li class="navbar-vertical-footer-list-item">
                            <span class="dropdown-header"><?php echo app('translator')->get('Version 2.6'); ?></span>
                        </li>
                        <li class="navbar-vertical-footer-list-item">
                            <div class="dropdown dropup">
                                <button type="button" class="btn btn-ghost-secondary btn-icon rounded-circle"
                                        id="selectThemeDropdown" data-bs-toggle="dropdown" aria-expanded="false"
                                        data-bs-dropdown-animation></button>
                                <div class="dropdown-menu navbar-dropdown-menu navbar-dropdown-menu-borderless"
                                     aria-labelledby="selectThemeDropdown">
                                    <a class="dropdown-item" href="javascript:void(0)" data-icon="bi-moon-stars"
                                       data-value="auto">
                                        <i class="bi-moon-stars me-2"></i>
                                        <span class="text-truncate"
                                              title="Auto (system default)"><?php echo app('translator')->get("Default"); ?></span>
                                    </a>
                                    <a class="dropdown-item" href="javascript:void(0)" data-icon="bi-brightness-high"
                                       data-value="default">
                                        <i class="bi-brightness-high me-2"></i>
                                        <span class="text-truncate"
                                              title="Default (light mode)"><?php echo app('translator')->get("Light Mode"); ?></span>
                                    </a>
                                    <a class="dropdown-item active" href="javascript:void(0)" data-icon="bi-moon"
                                       data-value="dark">
                                        <i class="bi-moon me-2"></i>
                                        <span class="text-truncate" title="Dark"><?php echo app('translator')->get("Dark Mode"); ?></span>
                                    </a>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</aside>




<?php /**PATH D:\server\htdocs\swift-send\project\resources\views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>