<?php $__env->startSection('page_title', __('Edit Payment Method')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Payment Method'); ?></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Edit ' . $method->name); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Edit ' . $method->name); ?></h1>
                </div>
            </div>
        </div>

        <div class="row payment_method">
            <div class="col-lg-12">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <h3 class="card-title mt-2"><?php echo app('translator')->get('Edit ' . $method->name); ?></h3>
                        </div>
                        <div class="card-body mt-2">
                            <form action="<?php echo e(route('admin.update.payment.methods', $method->id)); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <div class="row mb-4">
                                    <div class="col-sm-6">
                                        <label for="nameLabel" class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                                        <input type="text" class="form-control  <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="name" id="nameLabel"
                                               placeholder="Name" aria-label="Name" autocomplete="off"
                                               value="<?php echo e(old('name', $method->name ?? '')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <?php if($method->currencies): ?>
                                        <div class="col-sm-6">
                                            <label for="currencyLabel"
                                                   class="form-label"><?php echo app('translator')->get('Supported Currency'); ?></label>
                                            <div class="tom-select-custom tom-select-custom-with-tags">
                                                <select class="js-select form-select supported_currency"
                                                        name="receivable_currencies[][name]" autocomplete="off"
                                                        multiple
                                                        data-hs-tom-select-options='{
                                                        "placeholder": "Select Currency",
                                                      }' required>
                                                    <?php
                                                        $paymentMethodsCurrency = session()->has('selectedCurrencyList')
                                                            ? session('selectedCurrencyList')
                                                            : (isset($method->supported_currency) ? $method->supported_currency : []);
                                                    ?>
                                                    <?php $__empty_1 = true; $__currentLoopData = $method->currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <?php $__currentLoopData = $currency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $curKey => $singleCurrency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                $isSelected = in_array($curKey, (array) $paymentMethodsCurrency);
                                                            ?>
                                                            <option
                                                                value="<?php echo e($curKey); ?>" <?php echo e($isSelected ? 'selected' : ''); ?>>
                                                                <?php echo e(trans($curKey)); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                            <?php $__errorArgs = ['receivable_currencies.0.name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>


                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-header-title"><?php echo app('translator')->get('Parameters'); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <?php $__currentLoopData = $method->parameters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-sm-6 mb-4">
                                                    <div class="form-group">
                                                        <label class="form-label"
                                                               for="<?php echo e($key); ?>"><?php echo app('translator')->get(snake2Title($key)); ?></label>
                                                        <input type="text" name="<?php echo e($key); ?>"
                                                               value="<?php echo e(old($key, $parameter)); ?>"
                                                               id="<?php echo e($key); ?>"
                                                               class="form-control <?php $__errorArgs = [$key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                        <div class="invalid-feedback">
                                                            <?php $__errorArgs = [$key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>

                                        <?php if($method->extra_parameters): ?>
                                            <div class="row">
                                                <?php $__currentLoopData = $method->extra_parameters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $param): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-sm-6 mb-5">
                                                        <label class="form-label"
                                                               for="<?php echo e($key); ?>"><?php echo app('translator')->get(snake2Title($key)); ?></label>
                                                        <div class="input-group input-group-merge">
                                                            <input type="text" id="extraParameters<?php echo e($key); ?>"
                                                                   name="<?php echo e($key); ?>"
                                                                   class="form-control <?php $__errorArgs = [$key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                   value="<?php echo e(old($key, route($param, $method->code ))); ?>"
                                                                   readonly>
                                                            <a class="js-clipboard input-group-append input-group-text"
                                                               href="javascript:void(0);" data-bs-toggle="tooltip"
                                                               title="Copy to clipboard!"
                                                               data-hs-clipboard-options='{
                                                               "type": "tooltip",
                                                               "successText": "Copied!",
                                                               "contentTarget": "#extraParameters<?php echo e($key); ?>"
                                                             }'>
                                                                <i class="bi-clipboard"></i>
                                                            </a>
                                                            <span class="invalid-feedback">
                                                    <?php $__errorArgs = [$key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </span>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-12 mt-4">
                                        <label class="form-label" for="descriptionArea"><?php echo app('translator')->get("Description"); ?></label>
                                        <textarea id="descriptionArea" class="form-control" name="description"
                                                  placeholder="Description"
                                                  rows="3"><?php echo e(old('description', $method->description)); ?></textarea>
                                        <span class="invalid-feedback">
                                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </span>
                                    </div>
                                </div>
                                <?php if($method->note): ?>
                                    <div class="row">
                                        <div class="col-md-12 mt-4">
                                            <label class="form-label" for="Note"><?php echo app('translator')->get("Note"); ?></label>
                                            <textarea id="Note" class="form-control"
                                                      rows="3" readonly><?php echo e($method->note); ?></textarea>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="row my-lg-5">
                                    <div class="col-md-3">
                                        <label class="form-check form-check-dashed" for="logoUploader">
                                            <img id="logoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 rounded"
                                                 src="<?php echo e(getFile($method->driver, $method->image, true)); ?>"
                                                 alt="Image Description" data-hs-theme-appearance="default">
                                            <img id="logoImg"
                                                 class="avatar avatar-xl avatar-4x3 avatar-centered h-100 mb-2 rounded"
                                                 src="<?php echo e(getFile($method->driver, $method->image, true)); ?>"
                                                 alt="Image Description" data-hs-theme-appearance="dark">
                                            <span class="d-block"><?php echo app('translator')->get("Browse your file here"); ?></span>
                                            <input type="file" class="js-file-attach form-check-input" name="image"
                                                   id="logoUploader" data-hs-file-attach-options='{
                                                      "textTarget": "#logoImg",
                                                      "mode": "image",
                                                      "targetAttr": "src",
                                                      "allowTypes": [".png", ".jpeg", ".jpg"]
                                                   }'>
                                        </label>
                                        <span class="invalid-feedback d-block">
                                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </span>
                                    </div>
                                    <div class="col-md-9">
                                        <div class="list-group list-group-lg list-group-flush list-group-no-gutters">
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span class="d-block text-dark"><?php echo app('translator')->get("Status"); ?></span>
                                                                <p class="fs-5 text-body mb-0"><?php echo app('translator')->get("Enable to your gateway status"); ?></p>
                                                            </div>
                                                            <div class="col-auto">
                                                                <div class="form-check form-switch">
                                                                    <input type="hidden" name="is_active" value="0">
                                                                    <input type="checkbox" class="form-check-input"
                                                                           name="is_active"
                                                                           id="isActiveSwitch"
                                                                           value="1" <?php echo e($method->status == 1 ? 'checked' : ''); ?>>
                                                                    <label class="form-check-label"
                                                                           for="isActiveSwitch"></label>
                                                                </div>
                                                                <span class="invalid-feedback">
                                                                    <?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- End List Item -->

                                            <!-- List Item -->
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span
                                                                    class="d-block text-dark"><?php echo app('translator')->get("Test Environment"); ?></span>
                                                                <p class="fs-5 text-body mb-0"><?php echo app('translator')->get("To test your payment gateway, set up a sandbox environment."); ?></p>
                                                            </div>
                                                            <div class="col-auto">
                                                                <div class="form-check form-switch">
                                                                    <input type="hidden" name="test_environment"
                                                                           value="live">
                                                                    <input type="checkbox" class="form-check-input"
                                                                           name="test_environment"
                                                                           id="testEnvironmentSwitch"
                                                                           value="test" <?php echo e($method->environment == 'test' ? 'checked' : ''); ?>>
                                                                    <label class="form-check-label"
                                                                           for="testEnvironmentSwitch"></label>
                                                                </div>
                                                                <span class="invalid-feedback">
                                                                    <?php $__errorArgs = ['test_environment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php if($method->is_subscription): ?>
                                                <div class="list-group-item">
                                                    <div class="d-flex">
                                                        <div class="flex-grow-1">
                                                            <div class="row align-items-center">
                                                                <div class="col">
                                                                <span
                                                                    class="d-block text-dark"><?php echo app('translator')->get("Automatic Subscription"); ?></span>
                                                                    <p class="fs-5 text-body mb-0"><?php echo app('translator')->get("To set automatic billing circle, set up a subscription environment."); ?></p>
                                                                </div>
                                                                <div class="col-auto">
                                                                    <div class="form-check form-switch">
                                                                        <input type="hidden" name="subscription_on"
                                                                               value="0">
                                                                        <input type="checkbox" class="form-check-input"
                                                                               name="subscription_on"
                                                                               id="subscription_on"
                                                                               value="1" <?php echo e($method->subscription_on == '1' ? 'checked' : ''); ?>>
                                                                        <label class="form-check-label"
                                                                               for="subscription_on"></label>
                                                                    </div>
                                                                    <span class="invalid-feedback">
                                                                    <?php $__errorArgs = ['subscription_on'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="card supported_currency_card mt-lg-5">
                                    <div class="card-header">
                                        <h4 class="card-header-title"><?php echo app('translator')->get('Supported Currencies Configuration'); ?></h4>
                                    </div>
                                    <div class="table-responsive position-relative">
                                        <table
                                            class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                                            id="supported_currency_table">
                                            <thead class="thead-light">
                                            <tr>
                                                <th scope="col"><?php echo app('translator')->get('Currency Symbol'); ?></th>
                                                <th scope="col"><?php echo app('translator')->get('Conversion Rate'); ?></th>
                                                <th scope="col"><?php echo app('translator')->get('Min Limit'); ?></th>
                                                <th scope="col"><?php echo app('translator')->get('Max Limit'); ?></th>
                                                <th scope="col"><?php echo app('translator')->get('Percentage Charge'); ?></th>
                                                <th scope="col"><?php echo app('translator')->get('Fixed Charge'); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody class="add_table_row">
                                            <?php
                                                $oldReceivableCurrency = old('receivable_currencies', $method->receivable_currencies) ? count(old('receivable_currencies', $method->receivable_currencies)) : 0;
                                                $oldSelectedCurrency = session()->get('selectedCurrencyList');
                                            ?>
                                            <?php if($oldReceivableCurrency > 0): ?>
                                                <?php for($i = 0; $i < $oldReceivableCurrency; $i++): ?>
                                                    <tr class="<?php echo e($oldSelectedCurrency[$i] ?? $method->receivable_currencies[$i]->name); ?>-row">
                                                        <td>
                                                            <div class="mb-1">
                                                                <input type="text" class="form-control"
                                                                       name="receivable_currencies[<?php echo e($i); ?>][currency_symbol]"
                                                                       placeholder="Currency Symbol"
                                                                       aria-label="Currency Symbol"
                                                                       value="<?php echo e(old("receivable_currencies.$i.currency_symbol",  $method->receivable_currencies[$i]->name ?? '')); ?>"
                                                                       autocomplete="off">
                                                                <?php $__errorArgs = ["receivable_currencies.$i.currency_symbol"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span
                                                                    class="invalid-feedback d-block mb-1"><?php echo e($message); ?></span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <div class="input-group mb-1">
                                                                <span class="input-group-text"> 1 <?php echo e($basicControl->base_currency ? : 'USD'); ?> = </span>
                                                                <input type="text"
                                                                       class="form-control <?php $__errorArgs = ['conversion_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                       name="receivable_currencies[<?php echo e($i); ?>][conversion_rate]"
                                                                       value="<?php echo e(old("receivable_currencies.$i.conversion_rate", $method->receivable_currencies[$i]->conversion_rate ?? '')); ?>"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text"><?php echo e(old("receivable_currencies.$i.name", $method->currency_type == 1 ? $method->receivable_currencies[$i]->name : 'USD')); ?></span>
                                                                <?php $__errorArgs = ["receivable_currencies.$i.conversion_rate"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span
                                                                    class="invalid-feedback d-block mb-1"><?php echo e($message); ?></span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <div class="input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control <?php $__errorArgs = ['min_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                       name="receivable_currencies[<?php echo e($i); ?>][min_limit]"
                                                                       aria-label="Amount (to the nearest dollar)"
                                                                       value="<?php echo e(old("receivable_currencies.$i.min_limit", $method->receivable_currencies[$i]->min_limit ?? '')); ?>"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text"><?php echo e(old("receivable_currencies.$i.name", $method->currency_type == 1 ? $method->receivable_currencies[$i]->name : "USD")); ?></span>
                                                                <?php $__errorArgs = ["receivable_currencies.$i.min_limit"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span
                                                                    class="invalid-feedback d-block mb-1"><?php echo e($message); ?></span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control <?php $__errorArgs = ['max_limit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                       name="receivable_currencies[<?php echo e($i); ?>][max_limit]"
                                                                       aria-label="Amount"
                                                                       value="<?php echo e(old("receivable_currencies.$i.max_limit", $method->receivable_currencies[$i]->max_limit ?? '')); ?>"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text"><?php echo e(old("receivable_currencies.$i.name", $method->currency_type == 1 ? $method->receivable_currencies[$i]->name : "USD")); ?></span>
                                                                <?php $__errorArgs = ["receivable_currencies.$i.max_limit"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span
                                                                    class="invalid-feedback d-block mb-1"><?php echo e($message); ?></span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control <?php $__errorArgs = ['percentage_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                       name="receivable_currencies[<?php echo e($i); ?>][percentage_charge]"
                                                                       aria-label="Amount (to the nearest dollar)"
                                                                       value="<?php echo e(old("receivable_currencies.$i.percentage_charge", $method->receivable_currencies[$i]->percentage_charge ?? "")); ?>"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text">%</span>
                                                                <?php $__errorArgs = ["receivable_currencies.$i.percentage_charge"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span
                                                                    class="invalid-feedback d-block mb-1"><?php echo e($message); ?></span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group mb-1">
                                                                <input type="text"
                                                                       class="form-control <?php $__errorArgs = ['fixed_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                       name="receivable_currencies[<?php echo e($i); ?>][fixed_charge]"
                                                                       aria-label="Amount (to the nearest dollar)"
                                                                       value="<?php echo e(old("receivable_currencies.$i.fixed_charge", $method->receivable_currencies[$i]->fixed_charge ?? '')); ?>"
                                                                       autocomplete="off">
                                                                <span
                                                                    class="input-group-text"><?php echo e(old("receivable_currencies.$i.name", $method->currency_type == 1 ? $method->receivable_currencies[$i]->name : "USD")); ?></span>
                                                                <?php $__errorArgs = ["receivable_currencies.$i.fixed_charge"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span
                                                                    class="invalid-feedback d-block mb-1"><?php echo e($message); ?></span>
                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endfor; ?>
                                            <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-start mt-4">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/hs-file-attach.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/clipboard.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).ready(function () {

            var eventHandler = function (name) {
                return function () {
                    if (name == 'onItemAdd') {
                        itemAppend(arguments[0]);
                    } else if (name == 'onItemRemove') {
                        itemRemove(arguments[0][0]);
                    }
                };
            };

            var tomSelect = new TomSelect('.js-select', {
                plugins: {
                    remove_button: {
                        title: '',
                    },
                },
                create: true,
                onItemAdd: eventHandler('onItemAdd'),
                onDelete: eventHandler('onItemRemove'),
            });


            let method = <?php echo json_encode($method, 15, 512) ?>;

            function itemAppend(currency) {
                let rowCount = $('#supported_currency_table tr').length;
                currency = method.currency_type === 1 ? currency : 'USD';
                let markup = "";
                markup += `
                        <tr class="${currency}-row">
                                <td>
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control" name="receivable_currencies[${rowCount - 1}][currency_symbol]"
                                           placeholder="<?php echo app('translator')->get("Currency Symbol"); ?>" aria-label="<?php echo app('translator')->get("Currency Symbol"); ?>"
                                           autocomplete="off">
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text">1 <?php echo e($basicControl->base_currency); ?> = </span>
                                        <input type="text"
                                            class="form-control"
                                            name="receivable_currencies[${rowCount - 1}][conversion_rate]"
                                            autocomplete="off">
                                            <span class="input-group-text">${currency}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control"
                                          name="receivable_currencies[${rowCount - 1}][min_limit]"
                                          autocomplete="off">
                                          <span class="input-group-text">${currency}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control"
                                            name="receivable_currencies[${rowCount - 1}][max_limit]"
                                            autocomplete="off">
                                            <span class="input-group-text">${currency}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control"
                                            name="receivable_currencies[${rowCount - 1}][percentage_charge]"
                                            autocomplete="off">
                                            <span class="input-group-text">%</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control"
                                             name="receivable_currencies[${rowCount - 1}][fixed_charge]"
                                             autocomplete="off">
                                             <span class="input-group-text">${currency}</span>
                                    </div>
                                </td>

                        </tr>`;

                $('.add_table_row').append(markup);
            }

            function itemRemove(currency) {
                $(`.${currency}-row`).remove();
                alignArrayIndexForSupportCurrency();
            }


            function alignArrayIndexForSupportCurrency() {
                $('.add_table_row tr').each(function (index) {
                    $(this).find('input[name^="receivable_currencies"]').each(function () {
                        var newName = $(this).attr('name').replace(/\[(\d+)\]/, '[' + index + ']');
                        $(this).attr('name', newName);
                    })
                })
            }

            new HSFileAttach('.js-file-attach')
            HSCore.components.HSClipboard.init('.js-clipboard')

        });

    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xamp\htdocs\swift-send\resources\views/admin/payment_methods/edit.blade.php ENDPATH**/ ?>