<?php

use App\Http\Controllers\Auth\LoginController as UserLoginController;
use App\Http\Controllers\FrontendController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\User\HomeController;
use App\Http\Controllers\User\DepositController;
use App\Http\Controllers\ManualRecaptchaController;
use App\Http\Controllers\khaltiPaymentController;
use App\Models\Language;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InAppNotificationController;
use App\Http\Controllers\User\SupportController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\User\VerificationController;
use App\Http\Controllers\FaSecurityController;
use App\Http\Controllers\User\UserProfileController;
use App\Http\Controllers\User\SenderController;
use App\Http\Controllers\User\ContactController;
use App\Http\Controllers\User\CustomFieldsController;
use App\Http\Controllers\User\NotificationController;
use App\Http\Controllers\SocialiteController;
use App\Http\Controllers\User\UnsubscribeController;
use App\Http\Controllers\User\SegmentController;
use App\Http\Controllers\User\SingleSendController;
use App\Http\Controllers\UnsubscribePreferenceController;
use App\Http\Controllers\User\AutomationController;
use App\Http\Controllers\User\SubscriptionController;
use App\Http\Controllers\User\BulkEmailValidation;
use App\Http\Controllers\User\PrepaidCreditController;
use Illuminate\Http\Request;

$basicControl = basicControl();

Route::get('paddle', function () {
    return view('paddle');
});

Route::get('maintenance-mode', function () {
    $data['maintenanceMode'] = \App\Models\MaintenanceMode::first();
    return view(template() . 'maintenance', $data);
})->name('maintenance');


Route::get('migrate', function () {
    return Illuminate\Support\Facades\Artisan::call('migrate');
});

Route::get('clear', function () {
    return Illuminate\Support\Facades\Artisan::call('optimize:clear');
});

Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::get('password/reset/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset')->middleware('guest');
Route::post('password/reset', [ResetPasswordController::class, 'reset'])->name('password.reset.update');
Route::get('instruction/page', function () {
    return view('instruction-page');
})->name('instructionPage');


Route::group(['middleware' => ['maintenanceMode']], function () use ($basicControl) {
    Route::group(['middleware' => ['guest']], function () {
        Route::get('/login', [UserLoginController::class, 'showLoginForm'])->name('login');
        Route::post('/login', [UserLoginController::class, 'login'])->name('login.submit');
    });

    Route::get('check', [VerificationController::class, 'check'])->name('check');
    Route::get('resend_code', [VerificationController::class, 'resendCode'])->name('user.resendCode');
    Route::post('mail-verify', [VerificationController::class, 'mailVerify'])->name('user.mailVerify');
    Route::post('sms-verify', [VerificationController::class, 'smsVerify'])->name('user.smsVerify');
    Route::post('twoFA-Verify', [VerificationController::class, 'twoFAverify'])->name('user.twoFA-Verify');

    Route::group(['middleware' => ['auth', 'verifyUser'], 'prefix' => 'user', 'as' => 'user.'], function () {

        Route::get('open-api/generated', [HomeController::class, 'openAiGenerated'])->name('openAiGenerated');

        //BULK EMAIL VALIDATION
        Route::controller(BulkEmailValidation::class)->group(function () {
            Route::any('bulk-email/validation', 'bulkEmailValidation')->name('bulkEmailValidation');
            Route::get('bulk-email/response/{utr}', 'bulkEmailResult')->name('bulkEmailResult');
            Route::get('bulk-email/export', 'bulkEmailExport')->name('bulkEmailExport');
            Route::get('bulk-email/csv-sample/download', 'bulkEmailCsvSample')->name('bulkEmailCsvSample');
        });

        //SUBSCRIPTION
        Route::controller(SubscriptionController::class)->group(function () {
            Route::any('subscription-plan/purchase', 'subscriptionPurchase')->name('subscriptionPurchase');
            Route::any('subscription-process/{utr}', 'subsConfirm')->name('subscription.process');
            Route::get('subscription/list', 'subsList')->name('subscription.list');
            Route::post('subscription/cancel/{id}', 'subsCancel')->name('subscription.cancel');
            Route::post('subscription/renew/{sub_id}', 'subsRenew')->name('subscription.renew');

            Route::any('subscription-plan/purchase/free', 'subscriptionPurchaseFree')->name('subscriptionPurchaseFree');
        });

        //PREPAID CREDITS
        Route::controller(PrepaidCreditController::class)->group(function () {
            Route::any('prepaid-credits/purchase', 'creditsPurchase')->name('creditsPurchase');
        });


        //SENDER
        Route::controller(SenderController::class)->group(function () {
            Route::get('senders', 'index')->name('senderList');
            Route::post('sender/save', 'senderSave')->name('senderSave');
            Route::post('sender/update', 'senderUpdate')->name('senderUpdate');
            Route::get('sender/send-mail/{id}', 'senderSendMail')->name('senderSendMail');
            Route::delete('sender/delete/{id}', 'senderDelete')->name('senderDelete');
            Route::post('get-states-by-country', 'getState')->name('states');
            Route::post('get-cities-by-state', 'getCity')->name('cities');
        });

        //CONTACT
        Route::controller(ContactController::class)->group(function () {
            Route::get('contacts-type', 'contactTypeList')->name('contactTypeList');
            Route::post('contacts-type/save', 'contactTypeSave')->name('contactTypeSave');
            Route::post('contacts-type/update', 'contactTypeUpdate')->name('contactTypeUpdate');
            Route::delete('contacts-type/delete/{id}', 'contactTypeDelete')->name('contactTypeDelete');
            Route::post('contacts-type/bulk-delete', 'contactTypeBulkDelete')->name('contactTypeBulkDelete');
            Route::any('contacts/list/{type_id}', 'contactList')->name('contactList');
            Route::any('contacts/add', 'contactAdd')->name('contactAdd');
            Route::any('contacts/update/{id}', 'contactUpdate')->name('contactUpdate');
            Route::delete('contacts/delete/{id}', 'contactDelete')->name('contactDelete');
            Route::post('contacts/bulk-delete', 'contactBulkDelete')->name('contactBulkDelete');
            Route::any('contacts/upload-csv', 'contactUploadCsv')->name('contactUploadCsv');
            Route::get('contacts/csv-sample/download', 'contactCsvSample')->name('contactCsvSample');
            Route::get('contacts/export-csv/{type_id}', 'contactExportCsv')->name('contactExportCsv');
            Route::get('contacts/export-invalid-emails', 'exportInvalidEmails')->name('exportInvalidEmails');
        });

        //CUSTOM FIELDS
        Route::controller(CustomFieldsController::class)->group(function () {
            Route::get('custom-fields', 'index')->name('customField');
            Route::middleware('Ensure:custom_field')->group(function () {
                Route::post('custom-fields/save', 'customFieldSave')->name('customFieldSave');
                Route::delete('custom-fields/delete/{id}', 'customFieldDelete')->name('customFieldDelete');
                Route::post('custom-fields/bulk-delete', 'customFieldBulkDelete')->name('customFieldBulkDelete');
            });
        });

        //EMAIL NOTIFICATION
        Route::controller(NotificationController::class)->group(function () {
            Route::get('email-notification', 'index')->name('emailNotification');
            Route::middleware('Ensure:notify_recipient')->group(function () {
                Route::post('email-notification/save', 'emailNotificationSave')->name('emailNotificationSave');
                Route::delete('email-notification/delete/{id}', 'emailNotificationDelete')->name('emailNotificationDelete');
                Route::post('email-notification/bulk-delete', 'emailNotificationBulkDelete')->name('emailNotificationBulkDelete');
            });
        });

        //UNSUBSCRIBE
        Route::controller(UnsubscribeController::class)->group(function () {
            Route::get('unsubscribes-groups', 'unsubscribesGroup')->name('unsubscribesGroup');
            Route::get('unsubscribes-groups/create', 'unsubscribesGroupCreate')->name('unsubscribesGroupCreate');
            Route::post('unsubscribes-groups/save', 'unsubscribesGroupSave')->name('unsubscribesGroupSave');
            Route::get('unsubscribes-groups/edit/{id}', 'unsubscribesGroupEdit')->name('unsubscribesGroupEdit');
            Route::post('unsubscribes-groups/update/{id}', 'unsubscribesGroupUpdate')->name('unsubscribesGroupUpdate');
            Route::post('unsubscribes-groups/manually-add', 'unsubscribesGroupManuallyAdd')->name('unsubscribesGroupManuallyAdd');
            Route::any('unsubscribes-groups/upload-csv/{id}', 'unsubscribesGroupUploadCsv')->name('unsubscribesGroupUploadCsv');
            Route::get('unsubscribes-groups/csv-sample/download', 'unsubscribesGroupsCsvSample')->name('unsubscribesGroupsCsvSample');
            Route::get('unsubscribes-groups/export-csv/{id}', 'unsubscribesGroupsExportCsv')->name('unsubscribesGroupsExportCsv');
            Route::get('unsubscribes-groups/recipients-list/{group_id}', 'unsubscribesRecipients')->name('unsubscribesRecipients');
            Route::delete('unsubscribes-groups/recipients-delete/{id}', 'unsubscribesRecipientDelete')->name('unsubscribesRecipientDelete');
            Route::post('unsubscribes-groups/recipients-bulk-delete', 'unsubscribesRecipientBulkDelete')->name('unsubscribesRecipientBulkDelete');

            Route::get('global-unsubscribes', 'globalUnsubscribes')->name('globalUnsubscribes');
            Route::post('global-unsubscribes/save', 'globalUnsubscribesSave')->name('globalUnsubscribesSave');
            Route::get('global-unsubscribes/export', 'globalUnsubscribesExport')->name('globalUnsubscribesExport');
            Route::delete('global-unsubscribes/delete/{id}', 'globalUnsubscribesDelete')->name('globalUnsubscribesDelete');
            Route::post('global-unsubscribes/bulk-delete', 'globalUnsubscribesBulkDelete')->name('globalUnsubscribesBulkDelete');

        });

        //SEGMENT
        Route::controller(SegmentController::class)->group(function () {
            Route::get('segment/list', 'index')->name('segmentList');
            Route::get('segment/create', 'create')->name('segmentCreate');
            Route::post('segment/get-operator', 'getOperator')->name('segmentGetOperator');
            Route::post('segment/get-input', 'getInput')->name('segmentGetInput');

            Route::middleware('Ensure:segmentation')->group(function () {
                Route::post('segment/store', 'store')->name('segmentSave');
                Route::delete('segment/delete/{id}', 'segmentDelete')->name('segmentDelete');
                Route::post('segment/bulk-delete', 'segmentBulkDelete')->name('segmentBulkDelete');
                Route::get('segment/email/list/{segment_id}', 'segmentEmailList')->name('segmentEmailList');
                Route::post('segment/email/store', 'segmentEmailStore')->name('segmentEmailStore');
                Route::delete('segment/email/delete/{id}', 'segmentEmailDelete')->name('segmentEmailDelete');
                Route::post('segment/email/bulk-delete', 'segmentEmailBulkDelete')->name('segmentEmailBulkDelete');
                Route::get('segment/export-csv/{segment_id}', 'segmentExportCsv')->name('segmentExportCsv');
            });
        });

        //SINGLE SENDS
        Route::controller(SingleSendController::class)->group(function () {
            Route::get('single/send', 'index')->name('singleSendList');
            Route::get('single/send/template', 'showTemplate')->name('singleSendShowTemplate');

            Route::middleware('Ensure:single_send')->group(function () {
                Route::get('single/send/create/{templateId}', 'singleSendCreate')->name('singleSendCreate');
                Route::get('single/send/editor/{utr}', 'singleSendSetting')->name('singleSendSetting')->middleware('Ensure:design_and_code_editors');
                Route::post('single/send/design-save/{utr}', 'singleSendDesignSave')->name('singleSendDesignSave');
                Route::post('single/send/save/{utr}', 'singleSendSave')->name('singleSendSave');

                Route::get('single/send/stats/{utr}', 'singleSendStats')->name('singleSendStats');
                Route::get('single/send/preview/{utr}', 'singleSendPreview')->name('singleSendPreview');
                Route::get('single/send/duplicate/{utr}', 'singleSendDuplicate')->name('singleSendDuplicate');
                Route::delete('single/send/delete/{utr}', 'singleSendDelete')->name('singleSendDelete');
                Route::post('single/send/bulk-delete', 'singleSendBulkDelete')->name('singleSendBulkDelete');
                Route::get('single/send/{utr}', 'singleSendLogs')->name('singleSendLogs');
                Route::get('single/send/get-chart/{utr}', 'singleSendGetChart')->name('singleSendGetChart');
                Route::get('single/send/export-csv/{sender_id}/{type}', 'recipientExportCsv')->name('singleSendRecipientExportCsv');
            });
        });

        //AUTOMATION
        Route::controller(AutomationController::class)->group(function () {
            Route::get('automations', 'index')->name('automation');
            Route::get('automations/choose', 'choose')->name('automationChoose');

            Route::middleware('Ensure:automation')->group(function () {
                Route::get('automations/create/{type}', 'create')->name('automationCreate');
                Route::get('automations/show/{utr}', 'show')->name('automationShow');
                Route::post('automations/schedule/update', 'scheduleUpdate')->name('automationScheduleUpdate');
                Route::post('automations/schedule/add', 'scheduleAdd')->name('automationScheduleAdd');
                Route::post('automations/schedule/delete', 'scheduleDelete')->name('automationScheduleDelete');
                Route::post('automations/schedule/sender', 'scheduleSender')->name('automationScheduleSender');

                Route::get('automations/schedule/template/{utr}', 'scheduleEmailTemplate')->name('automationScheduleEmailTemplate');
                Route::get('automations/schedule/template/{templateId}/{utr}', 'scheduleEmailTemplatePost')->name('automationScheduleEmailTemplatePost');
                Route::get('automations/schedule/email/design/{utr}', 'scheduleEmailDesign')->name('automationScheduleEmailDesign')->middleware('Ensure:design_and_code_editors');
                Route::post('automations/schedule/design/save/{utr}', 'scheduleEmailDesignSave')->name('automationScheduleDesignSave');

                Route::post('automations/save/{utr}', 'automationSave')->name('automationSave');
                Route::post('automations/set-live/{utr}', 'automationSetLive')->name('automationSetLive');

                Route::delete('automations/delete/{utr}', 'automationDelete')->name('automationDelete');
                Route::post('automations/bulk-delete', 'automationBulkDelete')->name('automationBulkDelete');
                Route::get('automations/duplicate/{utr}', 'automationDuplicate')->name('automationDuplicate');
                Route::get('automations/pause/{utr}', 'automationPause')->name('automationPause');
                Route::get('automations/statics/{utr}', 'automationStatics')->name('automationStatics');
                Route::get('automations/get-chart/{utr}', 'automationsGetChart')->name('automationsGetChart');
                Route::get('automations/logs/{utr}', 'automationsLogs')->name('automationsLogs');
                Route::get('automations/export-csv/{automation_id}/{type}', 'recipientExportCsv')->name('automationRecipientExportCsv');
                Route::get('automations/schedule/logs/{utr}', 'automationsScheduleLogs')->name('automationsScheduleLogs');
                Route::get('automations/schedule/export-csv/{schedule_id}', 'ScheduleRecipientExportCsv')->name('ScheduleRecipientExportCsv');
            });
        });


        Route::controller(HomeController::class)->group(function () {
            Route::get('dashboard', 'index')->name('dashboard');
            Route::post('save-token', 'saveToken')->name('save.token');
            Route::post('email-checker', 'emailChecker')->name('emailChecker');

            Route::any('upload-template', 'uploadTemplate')->name('uploadTemplate');
            Route::get('custom-template/list', 'customTemplateList')->name('customTemplateList');
            Route::delete('custom-template/delete/{id}', 'customTemplateDelete')->name('customTemplateDelete');
            Route::get('sample/html/download', 'templateHtmlSample')->name('templateHtmlSample');
            Route::get('sample/json/download', 'templateJSONSample')->name('templateJSONSample');

            Route::get('kyc/{slug}/{id}', 'kycShow')->name('kyc');
            Route::post('kyc/submit/{id}', 'kycVerificationSubmit')->name('kyc.verification.submit');
            Route::get('verification/center', 'verificationCenter')->name('verification.center');
            Route::get('funds', 'fund')->name('fund.index');
            Route::get('transaction', 'transaction')->name('transaction.index');

            Route::any('api-key', 'apiKey')->name('apiKey');
            Route::post('webhook-set', 'webhookSet')->name('webhookSet')->middleware('Ensure:api_uses');
            Route::get('webhook/delete/{code}', 'webhookDelete')->name('webhookDelete')->middleware('Ensure:api_uses');
            Route::get('api/recipients', 'apiRecipient')->name('apiRecipient');
            Route::post('api/recipient/action', 'apiRecipientAction')->name('apiRecipientAction')->middleware('Ensure:api_uses');
            Route::get('activities', 'activity')->name('activity')->middleware('Ensure:activities');
        });

        //USER PROFILE UPDATE
        Route::controller(UserProfileController::class)->group(function () {
            Route::match(['get', 'post'], 'profile', 'index')->name('profile');
            Route::match(['get', 'post'], 'change-password', 'changePassword')->name('change.password');
            Route::match(['get', 'post'], 'notification', 'notification')->name('notification');
        });

        // TWO-FACTOR SECURITY
        Route::controller(FaSecurityController::class)->group(function () {
            Route::get('/twostep-security', 'twoStepSecurity')->name('twostep.security');
            Route::post('twoStep-enable', 'twoStepEnable')->name('twoStepEnable');
            Route::post('twoStep-disable', 'twoStepDisable')->name('twoStepDisable');
        });

        /* ===== In APP Notification ===== */
        Route::controller(InAppNotificationController::class)->group(function () {
            Route::get('push-notification-show', 'show')->name('push.notification.show');
            Route::get('push.notification.readAll', 'readAll')->name('push.notification.readAll');
            Route::get('push-notification-readAt/{id}', 'readAt')->name('push.notification.readAt');
        });

        /* USER SUPPORT TICKET */
        Route::controller(SupportController::class)->group(function () {
            Route::get('tickets', 'index')->name('ticket.list');
            Route::get('ticket-create', 'create')->name('ticket.create');
            Route::post('ticket-create', 'store')->name('ticket.store');
            Route::get('ticket-view/{ticket}', 'view')->name('ticket.view');
            Route::put('ticket-reply/{ticket}', 'reply')->name('ticket.reply');
            Route::get('ticket-download/{ticket}', 'download')->name('ticket.download');
        });
    });

    /* Manage User Deposit */
    Route::controller(DepositController::class)->group(function () {
        Route::get('supported-currency', 'supportedCurrency')->name('supported.currency');
        Route::post('payment-request', 'paymentRequest')->name('payment.request');
        Route::get('deposit-check-amount', 'checkAmount')->name('deposit.checkAmount');
    });


    //SENDER
    Route::controller(UnsubscribePreferenceController::class)->group(function () {
        Route::get('unsubscribe-preference/{params}', 'preferenceShow')->name('unsubscribePreference');
        Route::post('unsubscribe-preference/save/{ownerId}/{email}/{singleSendId}', 'preferenceSave')->name('unsubscribePreferenceSave');

        Route::get('email-track/{utr}/{token}/{email}', 'trackEmail')->name('trackEmail');
        Route::get('automation-track/{id}', 'automationTrack')->name('automationTrack');
        Route::get('automation/unsubscribe/{params}', 'automationUnsubscribe')->name('automationUnsubscribe');
    });

    /* Manage Payment */
    Route::controller(PaymentController::class)->group(function () {
        Route::get('payment-process/{trx_id}', 'depositConfirm')->name('payment.process');
        Route::post('addFundConfirm/{trx_id}', 'fromSubmit')->name('addFund.fromSubmit');
        Route::match(['get', 'post'], 'success', 'success')->name('success');
        Route::match(['get', 'post'], 'failed', 'failed')->name('failed');
        Route::match(['get', 'post'], 'payment/{code}/{trx?}/{type?}', 'gatewayIpn')->name('ipn');
        Route::get('paddle-subscription/{subPurId?}/{trx_id?}', function ($subPurId, $trx_id) {
            Facades\App\Services\Subscription\paddle\Payment::createSubscription($subPurId, $trx_id);
            return redirect()->route('success');
        })->name('paddleSubscription');
    });

    Route::post('khalti/payment/verify/{trx}', [khaltiPaymentController::class, 'verifyPayment'])->name('khalti.verifyPayment');
    Route::post('khalti/payment/store', [khaltiPaymentController::class, 'storePayment'])->name('khalti.storePayment');

    Route::post('subscribe', [FrontendController::class, 'subscribe'])->name('subscribe');
    Route::post('/contact/send', [FrontendController::class, 'contactSend'])->name('contact.send');
    Route::get('blog-details', [FrontendController::class, 'blogDetails'])->name('blog.details');

    Route::get('auth/{socialite}', [SocialiteController::class, 'socialiteLogin'])->name('socialiteLogin');
    Route::get('auth/callback/{socialite}', [SocialiteController::class, 'socialiteCallback'])->name('socialiteCallback');

    /*= Frontend Manage Controller =*/
    Route::get('/sender/verify-mail/{utr}', [FrontendController::class, 'senderVerifyMail'])->name('senderVerifyMail');
    Route::get('/captcha', [ManualRecaptchaController::class, 'reCaptCha'])->name('captcha');
    Auth::routes();

    Route::get('language/{locale}', function ($locale) {
        $language = Language::where('short_name', $locale)->first();
        if (!$language) $locale = 'en';
        session()->put('lang', $locale);
        session()->put('rtl', $language ? $language->rtl : 0);
        return redirect('/');
    })->name('language');

    Route::get("/{slug?}", [FrontendController::class, 'page'])->name('page');
});


