<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\ApiDocumentationController;

Route::controller(ApiDocumentationController::class)->group(function () {
    Route::get('developer/docx', 'apiDocx')->name('apiDocx');
    Route::get('developer/introduction', 'introduction')->name('devIntroduction');
    Route::get('developer/authentication', 'authentication')->name('devAuthentication');


    Route::get('developer/global/unsubscriber-list', 'globalUnSubscriberList')->name('devGlobalUnSubscriberList');
    Route::get('developer/global/unsubscriber-create', 'globalUnSubscriberList')->name('devGlobalUnSubscriberCreate');
    Route::get('developer/global/unsubscriber-delete', 'globalUnSubscriberList')->name('devGlobalUnSubscriberDelete');
    Route::get('developer/global/unsubscriber/bulk-delete', 'globalUnSubscriberList')->name('devGlobalUnSubscriberBulkDelete');

    Route::get('developer/unsubscribes-groups', 'UnSubscriberGroup')->name('devUnSubscriberGroupList');
    Route::get('developer/unsubscribes-groups/create', 'UnSubscriberGroup')->name('devUnSubscriberGroupCreate');
    Route::get('developer/unsubscribes-groups/details', 'UnSubscriberGroup')->name('devUnSubscriberGroupDetails');
    Route::get('developer/unsubscribes-groups/update', 'UnSubscriberGroup')->name('devUnSubscriberGroupUpdate');
    Route::get('developer/unsubscribes-groups/recipient/add', 'UnSubscriberGroup')->name('devUnSubscriberGroupRecipientAdd');
    Route::get('developer/unsubscribes-groups/recipient/list', 'UnSubscriberGroup')->name('devUnSubscriberGroupRecipientList');
    Route::get('developer/unsubscribes-groups/recipient/delete', 'UnSubscriberGroup')->name('devUnSubscriberGroupRecipientDelete');
    Route::get('developer/unsubscribes-groups/recipient/bulk-delete', 'UnSubscriberGroup')->name('devUnSubscriberGroupRecipientBulk');

    Route::get('developer/notification/recipient-list', 'NotificationRecipient')->name('devNotificationRecipient');
    Route::get('developer/notification/recipient-create', 'NotificationRecipient')->name('devNotificationRecipientCreate');
    Route::get('developer/notification/recipient-delete', 'NotificationRecipient')->name('devNotificationRecipientDelete');
    Route::get('developer/notification/bulk-delete', 'NotificationRecipient')->name('devNotificationRecipientBulkDelete');

    Route::get('developer/country-state-city', 'SenderList')->name('devCountryStateCity');
    Route::get('developer/sender/list', 'SenderList')->name('devSenderList');
    Route::get('developer/sender/create', 'SenderList')->name('devSenderCreate');
    Route::get('developer/sender/details', 'SenderList')->name('devSenderDetails');
    Route::get('developer/sender/update', 'SenderList')->name('devSenderUpdate');
    Route::get('developer/sender/resend/verification', 'SenderList')->name('devSenderResend');
    Route::get('developer/sender/delete', 'SenderList')->name('devSenderDelete');

    Route::get('developer/reserve/fields', 'customField')->name('devReserveField');
    Route::get('developer/custom/fields', 'customField')->name('devCustomField');
    Route::get('developer/custom/field-create', 'customField')->name('devCustomFieldCreate');
    Route::get('developer/custom/field-delete', 'customField')->name('devCustomFieldDelete');

    Route::get('developer/contact-type', 'contactType')->name('devContactType');
    Route::get('developer/contact-type/add', 'contactType')->name('devContactTypeAdd');
    Route::get('developer/contact-type/view', 'contactType')->name('devContactTypeView');
    Route::get('developer/contact-type/update', 'contactType')->name('devContactTypeUpdate');
    Route::get('developer/contact-type/delete', 'contactType')->name('devContactTypeDelete');

    Route::get('developer/contact/list', 'contactList')->name('devContactList');
    Route::get('developer/contact/single-add', 'contactList')->name('devContactSingleAdd');
    Route::get('developer/contact/sample-download', 'contactList')->name('devContactSampleDown');
    Route::get('developer/contact/upload-csv', 'contactList')->name('devContactUploadCsv');
    Route::get('developer/contact/details', 'contactList')->name('devContactDetails');
    Route::get('developer/contact/update', 'contactList')->name('devContactUpdate');
    Route::get('developer/contact/delete', 'contactList')->name('devContactDelete');
    Route::get('developer/contact/multiple-delete', 'contactList')->name('devContactMultiDelete');

    Route::get('developer/get-template/list', 'singleSend')->name('devGetTemplateList');
    Route::get('developer/get-dynamic/content', 'singleSend')->name('devGetDynamicContent');
    Route::get('developer/single-send/list', 'singleSend')->name('devSingleSendList');
    Route::get('developer/single-send/create', 'singleSend')->name('devSingleSendCreate');
    Route::get('developer/single-send/duplicate', 'singleSend')->name('devSingleSendDuplicate');
    Route::get('developer/single-send/details', 'singleSend')->name('devSingleSendDetails');
    Route::get('developer/single-send/update', 'singleSend')->name('devSingleSendUpdate');
    Route::get('developer/single-send/delete', 'singleSend')->name('devSingleSendDelete');
    Route::get('developer/single-send/multiple-delete', 'singleSend')->name('devSingleSendMultiDelete');

    Route::get('developer/automation/list', 'automation')->name('devAutomationList');
    Route::get('developer/automation/create', 'automation')->name('devAutomationCreate');
    Route::get('developer/automation/duplicate', 'automation')->name('devAutomationDuplicate');
    Route::get('developer/automation/details', 'automation')->name('devAutomationDetails');
    Route::get('developer/automation/update', 'automation')->name('devAutomationUpdate');
    Route::get('developer/automation/pause', 'automation')->name('devAutomationPause');
    Route::get('developer/automation/live', 'automation')->name('devAutomationLive');
    Route::get('developer/automation/delete', 'automation')->name('devAutomationDelete');
    Route::get('developer/automation/multiple-delete', 'automation')->name('devAutomationMultiDelete');
    Route::get('developer/automation/schedule', 'automation')->name('devAutomationSchedule');
    Route::get('developer/automation/schedule/create', 'automation')->name('devAutomationScheduleCreate');
    Route::get('developer/automation/schedule/delete', 'automation')->name('devAutomationScheduleDelete');

    Route::get('developer/segment/list', 'segment')->name('devSegmentList');
    Route::get('developer/segment/recipient', 'segment')->name('devSegmentRecipient');
    Route::get('developer/segment/recipient-add', 'segment')->name('devSegmentRecipientAdd');
    Route::get('developer/segment/recipient-delete', 'segment')->name('devSegmentRecipientDelete');
    Route::get('developer/segment/delete', 'segment')->name('devSegmentDelete');

    Route::get('developer/webhook/event', 'webhookEvent')->name('devWebhookEvent');
});

