@extends('layouts.unsubscribe_preference')
@section('page_title','Unsubscribe-Preferences')
@section('content')
    <section class="opt-out-preferences-section">
        <div class="container">
            <div class="section-header text-center">
                <h5>{{emailProtected($unsubscriberEmail)}}</h5>
                <h3>@lang('Opt-Out preferences')</h3>
                <h6>@lang('You can choose to opt out of any of the following types of email communication we send')
                    .</h6>
            </div>
            <div class="opt-out-box">
                <form action="{{route('unsubscribePreferenceSave',[$ownerId,$unsubscriberEmail,$singleSendId])}}"
                      method="POST">
                    @csrf
                    <div class="body">
                        <div class="title">
                            <h6>@lang('email type')</h6>
                            <h6>@lang('opt out')</h6>
                        </div>
                        @if($unsubscribeGroups)
                            @foreach($unsubscribeGroups as $key => $group)
                                <hr>
                                <div class="middle">
                                    <div class="text-start">
                                        <p>{{$group->group_name}}</p>
                                        <p>{{$group->description}}</p>
                                    </div>
                                    <div class="btn-toggle">
                                        <div class="toggle">
                                            <input type="checkbox"
                                                   name="optOut[{{$group->id}}]" {{$group->isEmailExit($unsubscriberEmail)?'checked':''}}/>
                                            <label></label>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="footer">
                        <button type="submit" class="cmn-btn">@lang('save preferences')</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection
