@extends($theme.'layouts.user')
@section('page_title',__('Upload Template'))

@section('content')
    <div class="section dashboard">
        <div class="row">
            <div class="account-settings-profile-section">
                <div class="card">
                    <div class="card-header">
                        <div class="d-sm-flex justify-content-between">
                            <h5 class="card-title">@lang('Upload Template')
                            </h5>
                            <div class="d-flex justify-content-end">
                                <a href="{{route('user.templateHtmlSample')}}" class="cmn-btn me-1"><i
                                        class="fas fa-download me-1"></i> @lang('Sample HTML')</a>
                                <a href="{{route('user.templateJSONSample')}}" class="cmn-btn"><i
                                        class="fas fa-download me-1"></i> @lang('Sample JSON')</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <div class="profile-form-section">
                            <div class="row g-3">
                                <form action="{{route('user.uploadTemplate')}}" method="post"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label class="form-label">@lang('Template Name')</label>
                                            <input type="text" name="template_name" class="form-control">
                                            @error('template_name')
                                            <span class="text-danger">{{$message}}</span>
                                            @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <p class="text-muted">@lang('Which code do you want to upload')?</p>
                                            <div class="radio">
                                                <input id="radio-1" name="code_type" type="radio" value="html"
                                                       checked>
                                                <label for="radio-1"
                                                       class="radio-label me-4">@lang('Template HTML')</label>

                                                <input id="radio-2" name="code_type" value="json" type="radio">
                                                <label for="radio-2" class="radio-label">@lang('Template JSON')</label>
                                                @error('code_type')
                                                <span class="text-danger">{{$message}}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-12 mt-2">
                                            <label class="form-label templateCodeName">@lang('Template HTML')</label>
                                            <textarea name="code" class="form-control" rows="10"></textarea>
                                            @error('code')
                                            <span class="text-danger">{{$message}}</span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mt-4">
                                            <label class="form-label">@lang('Template Preview Image')</label>
                                            <div class="image-area">
                                                <img
                                                    src="{{getFile('local','dummy')}}"
                                                    alt="..." class="width-200 img-profile-view">
                                            </div>
                                            <div class="btn-area">
                                                <div class="btn-area-inner d-flex">
                                                    <div class="cmn-file-input">
                                                        <label for="formFile"
                                                               class="form-label cmn-btn">@lang('Upload Preview')</label>
                                                        <input class="form-control file-upload-input"
                                                               name="preview_image"
                                                               type="file" id="formFile">
                                                    </div>
                                                    <button type="button" class="cmn-btn3 reset">@lang('reset')</button>
                                                </div>
                                            </div>
                                            @error('preview_image')
                                            <div class="error text-danger"> @lang($message) </div>
                                            @enderror
                                        </div>
                                    </div>
                                    <button type="submit" class="cmn-btn mt-3">
                                        <i class="fas fa-upload me-1"></i> @lang('Upload')
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('js_libs')
@endpush
@push('extra_scripts')
    <script>
        'use strict';
        $(document).on('change', '.file-upload-input', function () {
            let _this = $(this);
            let reader = new FileReader();
            reader.readAsDataURL(this.files[0]);
            reader.onload = function (e) {
                $('.img-profile-view').attr('src', e.target.result);
            }
            var fileCount = $(this)[0].files.length;
            $('.select-files-count').text(fileCount + ' file(s) selected');
        });
        $(document).on('click', '.reset', function () {
            let img = "{{asset(config('location.default'))}}"
            $('.img-profile-view').attr('src', img);
            $('.select-files-count').text("");
        });

        $(document).on("click", "[name='code_type']", function () {
            var checkedValue = $("input[name='code_type']:checked").val();
            if (checkedValue == 'json') {
                $('.templateCodeName').text(`Template JSON`)
            } else {
                $('.templateCodeName').text(`Template HTML`)
            }
        });
    </script>
@endpush
