@extends($theme.'layouts.user')
@section('page_title',trans('Dashboard'))
@section('content')
    <div class="section dashboard">
        <div class="row" id="firebase-app">
            <div v-if="user_foreground == '1' || user_background == '1'" class="card-box">
                <div v-if="notificationPermission == 'default' && !is_notification_skipped" v-cloak>
                    <div class="media align-items-center d-flex justify-content-between alert alert-warning mb-4">
                        <div><i
                                class="fas fa-exclamation-triangle"></i> @lang('Do not miss any single important notification! Allow your
                        browser to get instant push notification')
                            <button class="cmn-btn ml-3" id="allow-notification">@lang('Allow me')</button>
                        </div>
                        <button class="close-btn pt-1" @click.prevent="skipNotification"><i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-box" v-if="notificationPermission == 'denied' && !is_notification_skipped" v-cloak>
                <div class="media align-items-center d-flex justify-content-between alert alert-warning mb-4">
                    <div><i
                            class="fas fa-exclamation-triangle"></i> @lang('Please allow your browser to get instant push notification.
                        Allow it from
                        notification setting.')
                    </div>
                    <button class="close-btn pt-1" @click.prevent="skipNotification"><i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
        <!-- Tab mobile view carousel start -->
        <div class="tab-mobile-view-carousel-section mb-30 d-lg-none">
            <div class="row">
                <div class="col-12">
                    <h5 class="mb-10"> @lang('Automation Statistics')</h5>

                    <div class="owl-carousel owl-theme carousel-1">
                        <div class="item">
                            <div class="box-card box-card1 soft-red-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i class="fa-light fa-envelopes-bulk"></i>@lang('Email send')
                                    </h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($automationRecord['totalEmailSend'],false)}}</h4>
                                    <div class="statistics">
                                        <p class="growth"><i class="fa-light fa-chart-line-up"></i>{{fractionNumber($automationRecord['last30DaysPercentage'])}}%</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="item">
                            <div class="box-card box-card2 lime-green-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i class="fa-light fas fa-envelope-open-text"></i>@lang('Avg. open rate')
                                    </h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($automationRecord['avgOpenRate'])}}%</h4>
                                    <div class="statistics">
                                        <p class="growth"><i
                                                class="fa-light fa-chart-line-up"></i>{{fractionNumber($automationRecord['last30DaysOpenPercentage'])}}
                                            %</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="box-card box-card3 vivid-orange-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i class="fa-light fa-exclamation-triangle text-danger"></i>@lang('Avg. bounce rate')
                                    </h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($automationRecord['avgBounceRate'])}}%</h4>
                                    <div class="statistics">
                                        <p class="growth down"><i
                                                class="fa-light fa-chart-line-down"></i>{{fractionNumber($automationRecord['last30DaysBouncePercentage'])}}
                                            %</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="box-card box-card4 soft-blue-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i
                                            class="fa-light fa-light fa-bell-slash"></i>@lang('Avg. Unsubscribe rate')</h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($automationRecord['avgUnsbscribesRate'])}}%</h4>
                                    <div class="statistics">
                                        <p class="growth"><i
                                                class="fa-light fa-chart-line-up"></i>{{fractionNumber($automationRecord['last30DaysUnsubscribesPercentage'])}}
                                            %</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-mobile-view-carousel-section mb-30 d-lg-none">
            <div class="row">
                <div class="col-12">
                    <h5 class="mb-10"> @lang('Single Send Statistics')</h5>
                    <div class="owl-carousel owl-theme carousel-1">
                        <div class="item">
                            <div class="box-card box-card1 soft-red-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i class="fa-light fa-envelopes-bulk"></i>@lang('Email send')
                                    </h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($singleSendRecord['totalEmailSend'],false)}}</h4>
                                    <div class="statistics">
                                        <p class="growth"><i
                                                class="fa-light fa-chart-line-up"></i>{{fractionNumber($singleSendRecord['last30DaysPercentage'])}}
                                            %</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="box-card box-card2 lime-green-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i class="fa-light fas fa-envelope-open-text"></i>@lang('Avg. open rate')
                                    </h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($singleSendRecord['avgOpenRate'])}}%</h4>
                                    <div class="statistics">
                                        <p class="growth"><i
                                                class="fa-light fa-chart-line-up"></i>{{fractionNumber($singleSendRecord['last30DaysOpenPercentage'])}}
                                            %</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="box-card box-card3 vivid-orange-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i class="fa-light fa-exclamation-triangle "></i>@lang('Avg. bounce rate')
                                    </h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($singleSendRecord['avgBounceRate'])}}%</h4>
                                    <div class="statistics">
                                        <p class="growth down"><i
                                                class="fa-light fa-chart-line-down"></i>{{fractionNumber($singleSendRecord['last30DaysBouncePercentage'])}}
                                            %</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="box-card box-card4 soft-blue-card">
                                <div class="box-card-header">
                                    <h5 class="box-card-title"><i
                                            class="fa-light fa-light fa-bell-slash"></i>@lang('Avg. Unsubscribe rate')</h5>
                                </div>
                                <div class="box-card-body">
                                    <h4 class="mb-0">{{fractionNumber($singleSendRecord['avgUnsubscribesRate'])}}%</h4>
                                    <div class="statistics">
                                        <p class="growth"><i
                                                class="fa-light fa-chart-line-up"></i>{{fractionNumber($singleSendRecord['last30DaysUnsubscribesPercentage'])}}
                                            %</p>
                                        <div class="time">@lang('last 30 days')</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Tab mobile view carousel end -->
        <!-- Dashboard card start -->
        <div class="col-12 d-none d-lg-block">
            <h5 class="mb-10"> @lang('Automation Statistics')</h5>
            <div class="row g-4">
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card soft-red-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i class="fa-light fa-envelopes-bulk"></i>@lang('Email send')
                            </h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($automationRecord['totalEmailSend'],false)}}</h4>
                            <div class="statistics">
                                <p class="growth"><i
                                        class="fa-light fa-chart-line-up"></i>{{fractionNumber($automationRecord['last30DaysPercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card lime-green-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i
                                    class="fa-light fas fa-envelope-open-text"></i>@lang('Avg. open rate')
                            </h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($automationRecord['avgOpenRate'])}}%</h4>
                            <div class="statistics">
                                <p class="growth"><i
                                        class="fa-light fa-chart-line-up"></i>{{fractionNumber($automationRecord['last30DaysOpenPercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card vivid-orange-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i
                                    class="fa-light fa-exclamation-triangle"></i>@lang('Avg. bounce rate')
                            </h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($automationRecord['avgBounceRate'])}}%</h4>
                            <div class="statistics">
                                <p class="growth down"><i
                                        class="fa-light fa-chart-line-down"></i>{{fractionNumber($automationRecord['last30DaysBouncePercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card soft-blue-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i
                                    class="fa-light fa-light fa-bell-slash"></i>@lang('Avg. Unsubscribe rate')</h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($automationRecord['avgUnsbscribesRate'])}}%</h4>
                            <div class="statistics">
                                <p class="growth"><i
                                        class="fa-light fa-chart-line-up"></i>{{fractionNumber($automationRecord['last30DaysUnsubscribesPercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 d-none d-lg-block mt-4">
            <h5 class="mb-10"> @lang('Single Send Statistics')</h5>
            <div class="row g-4">
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card soft-red-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i class="fa-light fa-envelopes-bulk"></i>@lang('Email send')
                            </h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($singleSendRecord['totalEmailSend'],false)}}</h4>
                            <div class="statistics">
                                <p class="growth"><i
                                        class="fa-light fa-chart-line-up"></i>{{fractionNumber($singleSendRecord['last30DaysPercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card lime-green-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i
                                    class="fa-light fas fa-envelope-open-text"></i>@lang('Avg. open rate')
                            </h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($singleSendRecord['avgOpenRate'])}}%</h4>
                            <div class="statistics">
                                <p class="growth"><i
                                        class="fa-light fa-chart-line-up"></i>{{fractionNumber($singleSendRecord['last30DaysOpenPercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card vivid-orange-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i
                                    class="fa-light fa-exclamation-triangle text-danger"></i>@lang('Avg. bounce rate')
                            </h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($singleSendRecord['avgBounceRate'])}}%</h4>
                            <div class="statistics">
                                <p class="growth down"><i
                                        class="fa-light fa-chart-line-down"></i>{{fractionNumber($singleSendRecord['last30DaysBouncePercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-sm-6 box-item">
                    <div class="box-card soft-blue-card">
                        <div class="box-card-header">
                            <h5 class="box-card-title"><i
                                    class="fa-light fa-light fa-bell-slash"></i>@lang('Avg. Unsubscribe rate')</h5>
                        </div>
                        <div class="box-card-body">
                            <h4 class="mb-0">{{fractionNumber($singleSendRecord['avgUnsubscribesRate'])}}%</h4>
                            <div class="statistics">
                                <p class="growth"><i
                                        class="fa-light fa-chart-line-up"></i>{{fractionNumber($singleSendRecord['last30DaysUnsubscribesPercentage'])}}
                                    %</p>
                                <div class="time">@lang('last 30 days')</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row g-4 mt-20">
            <div class="col-xxl-3 col-sm-6">
                <div class="box-card soft-green-card shadow-none">
                    <div class="box-card-header">
                        <div class="d-flex justify-content-between">
                            <h5>@lang('Automation')</h5>
                            <h5>{{fractionNumber($automation['totalAutomation'],false)}}</h5>
                        </div>
                    </div>
                    <div class="box-card-body">

                        <ul class="w-100">
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('Live Automation')</p>
                                <span>{{fractionNumber($automation['liveAutomation'],false)}}</span>
                            </li>
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('Draft Automation')</p>
                                <span>{{fractionNumber($automation['draftAutomation'],false)}}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-sm-6">
                <div class="box-card bright-orange-card">
                    <div class="box-card-header">
                        <div class="d-flex justify-content-between">
                            <h5>@lang('Single Send')</h5>
                            <h5>{{fractionNumber($singleSend['totalSingleSend'],false)}}</h5>
                        </div>
                    </div>
                    <div class="box-card-body">
                        <ul class="w-100">
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('Complete Single Send')</p>
                                <span>{{fractionNumber($singleSend['completeSingleSend'],false)}}</span>
                            </li>
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('Draft Single Send')</p>
                                <span>{{fractionNumber($singleSend['draftSingleSend'],false)}}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-sm-6">
                <div class="box-card bright-red-card">
                    <div class="box-card-header">
                        <div class="d-flex justify-content-between">
                            <h5>@lang('Senders')</h5>
                            <h5>{{fractionNumber($senders['totalSender'],false)}}</h5>
                        </div>

                    </div>
                    <div class="box-card-body">
                        <ul class="w-100">
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('Verified Sender')</p>
                                <span>{{fractionNumber($senders['verifiedSender'],false)}}</span>
                            </li>
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('Un-Verified Sender')</p>
                                <span>{{fractionNumber($senders['unVerifiedSender'],false)}}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-sm-6">
                <div class="box-card moderate-cyan-card">
                    <div class="box-card-header">
                        <div class="d-flex justify-content-between">
                            <h5>@lang('Unsubscribe Group')</h5>
                            <h5>{{fractionNumber($unsubscribeGroup['totalGroup'],false)}}</h5>
                        </div>

                    </div>
                    <div class="box-card-body">
                        <ul class="w-100">
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('On Preference')</p>
                                <span>{{fractionNumber($unsubscribeGroup['inPreference'],false)}}</span>
                            </li>
                            <li class="d-flex justify-content-between">
                                <p class="mb-1">@lang('Out of Preference')</p>
                                <span>{{fractionNumber($unsubscribeGroup['outPreference'],false)}}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-md-6">
                <div class="card mt-50">
                    <div class="card-header d-flex justify-content-between border-0">
                        <h4>@lang('Automation Performance')</h4>
                    </div>
                    <div class="card-body">
                        <div id="chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card mt-50">
                    <div class="card-header d-flex justify-content-between border-0">
                        <h4>@lang('Single Send Performance')</h4>
                    </div>
                    <div class="card-body">
                        <div id="chart1"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card mt-50">
                    <div class="card-body">
                        <div id="chart2"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card mt-50">
                    <div class="card-body">
                        <div id="chart3"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Dashboard card start -->
    </div>

@endsection
@push('js_libs')
    <script src="{{ asset('assets/global/js/apexcharts.min.js') }}"></script>
@endpush

@push('extra_scripts')
    <script>
        'use strict';

        var options = {
            series: [{
                data: {!! json_encode($horizontalBarChatAutomation) !!},
            }],
            chart: {
                type: 'bar',
                height: 350
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: true,
                }
            },
            dataLabels: {
                enabled: false
            },
            xaxis: {
                categories: ['Triggered', 'Delivered', 'Bounces', 'Unique Opens', 'Total Open', 'Unsubscribe'
                ],
            },
        };

        var chart = new ApexCharts(document.querySelector("#chart"), options);
        chart.render();

        var options1 = {
            series: [{
                data: {!! json_encode($horizontalBarChatSingleSend) !!},
            }],
            chart: {
                type: 'bar',
                height: 350
            },
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    horizontal: true,
                }
            },
            dataLabels: {
                enabled: false
            },
            xaxis: {
                categories: ['Triggered', 'Delivered', 'Bounces', 'Unique Opens', 'Total Open', 'Unsubscribe'
                ],
            },
        };

        var chart1 = new ApexCharts(document.querySelector("#chart1"), options1);
        chart1.render();

        //Chart 2
        var options2 = {
            series: [{
                name: 'XYZ MOTORS',
                data: {!! json_encode($lineChartUniqueOpenSingle) !!}
            }],
            chart: {
                type: 'area',
                stacked: false,
                height: 350,
                zoom: {
                    type: 'x',
                    enabled: true,
                    autoScaleYaxis: true
                },
                toolbar: {
                    autoSelected: 'zoom'
                }
            },
            dataLabels: {
                enabled: false
            },
            markers: {
                size: 0,
            },
            title: {
                text: 'Automation Unique Open Movement',
                align: 'left'
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    inverseColors: false,
                    opacityFrom: 0.5,
                    opacityTo: 0,
                    stops: [0, 90, 100]
                },
            },
            yaxis: {
                labels: {
                    formatter: function (val) {
                        //return (val / 1000000).toFixed(0);
                        return (val / 1).toFixed(0);
                    },
                },
                title: {
                    text: 'Open'
                },
            },
            xaxis: {
                type: 'datetime',
            },
            tooltip: {
                shared: false,
                y: {
                    formatter: function (val) {
                        return (val / 1000000).toFixed(0)
                    }
                }
            }
        };

        var chart2 = new ApexCharts(document.querySelector("#chart2"), options2);
        chart2.render();

        //Chart 3
        var options3 = {
            series: [{
                name: 'XYZ MOTORS',
                data: {!! json_encode($lineChartUniqueOpenAutomation) !!}
            }],
            chart: {
                type: 'area',
                stacked: false,
                height: 350,
                zoom: {
                    type: 'x',
                    enabled: true,
                    autoScaleYaxis: true
                },
                toolbar: {
                    autoSelected: 'zoom'
                }
            },
            dataLabels: {
                enabled: false
            },
            markers: {
                size: 0,
            },
            title: {
                text: 'Single Send Unique Open Movement',
                align: 'left'
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    inverseColors: false,
                    opacityFrom: 0.5,
                    opacityTo: 0,
                    stops: [0, 90, 100]
                },
            },
            yaxis: {
                labels: {
                    formatter: function (val) {
                        //return (val / 1000000).toFixed(0);
                        return (val / 1).toFixed(0);
                    },
                },
                title: {
                    text: 'Open'
                },
            },
            xaxis: {
                type: 'datetime',
            },
            tooltip: {
                shared: false,
                y: {
                    formatter: function (val) {
                        return (val / 1000000).toFixed(0)
                    }
                }
            }
        };

        var chart3 = new ApexCharts(document.querySelector("#chart3"), options3);
        chart3.render();

    </script>
@endpush


@if($firebaseNotify)
    @push('extra_scripts')
        <script type="module">
            import {initializeApp} from "https://www.gstatic.com/firebasejs/9.17.1/firebase-app.js";
            import {
                getMessaging,
                getToken,
                onMessage
            } from "https://www.gstatic.com/firebasejs/9.17.1/firebase-messaging.js";

            const firebaseConfig = {
                apiKey: "{{$firebaseNotify['apiKey']}}",
                authDomain: "{{$firebaseNotify['authDomain']}}",
                projectId: "{{$firebaseNotify['projectId']}}",
                storageBucket: "{{$firebaseNotify['storageBucket']}}",
                messagingSenderId: "{{$firebaseNotify['messagingSenderId']}}",
                appId: "{{$firebaseNotify['appId']}}",
                measurementId: "{{$firebaseNotify['measurementId']}}"
            };

            const app = initializeApp(firebaseConfig);
            const messaging = getMessaging(app);
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('{{ getProjectDirectory() }}' + `/firebase-messaging-sw.js`, {scope: './'}).then(function (registration) {
                        requestPermissionAndGenerateToken(registration);
                    }
                ).catch(function (error) {
                });
            } else {
            }

            onMessage(messaging, (payload) => {
                if (payload.data.foreground || parseInt(payload.data.foreground) == 1) {
                    const title = payload.notification.title;
                    const options = {
                        body: payload.notification.body,
                        icon: payload.notification.icon,
                    };
                    new Notification(title, options);
                }
            });

            function requestPermissionAndGenerateToken(registration) {
                document.addEventListener("click", function (event) {
                    if (event.target.id == 'allow-notification') {
                        Notification.requestPermission().then((permission) => {
                            if (permission === 'granted') {
                                getToken(messaging, {
                                    serviceWorkerRegistration: registration,
                                    vapidKey: "{{$firebaseNotify['vapidKey']}}"
                                })
                                    .then((token) => {
                                        $.ajax({
                                            url: "{{ route('user.save.token') }}",
                                            method: "post",
                                            data: {
                                                token: token,
                                            },
                                            success: function (res) {
                                            }
                                        });
                                        window.newApp.notificationPermission = 'granted';
                                    });
                            } else {
                                window.newApp.notificationPermission = 'denied';
                            }
                        });
                    }
                });
            }
        </script>
        <script>
            window.newApp = new Vue({
                el: "#firebase-app",
                data: {
                    user_foreground: '',
                    user_background: '',
                    notificationPermission: Notification.permission,
                    is_notification_skipped: sessionStorage.getItem('is_notification_skipped') == '1'
                },
                mounted() {
                    sessionStorage.clear();
                    this.user_foreground = "{{$firebaseNotify['user_foreground']}}";
                    this.user_background = "{{$firebaseNotify['user_background']}}";
                },
                methods: {
                    skipNotification() {
                        sessionStorage.setItem('is_notification_skipped', '1');
                        this.is_notification_skipped = true;
                    }
                }
            });
        </script>
    @endpush
@endif

