@extends($theme.'layouts.user')
@section('page_title',__('Custom Templates'))
@push('style_lib')

@endpush
@section('content')
    <div class="card mt-50">
        <div class="card-header d-flex justify-content-between border-0">
            <h4>@lang('Custom Templates')</h4>
            <a href="{{route('user.uploadTemplate')}}" class="cmn-btn createSender"> @lang('Upload Template')
            </a>
        </div>
        <div class="card-body">
            <div class="cmn-table">
                <div class="table-responsive overflow-visible">
                    <table class="table align-middle table-striped">
                        <thead>
                        <tr>
                            <th scope="col">@lang('Template Name')</th>
                            <th scope="col">@lang('Preview Image')</th>
                            <th scope="col">@lang('Created At')</th>
                            <th scope="col">@lang('Action')</th>
                        </tr>
                        </thead>
                        <tbody>
                        @if(count($templates)>0)
                            @foreach($templates as $key => $item)
                                <tr>
                                    <td data-label="@lang('Template Name')">
                                        <span>{{$item->template_name}}</span>
                                    </td>
                                    <td data-label="@lang('Preview Image')">
                                        <div class="image-area">
                                            <img src="{{getFile($item->driver,$item->preview_image)}}" alt="..."
                                                 class="img-profile-view w-50">
                                        </div>
                                    </td>
                                    <td data-label="@lang('Created At')">
                                        {{dateTime($item->created_at,basicControl()->date_time_format)}}
                                    </td>
                                    <td data-label="@lang('Action')">
                                        <div class="dropdown">
                                            <button class="action-btn2" type="button" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                <i class="fa-regular fa-ellipsis-stroke-vertical"></i>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item deleteBtn"
                                                       data-route="{{route('user.customTemplateDelete',$item->id)}}"
                                                       data-bs-toggle="modal"
                                                       data-bs-target="#deleteModal"
                                                       href="javascript:void(0)"><i
                                                            class="fa-regular fa-trash"></i> @lang('Delete')</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            @include('empty')
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="deleteModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
         aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title" id="staticBackdropLabel">@lang('Delete Confirmation')</h1>
                    <button type="button" class="cmn-btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fa-light fa-xmark"></i>
                    </button>
                </div>
                <form action="" method="post" class="formAction">
                    @method('delete')
                    @csrf
                    <div class="modal-body">
                        @lang('Are You sure to delete this Template')?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="cmn-btn3" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="cmn-btn">@lang('Yes')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('js_libs')

@endpush
@push('extra_scripts')
    <script>
        'use strict';
        var id = "";
        $(document).on("click", '.deleteBtn', function () {
            $('.formAction').attr('action', $(this).data('route'));
        });

    </script>

@endpush
