@extends($theme.'layouts.user')
@section('page_title',__('API Recipients'))
@push('style_lib')
@endpush
@section('content')
    <!-- Unsubscribe section start -->
    <div class="card">
        <div class="card-header">
            <div class="row height d-flex justify-content-end align-items-center">
                <div class="col-md-4">
                    <form action="{{route('user.apiRecipient')}}" method="get">
                        <div class="search-custom">
                            <i class="fa fa-search"></i>
                            <input type="text" class="form-control" name="ip" value="{{@request()->ip}}" placeholder="@lang('IP Address')">
                            <button type="submit" class="btn btn-primary">@lang('Search')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            @if(count($apiClients) > 0)
                <div class="box-list">
                    @foreach($apiClients as $client)
                        <div class="test-box">
                            <div class="box-header">
                                <div class="box-unsub-prefs">
                                    <span class="icon {{$client->is_blocked ? 'text-danger':''}}">
                                        @if($client->is_blocked)
                                            <i class="fas fa-lock"></i>
                                        @endif
                                        @lang('IP:')
                                    </span>
                                    <span>{{$client->ip}}</span>
                                </div>
                            </div>
                            <div class="body">
                                <h5>{{$client->country_name}}</h5>
                                <ul>
                                    <li><small>@lang('Country Code:') {{$client->country_code}}</small></li>
                                    <li><small>@lang('Region Code:') {{$client->region_code}}</small></li>
                                    <li><small>@lang('Region Name:') {{$client->region_name}}</small></li>
                                    <li><small>@lang('City Name:') {{$client->city_name}}</small></li>
                                    <li><small><strong>@lang('Zip Code')&nbsp;{{$client->zip_code}}</strong></small>
                                    </li>
                                </ul>
                            </div>
                            <div class="footer">
                                <div class="box-id"><strong>@lang('Latitude:')</strong>&nbsp; {{$client->latitude}}
                                </div>
                                <div class="box-id"><strong>@lang('Longitude:')</strong> {{$client->longitude}}</div>
                                <div class="dropdown">
                                    <button class="action-btn-secondary" type="button" data-bs-toggle="dropdown"
                                            aria-expanded="false">
                                        <i class="fa-regular fa-ellipsis-stroke-vertical"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        @if(!$client->is_blocked)
                                            <li><a class="dropdown-item clickAction"
                                                   data-bs-target="#confirmModal"
                                                   data-bs-toggle="modal"
                                                   data-msg="Are you want to block this IP?"
                                                   href="javascript:void(0)"
                                                   data-route="{{route('user.apiRecipientAction').'?id='.$client->id.'&action=blocked'}}"><i
                                                        class="fas fa-lock"></i> @lang('Blocked')
                                                </a></li>
                                        @else
                                            <li><a class="dropdown-item clickAction"
                                                   data-bs-target="#confirmModal"
                                                   data-bs-toggle="modal"
                                                   data-msg="Are you want to unblock this IP?"
                                                   data-route="{{route('user.apiRecipientAction').'?id='.$client->id.'&action=unblocked'}}"
                                                   href="javascript:void(0)"><i
                                                        class="fas fa-lock-open"></i> @lang('UnBlocked')</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="d-flex justify-content-center text-center table-not-found">
                    <img
                        src="{{asset('assets/no-data.png')}}"
                        alt="no-data" class="no-data-img"><br>
                </div>
            @endif
        </div>
    </div>
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="describeModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="describeModalLabel"> @lang('Confirmation !')</h4>
                    <button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </button>
                </div>
                <form action="" method="post" class="modalForm">
                    @csrf
                    <div class="modal-body">
                        <p id="modalMsg"></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="cmn-btn3"
                                data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="submit" class="cmn-btn">@lang("Confirm")</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('js_libs')
@endpush
@push('extra_scripts')
    <script>
        'use strict';
        $(document).on("click", ".clickAction", function () {
            let route = $(this).data('route');
            $("#modalMsg").text($(this).data('msg'))
            $('.modalForm').attr('action', route);
        });
    </script>
@endpush
