@extends($theme.'layouts.user')
@section('page_title',__('Activity'))

@section('content')
    <div class="widget">
        <div class="widget-content">
            <div class="column-wrap">
                <div class="coloumn">
                    <div class="activity">
                        <h3>@lang('Activity')</h3>
                        <div class="activity-items">
                            @if($activities)
                                @foreach($activities as $key => $item)
                                    <div class="activity-item-wrap activity-date">
                                        <h4 class="activity-date">{{$key}}</h4>
                                    </div>
                                    @if($item)
                                        @foreach($item as $activity)
                                            <!-- start activity -->
                                            <div class="activity-item-wrap activity-call">
                                                <div class="activity-item-badge"><i
                                                        class="aroicon-action-send-message"></i>
                                                </div>
                                                <div class="activity-item">
                                                    <div class="activity-item-meta">
                                                        @if($activity->ip)
                                                            <div class="activity-user"><i
                                                                    class="aroicon-entity-contacts">{{optional($activity->apiClient)->country_code??'A'}}</i>
                                                            </div>
                                                        @else
                                                            @if(auth()->check() && auth()->user()->image && auth()->user()->image_driver)
                                                                <div class="activity-user activity-ismember"><img
                                                                        class="img-circle"
                                                                        src="{{getFile(auth()->user()->image_driver,auth()->user()->image)}}">
                                                                </div>
                                                            @else
                                                                <div class="activity-user"><i
                                                                        class="aroicon-entity-contacts">{{auth()->user()->firstname[0]}}</i>
                                                                </div>
                                                            @endif
                                                        @endif
                                                        <p class="activity-summary">{!! $activity->text !!}</p>
                                                        <p class="activity-timestamp">
                                                            {{\Carbon\Carbon::parse($activity->created_at)->format('M j \a\t g:ia')}}
                                                            <strong>{{$activity->ip?"IP: $activity->ip":" "}}</strong>
                                                        </p>
                                                    </div>
                                                    <div class="activity-item-details">

                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end activity -->
                                        @endforeach
                                    @endif
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
