<!-- Testimonial section start -->
@if(isset($testimonial))
    <section class="testimonial-section">
        <div class="container">
            @if(isset($testimonial['single']))
                <div class="row">
                    <div class="section-header mb-50 text-center">
                        <div class="section-subtitle">{{ @$testimonial['single']['title'] }}</div>
                        <h2 class="">{{ @$testimonial['single']['heading'] }}</h2>
                        <p class="cmn-para-text m-auto">{!! @$testimonial['single']['description'] !!} </p>
                    </div>
                </div>
            @endif
            <div class="row">
                @if(isset($testimonial['multiple']) && count($testimonial['multiple']) > 0)
                    <div class="owl-carousel owl-theme testimonial-carousel">
                        @foreach($testimonial['multiple'] as $key => $testimonial)
                            <div class="item">
                                <div class="testimonial-box">
                                    <div class="testimonial-thumbs thumbs">
                                        <img
                                            src="{{getFile(@$testimonial['media']->image->driver,@$testimonial['media']->image->path)}}"
                                            alt="...">
                                    </div>
                                    <div class="text_area text-center ">
                                        <h4 class="mt-20">{{@$testimonial['name']}}</h4>
                                        <h6>{{@$testimonial['address']}}</h6>
                                        <div class="quote-area"><img
                                                src="{{asset($themeTrue.'img/testimonial/quote.png')}}"
                                                alt="..."></div>
                                        <p>{!! @$testimonial['short_description'] !!} </p>
                                        <div class="quote-area ms-auto"><img
                                                src="{{asset($themeTrue.'img/testimonial/double-quotes.png')}}"
                                                alt="..."></div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </section>
@endif
<!-- Testimonial section end -->
