<!-- Pricing plan section start -->
@if(isset($pricing))
    <section class="pricing-section">
        <div class="container">
            @if(isset($pricing['single']))
                <div class="row">
                    <div class="col-12">
                        <div class="section-header text-center">
                            <div class="section-subtitle">{{ @$pricing['single']['title'] }}</div>
                            <h2 class="section-title mx-auto">{{ @$pricing['single']['heading'] }}</h2>
                            <p class="cmn-para-text mx-auto">{{ @$pricing['single']['short_description'] }}
                            </p>
                        </div>
                    </div>
                </div>
            @endif

            @php
                $plans = \App\Models\Plan::where('status',1)->where('is_free',0)->get();
                $freePlan = \App\Models\Plan::where('status',1)->where('is_free',1)->first();
                $prepaidCredits = \App\Models\PrepaidCredit::where('status',1)->orderBy('credits','ASC')->get();
            @endphp

            <div class="row">
                <div class="col-12">
                    <!-- Cmn tabs start -->
                    <div class="cmn-tabs">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                @if(count($prepaidCredits) > 0)
                                    <button class="nav-link" id="credit-plan-tab" data-bs-toggle="pill"
                                            data-bs-target="#credit-plan" type="button" role="tab"
                                            aria-controls="credit-plan"
                                            aria-selected="false">
                                        <h5>@lang('Add-ons')</h5>
                                        <p class="mb-0">@lang('All')
                                            {{basicControl()->site_title}} @lang('plans can access Email Verification')</p>
                                    </button>
                                @endif
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="monthly-plan-tab" data-bs-toggle="pill"
                                        data-bs-target="#monthly-plan" type="button" role="tab"
                                        aria-controls="monthly-plan"
                                        aria-selected="false">
                                    <h5>@lang('Monthly')</h5>
                                    <p class="mb-0">@lang('Subscribe to our monthly plan for uninterrupted access to premium features')</p>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="yearly-plan-tab" data-bs-toggle="pill"
                                        data-bs-target="#yearly-plan" type="button" role="tab"
                                        aria-controls="yearly-plan"
                                        aria-selected="false">
                                    <h5>@lang('Yearly')</h5>
                                    <p class="mb-0">@lang('Subscribe to our yearly plan for uninterrupted access to premium features')</p>
                                </button>
                            </li>

                        </ul>
                    </div>
                    <!-- Cmn tabs end -->

                    <!-- Cmn tab content start -->
                    <div class="cmn-tab-content">
                        <div class="tab-content" id="pills-tabContent">
                            @if(count($prepaidCredits) > 0)
                                <div class="tab-pane fade" id="credit-plan" role="tabpanel"
                                     aria-labelledby="credit-plan-tab" tabindex="0">
                                    <div class="cmn-tab-content">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="section-header text-center">
                                                    <h3 class="section-title mx-auto">@lang('Prepaid Credits')</h3>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row g-4 justify-content-center">
                                            <div class="col-md-6">
                                                <div class="prepaid-credit-box">
                                                    <div class="prepaid-header">
                                                        <div class="title">
                                                            <i class="fa-regular fa-circle-check"></i>
                                                            <h4>@lang('Email verification') </h4>
                                                        </div>
                                                        <p>@lang('Verify email addresses in bulk or real-time.')</p>
                                                    </div>
                                                    <div class="prepaid-body mt-20">
                                                        <label
                                                            class="form-label">@lang('How many credits do you need?')</label>
                                                        <select class="js-example-basic-single form-control"
                                                                name="prepaidCredit"
                                                                id="prepaidCreditSelect">
                                                            @foreach($prepaidCredits as $prepaidCredit)
                                                                <option
                                                                    value="{{$prepaidCredit->id}}"
                                                                    data-price="{{$prepaidCredit->price}}"
                                                                    data-unit="{{getAmount($prepaidCredit->per_credit_price,5)}}"
                                                                    data-route="{{route('user.creditsPurchase').'?id='.$prepaidCredit->id}}">{{getAmount($prepaidCredit->credits,5)}} @lang('credits')</option>
                                                            @endforeach
                                                        </select>
                                                        <h3 class="mt-20 mb-0" id="showAddonPrice">$0</h3>
                                                        <div class="d-flex justify-content-between">
                                                            <h6 id="showAddonPerRate">$0 per credit</h6>
                                                            <a href=""
                                                               class="cmn-btn text-end mb-2"
                                                               id="getCredit">@lang('Get Credits')</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <!-- Email API Plans tab content start -->
                            <div class="tab-pane fade show active" id="monthly-plan" role="tabpanel"
                                 aria-labelledby="monthly-plan-tab" tabindex="0">
                                <div class="cmn-tab-content">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="section-header text-center">
                                                <h3 class="section-title mx-auto">@lang('Monthly Plans')</h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-4">
                                        @if($freePlan)
                                            <div class="col-xxl-3 col-lg-4 col-md-6">
                                                <div
                                                    class="pricing-box {{(auth()->check() && optional(auth()->user()->plan)->plan_id == $freePlan->id) ? 'featured':''}}">
                                                    @if(auth()->check() && optional(auth()->user()->plan)->plan_id == $freePlan->id)
                                                        <div class="featured-title">@lang('Running')</div>
                                                    @endif
                                                    <div class="section-header">
                                                        <h3 class="section-title">{{$freePlan->plan_name}}</h3>
                                                        <p class="plan-description">{{$freePlan->description}}</p>
                                                    </div>
                                                    <div class="section-body">

                                                        <div class="title">
                                                            <span>{{basicControl()->currency_symbol}}0</span>@lang('/month')
                                                        </div>

                                                        <div class="plan-thumbs">
                                                            <img
                                                                src="{{$themeTrue.'img/pricing-plan/paper-plane2.png'}}"
                                                                alt="">
                                                        </div>
                                                        <div class="btn-area">
                                                            <a href="{{route('user.subscriptionPurchaseFree').'?id='.$freePlan->id}}"
                                                               class="cmn-btn">@lang('Start free trial')
                                                            </a>
                                                        </div>
                                                        <ul class="pricing-feature">
                                                            <li>
                                                                <i class="fa-solid fa-check"></i>@lang('Upto '){{$freePlan->number_of_emails}} @lang('emails')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid fa-check"></i>@lang('Upto '){{$freePlan->number_of_contacts}} @lang('contacts')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid fa-check"></i>{{strtoupper($freePlan->sending_server)}} @lang('Server')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->design_and_code_editors?'fa-check':'fa-xmark close'}}"></i>@lang('Drag & Drop Editor')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->automation?'fa-check':'fa-xmark close'}}"></i>@lang('Make Automation')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->single_send?'fa-check':'fa-xmark close'}}"></i>@lang('Make Single Send')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->segmentation?'fa-check':'fa-xmark close'}}"></i>@lang('Make Segmentation')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->custom_field?'fa-check':'fa-xmark close'}}"></i>@lang('Add Custom Field')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->notify_recipient?'fa-check':'fa-xmark close'}}"></i>@lang('Add Notify Recipients')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->activities?'fa-check':'fa-xmark close'}}"></i>@lang('User Activities')
                                                            </li>
                                                            <li>
                                                                <i class="fa-solid {{$freePlan->api_uses?'fa-check':'fa-xmark close'}}"></i>@lang('Make API Implementation')
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($plans)
                                            @foreach($plans->where('payment_frequency','monthly') as $plan)
                                                <div class="col-xxl-3 col-lg-4 col-md-6">
                                                    <div
                                                        class="pricing-box {{(auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id) ? 'featured':''}}">
                                                        @if(auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id)
                                                            <div class="featured-title">@lang('Running')</div>
                                                        @endif
                                                        <div class="section-header">
                                                            <h3 class="section-title">{{$plan->plan_name}}</h3>
                                                            <p class="plan-description">{{$plan->description}}</p>
                                                        </div>
                                                        <div class="section-body">

                                                            <div class="title">
                                                                <span>{{basicControl()->currency_symbol}}{{$plan->price}}</span>@lang('/month')
                                                            </div>

                                                            <div class="plan-thumbs">
                                                                <img
                                                                    src="{{$themeTrue.'img/pricing-plan/paper-plane2.png'}}"
                                                                    alt="">
                                                            </div>
                                                            <div class="btn-area">
                                                                <a href="{{route('user.subscriptionPurchase').'?id='.$plan->id}}"
                                                                   class="cmn-btn">@lang('Subscription')
                                                                </a>
                                                            </div>
                                                            <ul class="pricing-feature">
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i>@lang('Upto '){{$plan->number_of_emails}} @lang('emails')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i>@lang('Upto '){{$plan->number_of_contacts}} @lang('contacts')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i>{{strtoupper($plan->sending_server)}} @lang('Server')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->design_and_code_editors?'fa-check':'fa-xmark close'}}"></i>@lang('Drag & Drop Editor')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->automation?'fa-check':'fa-xmark close'}}"></i>@lang('Make Automation')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->single_send?'fa-check':'fa-xmark close'}}"></i>@lang('Make Single Send')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->segmentation?'fa-check':'fa-xmark close'}}"></i>@lang('Make Segmentation')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->custom_field?'fa-check':'fa-xmark close'}}"></i>@lang('Add Custom Field')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->notify_recipient?'fa-check':'fa-xmark close'}}"></i>@lang('Add Notify Recipients')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->activities?'fa-check':'fa-xmark close'}}"></i>@lang('User Activities')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->api_uses?'fa-check':'fa-xmark close'}}"></i>@lang('Make API Implementation')
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach

                                        @endif
                                    </div>
                                </div>
                            </div>
                            <!-- Email API Plans tab content end -->

                            <!-- Marketing Campaigns Plans tab content start -->
                            <div class="tab-pane fade" id="yearly-plan" role="tabpanel"
                                 aria-labelledby="yearly-plan-tab" tabindex="0">
                                <div class="cmn-tab-content">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="section-header text-center">
                                                <h3 class="section-title mx-auto">@lang('Yearly Plans')</h3>
                                                <span></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-5">
                                        @if($plans)
                                            @foreach($plans->where('payment_frequency','yearly') as $plan)
                                                <div class="col-lg-4 col-md-6">
                                                    <div
                                                        class="pricing-box {{(auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id) ? 'featured':''}}">
                                                        @if(auth()->check() && optional(auth()->user()->plan)->plan_id == $plan->id)
                                                            <div class="featured-title">@lang('Running')</div>
                                                        @endif
                                                        <div class="section-header">
                                                            <h3 class="section-title">{{$plan->plan_name}}</h3>
                                                            <p class="plan-description">{{$plan->description}}</p>
                                                        </div>
                                                        <div class="section-body">

                                                            <div class="title">
                                                                <span>{{basicControl()->currency_symbol}}{{$plan->price}}</span>@lang('/year')
                                                            </div>

                                                            <div class="plan-thumbs">
                                                                <img
                                                                    src="{{$themeTrue.'img/pricing-plan/paper-plane2.png'}}"
                                                                    alt="">
                                                            </div>
                                                            <div class="btn-area">
                                                                <a href="{{route('user.subscriptionPurchase').'?id='.$plan->id}}"
                                                                   class="cmn-btn">@lang('Subscription')
                                                                </a>
                                                            </div>

                                                            <ul class="pricing-feature">
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i>@lang('Upto '){{$plan->number_of_emails}} @lang('emails')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i>@lang('Upto '){{$plan->number_of_contacts}} @lang('contacts')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid fa-check"></i>{{strtoupper($plan->sending_server)}} @lang('Server')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->design_and_code_editors?'fa-check':'fa-xmark close'}}"></i>@lang('Drag & Drop Editor')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->automation?'fa-check':'fa-xmark close'}}"></i>@lang('Make Automation')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->single_send?'fa-check':'fa-xmark close'}}"></i>@lang('Make Single Send')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->segmentation?'fa-check':'fa-xmark close'}}"></i>@lang('Make Segmentation')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->custom_field?'fa-check':'fa-xmark close'}}"></i>@lang('Add Custom Field')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->notify_recipient?'fa-check':'fa-xmark close'}}"></i>@lang('Add Notify Recipients')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->activities?'fa-check':'fa-xmark close'}}"></i>@lang('User Activities')
                                                                </li>
                                                                <li>
                                                                    <i class="fa-solid {{$plan->api_uses?'fa-check':'fa-xmark close'}}"></i>@lang('Make API Implementation')
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <!-- Marketing Campaigns Plans tab content end -->
                        </div>
                    </div>
                    <!-- Cmn tab content end -->
                </div>
            </div>
        </div>
    </section>
@endif

