<!-- Contact section start -->
@if(isset($contact['single']))
    <section class="contact-section">
        <div class="container">
            <div class="contact-inner">
                <div class="row">
                    <div class="col-xl-4 col-lg-6">
                        <div class="contact-area">
                            <div class="section-header mb-0">
                                <h3>@lang('Contact Information')</h3>
                            </div>
                            <p class="para_text">{!! @$contact['single']['contact_message'] !!}</p>
                            <h6 class="mt-30 mb-0">@lang('Phone:')</h6>
                            <p>{{@$contact['single']['phone']}}</p>
                            <h6 class="mt-30 mb-0">@lang('Email:')</h6>
                            <p>{{@$contact['single']['email']}}</p>
                            <h6 class="mt-30 mb-0">@lang('Address:')</h6>
                            <p>{{@$contact['single']['address']}}</p>
                        </div>
                    </div>
                    <div class="col-xl-8 col-lg-6">
                        <div class="contact-message-area">
                            <form action="{{route('contact.send')}}" method="post">
                                @csrf
                                <div class="form_title mb-30">
                                    <h3>@lang('Drop Us a Line')
                                    </h3>
                                    <p>{!! @$contact['single']['drop_line_message'] !!}</p>
                                </div>
                                <div class="row">
                                    <div class="mb-3 col-md-6">
                                        <input type="text" name="name" value="{{old('name')}}" class="form-control"
                                               placeholder="@lang('Your Name')" required>
                                        @error('name')
                                        <span class="text-danger">{{$message}}</span>
                                        @enderror
                                    </div>
                                    <div class="mb-3 col-md-6">
                                        <input type="email" name="email" value="{{old('email')}}" class="form-control"
                                               placeholder="@lang('E-mail Address')" required>
                                        @error('email')
                                        <span class="text-danger">{{$message}}</span>
                                        @enderror
                                    </div>
                                    <div class="mb-3 col-md-12">
                                        <input type="text" name="subject"
                                               value="{{old('subject')}}" class="form-control"
                                               placeholder="@lang('Your Subject')" required>
                                        @error('subject')
                                        <span class="text-danger">{{$message}}</span>
                                        @enderror
                                    </div>
                                    <div class="mb-3 col-12">
                                        <textarea class="form-control" name="message" id="exampleFormControlTextarea1"
                                                  rows="3"
                                                  placeholder="@lang('Your Massage')" required></textarea>
                                        @error('message')
                                        <span class="text-danger">{{$message}}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="btn-area d-flex justify-content-end">
                                    <button type="submit" class="cmn-btn mt-30">@lang('Send a massage')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
<!-- Contact section end -->
