<!-- Blog Section start -->
@if(isset($blog))
    <section class="blog-section">
        <div class="container">
            @if(isset($blog['single']))
                <div class="row">
                    <div class="col-12">
                        <div class="section-header text-center mb-50">
                            <div class="section-subtitle">{{@$blog['single']['title']}}</div>
                            <h2 class="section-title mx-auto">{{@$blog['single']['heading']}}</h2>
                            <p class="cmn-para-text mx-auto">{!! @$blog['single']['description'] !!}</p>
                        </div>
                    </div>
                </div>
            @endif
            @if(isset($blog['multiple']) && count($blog['multiple']) > 0)
                @php
                    $loopNum = 0;
                    $currentUrl = url()->current();
                    $lastSegment = last(explode('/', $currentUrl));
                @endphp

                <div class="row g-4">
                    @foreach($blog['multiple']->reverse() as $key => $blog)
                        @if($lastSegment != 'blog' && $loopNum >= 3)
                            @break;
                        @endif
                        <div class="col-lg-4 col-md-6">
                            <div class="blog-box">
                                <div class="img-box">
                                    <img src="{{getFile($blog['media']->image->driver,$blog['media']->image->path)}}"
                                         alt="...">
                                </div>
                                <div class="content-box">
                                    <div class="blog-author">
                                        <div class="author-img">
                                            <img
                                                src="{{getFile($blog['media']->person_image->driver,$blog['media']->person_image->path)}}"
                                                alt="...">
                                        </div>
                                        <div class="author-info ">
                                            <a href="#">
                                                <h5>{{$blog['name']}}</h5>
                                            </a>
                                            <span>{{$blog['designation']}}</span>
                                        </div>
                                    </div>
                                    <div class=" blog-title">
                                        <h5>
                                            <a href="{{route('blog.details').'?id='.$blog['id'].'&slug='.slug($blog['title'])}}">{{$blog['title']}}</a>
                                        </h5>
                                    </div>
                                    <div class="pera-text">
                                        <p>{!! substr($blog['description'],0,115) !!}...
                                        </p>
                                    </div>
                                    <a href="{{route('blog.details').'?id='.$blog['id'].'&slug='.slug($blog['title'])}}"
                                       class="cmn-btn mt-30">@lang('read more') <i
                                            class="fa-regular fa-circle-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                        @php
                            $loopNum++
                        @endphp
                    @endforeach
                </div>
            @endif
        </div>
    </section>
@endif
<!-- Blog Section end -->
