<!DOCTYPE html>
<html lang="en" @if(session()->get('rtl') == 1) dir="rtl" @endif />
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="{{ getFile($basicControl->favicon_driver, $basicControl->favicon) }}" rel="icon">
    <title>@yield('page_title') | {{basicControl()->site_title}}</title>
    @include($theme.'partials.user.styles')
</head>
<body onload="preloder_function()" class="">

<div id="preloader">
    <div class="loader"></div>
</div>

@include($theme.'partials.user.topbar')
@include($theme.'partials.user.mobileNav')
@include($theme.'partials.user.sidebar')

<main id="main" class="main">
    <div class="pagetitle">
        <h3>@yield('page_title')</h3>
    </div>
    @if(basicControl()->email_checker)
        <button type="button" class="email-verification-btn" data-bs-toggle="offcanvas" data-bs-target="#emailVerify"
                aria-controls="emailVerify"><i class="fa-regular fa-badge-check"></i></button>
    @endif
    @section('content')
    @show
</main>
@include($theme.'partials.user.footer')

@include('plugins')

@include($theme.'partials.user.scripts')
@include($theme.'partials.user.flash-message')

@if(basicControl()->email_checker)
    @include($theme.'partials.user.email-verify')
@endif
</body>
</html>

