@extends($theme . 'layouts.docx')
@section('title',trans('Webhook'))
@section('content')
    @include($theme.'partials.api-sidebar')
    @php
        $siteTitle = basicControl()->site_title
    @endphp
    <main>
        <div class="main-wrapper">
            <div class="row g-4">
                <div class="col-12">
                    <div class="api-reference-section">
                        <div class="row">
                            <div class="col-12 mb-4">
                                <h3>@lang('#Webhook Events')</h3>
                                <p>
                                    @lang("Events are triggered during the $siteTitle. process, encompassing five key types: delivered,bounces,unique_opens,opens,unsubscribes")
                                </p>
                                <p>
                                    @lang("Configure your webhook URL through the user dashboard to seamlessly receive email processing events.")
                                </p>
                            </div>
                            <div class="col-12 mb-4">
                                <h5>@lang('Events')</h5>
                                <p>@lang("The event signifies the current stage of the email processing cycle.")</p>
                                <ol>
                                    <li class="mb-1 text-dark font-weight-bold">
                                        @lang("1. The message has been delivered successfully to the recipient's server. Event- delivered")
                                    </li>
                                    <li class="mb-1 text-dark font-weight-bold">
                                        @lang("2. The receiving server permanently declined or was unable to accept the email for this recipient. Event- bounces")
                                    </li>
                                    <li class="mb-1 text-dark font-weight-bold">
                                        @lang("3. Recipient has opened the HTML message in first time. Event- unique_opens")
                                    </li>
                                    <li class="mb-1 text-dark font-weight-bold">
                                        @lang("4. The recipient has initiated the first-time opening of the HTML message. Event- opens.")
                                    </li>
                                    <li class="mb-1 text-dark font-weight-bold">
                                        @lang("4. The recipient has selected to unsubscribe by clicking on the 'Opt Out of All Emails' link.")
                                    </li>
                                </ol>
                            </div>
                            <div class="col-md-6">
                                <div class="editor-content-area">
                                    <div class="tab-pane fade show active" id="cUrl" role="tabpanel"
                                         aria-labelledby="cUrl-tab" tabindex="0">
                                        <div class="language-bash">
                                            <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
[
  {
    "email": "example@gmail.com",
    "event": "delivered",
    "timestamp": "2023-12-21 19:32:57"
  },
  {
    "email": "example2@gmail.com",
    "event": "bounces",
    "timestamp": "2023-12-21 19:32:59"
  }
  {
    "email": "example3@gmail.com",
    "event": "unique_opens",
    "timestamp": "2023-10-21 18:32:57"
  }
  {
    "email": "example3@gmail.com",
    "event": "opens",
    "timestamp": "2023-10-21 18:32:57"
  }
  {
    "email": "alex@gmail.com",
    "event": "unsubscribes",
    "timestamp": "2022-10-21 18:32:57"
  }
]</code></pre>
                                                <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                            </div>
                                            <button onclick="copyTextFunc()" class="copy-code"
                                                    type="button"><i class="fa-regular fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        @include($theme.'partials.footer')
    </main>
@endsection
