@extends($theme . 'layouts.docx')
@section('title',trans('Sender'))
@section('content')
    @include($theme.'partials.api-sidebar')
    @php
        $baseUrl = url('/').'/api/'
    @endphp
    <main>
        <div class="main-wrapper">
            <div class="row g-4">
                <div class="col-12">
                    <div class="api-reference-section">
                        <div id="countyStateCityList" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Country, State, City List')</h4>
                                <p>
                                    @lang("To get the Country, State and City List follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}get/country-state-city</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl" type="button" role="tab"
                                                                aria-controls="cUrl" aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab" data-bs-toggle="pill"
                                                                data-bs-target="#PHP" type="button" role="tab"
                                                                aria-controls="PHP" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby" type="button" role="tab"
                                                                aria-controls="Ruby" aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js"
                                                                type="button" role="tab" aria-controls="Node-js"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Python" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js" role="tabpanel"
                                                     aria-labelledby="Node-js-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/get/country-state-city',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python" role="tabpanel"
                                                     aria-labelledby="Python-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/get/country-state-city"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP" role="tabpanel"
                                                     aria-labelledby="PHP-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/get/country-state-city',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl" role="tabpanel"
                                                     aria-labelledby="cUrl-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/get/country-state-city' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby" role="tabpanel"
                                                     aria-labelledby="Ruby-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/get/country-state-city")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab"
                                                                data-bs-toggle="pill" data-bs-target="#OK" type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request"
                                                                type="button" role="tab" aria-controls="Bad-Request"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK" role="tabpanel"
                                                     aria-labelledby="OK-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "countries": [
            ...
        ],
        "states": [
            ...
        ],
        "cities": [
            ...
        ],
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "PublicKey": [
            "The public key field is required."
        ],
        "SecretKey": [
            "The secret key field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>
                        <div id="senderList" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Sender List')</h4>
                                <p>
                                    @lang("To get sender list follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}senders</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab2"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl2" type="button" role="tab"
                                                                aria-controls="cUrl2"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#PHP2" type="button" role="tab"
                                                                aria-controls="PHP2" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby2" type="button" role="tab"
                                                                aria-controls="Ruby2"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js2"
                                                                type="button" role="tab" aria-controls="Node-js2"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Python2" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js2" role="tabpanel"
                                                     aria-labelledby="Node-js-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/senders',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python2" role="tabpanel"
                                                     aria-labelledby="Python-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/senders"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP2" role="tabpanel"
                                                     aria-labelledby="PHP-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/senders',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl2" role="tabpanel"
                                                     aria-labelledby="cUrl-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/senders' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby2" role="tabpanel"
                                                     aria-labelledby="Ruby-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/senders")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#OK2"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request2"
                                                                type="button" role="tab" aria-controls="Bad-Request2"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK2" role="tabpanel"
                                                     aria-labelledby="OK-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "senders": [
            {
                "id": 3,
                "user_id": 6790,
                "from_name": "Anik",
                "from_email": "anikdey141997@gmail.com",
                "reply_to_email": "anikdey141997@gmail.com",
                "country_id": 18,
                "state_id": 348,
                "city_id": 7291,
                "zip_code": "5202",
                "company_address": "house-10,road-10,khilkhet",
                "company_address2": "",
                "nickname": "Anik",
                "is_verified": 1,
                "utr": "653f8e5bab94b",
                "send_at": "2023-11-02 17:04:00",
                "created_at": "2023-10-30T11:07:07.000000Z",
                "updated_at": "2023-11-02T11:04:00.000000Z",
                "deleted_at": null
            },
            {
                "id": 2,
                "user_id": 6790,
                "from_name": "Bug Finder",
                "from_email": "bug@gmail.com",
                "reply_to_email": "finder@gmail.com",
                "country_id": 18,
                "state_id": 349,
                "city_id": 7296,
                "zip_code": "1001",
                "company_address": "Uttara sector-11",
                "company_address2": "Banani road-3",
                "nickname": "Bug",
                "is_verified": 1,
                "utr": "653f7eac7fa24",
                "send_at": "2023-10-30 16:00:40",
                "created_at": "2023-10-30T04:43:00.000000Z",
                "updated_at": "2023-10-30T07:24:41.000000Z",
                "deleted_at": null
            }
        ]
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request2" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "PublicKey": [
            "The public key field is required."
        ],
        "SecretKey": [
            "The secret key field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="senderCreate" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Sender Create')</h4>
                                <p>
                                    @lang("To create sender follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}sender/save</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>from_name<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">The name of the sender</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Amazon">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>from_email<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Email address. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="example@gmail.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>reply_to_email<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Please provide the email address to which you would like your
                                                    clients to direct their replies. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="reply@gmail.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>country_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You can get country id from get country state city api </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="18">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>state_id</b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You can get state id from get country state city api </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="180">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>city_id</b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You can get city id from get country state city api </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="2256">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>zip_code</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You provide your sender zip code </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="1656">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>company_address<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You need to provide your company details address here. Maximum
                                                    255
                                                    character</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="New York">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>company_address2</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    If you have company another address. Maximum 255 character</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Sydney">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>nickname<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Please specify the sender's nickname for identification
                                                    purposes. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Ama">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl3" type="button" role="tab"
                                                                aria-controls="cUrl3"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab3" data-bs-toggle="pill"
                                                                data-bs-target="#PHP3" type="button" role="tab"
                                                                aria-controls="PHP3"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby3" type="button" role="tab"
                                                                aria-controls="Ruby3"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js3"
                                                                type="button" role="tab" aria-controls="Node-js3"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python3" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js3" role="tabpanel"
                                                     aria-labelledby="Node-js-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/sender/save',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'from_name': 'Amazon',
    'from_email': 'amazon@gmail.com',
    'reply_to_email': 'amazon@gmail.com',
    'country_id': '18',
    'state_id': '348',
    'city_id': '7291',
    'zip_code': '6689',
    'company_address': 'New York',
    'company_address2': 'Sydney',
    'nickname': 'Ama'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python3" role="tabpanel"
                                                     aria-labelledby="Python-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/sender/save"

payload={'from_name': 'Amazon',
'from_email': 'amazon@gmail.com',
'reply_to_email': 'amazon@gmail.com',
'country_id': '18',
'state_id': '348',
'city_id': '7291',
'zip_code': '6689',
'company_address': 'New York',
'company_address2': 'Sydney',
'nickname': 'Ama'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP3" role="tabpanel"
                                                     aria-labelledby="PHP-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/sender/save',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('from_name' => 'Amazon','from_email' => 'amazon@gmail.com','reply_to_email' => 'amazon@gmail.com','country_id' => '18',
                               'state_id' => '348','city_id' => '7291','zip_code' => '6689','company_address' => 'New York','company_address2' => 'Sydney','nickname' => 'Ama'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl3" role="tabpanel"
                                                     aria-labelledby="cUrl-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/sender/save' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'from_name="Amazon"' \
--form 'from_email="amazon@gmail.com"' \
--form 'reply_to_email="amazon@gmail.com"' \
--form 'country_id="18"' \
--form 'state_id="348"' \
--form 'city_id="7291"' \
--form 'zip_code="6689"' \
--form 'company_address="New York"' \
--form 'company_address2="Sydney"' \
--form 'nickname="Ama"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby3" role="tabpanel"
                                                     aria-labelledby="Ruby-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/sender/save")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['from_name', 'Amazon'],['from_email', 'amazon@gmail.com'],
['reply_to_email', 'amazon@gmail.com'],['country_id', '18'],
['state_id', '348'],['city_id', '7291'],['zip_code', '6689'],['company_address', 'New York'],['company_address2', 'Sydney'],['nickname', 'Ama']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#OK3"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request3"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK3" role="tabpanel"
                                                     aria-labelledby="OK-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Added Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request3" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "from_name": [
            "The from name field is required."
        ],
        "from_email": [
            "The from email field is required."
        ],
        "reply_to_email": [
            "The reply to email field is required."
        ],
        "country_id": [
            "The country id field is required."
        ],
        "company_address": [
            "The company address field is required."
        ],
        "nickname": [
            "The nickname field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="senderDetails" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Sender Details')</h4>
                                <p>
                                    @lang("To see sender details follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}sender/details?sender_id={sender_id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl4" type="button" role="tab"
                                                                aria-controls="cUrl4"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab4" data-bs-toggle="pill"
                                                                data-bs-target="#PHP4" type="button" role="tab"
                                                                aria-controls="PHP4"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby4" type="button" role="tab"
                                                                aria-controls="Ruby4"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js4"
                                                                type="button" role="tab" aria-controls="Node-js4"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python4" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js4" role="tabpanel"
                                                     aria-labelledby="Node-js-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/sender/details?sender_id=4',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python4" role="tabpanel"
                                                     aria-labelledby="Python-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/sender/details?sender_id=4"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP4" role="tabpanel"
                                                     aria-labelledby="PHP-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/sender/details?sender_id=4',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl4" role="tabpanel"
                                                     aria-labelledby="cUrl-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/sender/details?sender_id=4' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby4" role="tabpanel"
                                                     aria-labelledby="Ruby-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/sender/details?sender_id=4")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#OK4"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request4"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK4" role="tabpanel"
                                                     aria-labelledby="OK-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "sender": {
            "id": 4,
            "user_id": 6790,
            "from_name": "Amazon",
            "from_email": "amazon@gmail.com",
            "reply_to_email": "amazon@gmail.com",
            "country_id": 18,
            "state_id": 348,
            "city_id": 7291,
            "zip_code": "6689",
            "company_address": "New York",
            "company_address2": "Sydney",
            "nickname": "Ama",
            "is_verified": 0,
            "utr": "656b09ab9109a",
            "send_at": "2023-12-02 16:40:43",
            "created_at": "2023-12-02T10:40:43.000000Z",
            "updated_at": "2023-12-02T10:40:43.000000Z",
            "deleted_at": null
        }
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request4" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="senderUpdate" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Sender Update')</h4>
                                <p>
                                    @lang("To Update Sender Information follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}sender/update</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>sender_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">Please indicate the sender ID for the sender whose
                                                    information you would like to update </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="4">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>from_name<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">The name of the sender</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Amazon">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>from_email<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Email address. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="example@gmail.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>reply_to_email<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Please provide the email address to which you would like your
                                                    clients to direct their replies. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="reply@gmail.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>country_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You can get country id from get country state city api </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="18">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>state_id</b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You can get state id from get country state city api </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="180">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>city_id</b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You can get city id from get country state city api </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="2256">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>zip_code</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You provide your sender zip code </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="1656">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>company_address<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You need to provide your company details address here. Maximum
                                                    255
                                                    character</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="New York">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>company_address2</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    If you have company another address. Maximum 255 character</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Sydney">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>nickname<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Please specify the sender's nickname for identification
                                                    purposes. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Ama">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl5" type="button" role="tab"
                                                                aria-controls="cUrl5"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab5" data-bs-toggle="pill"
                                                                data-bs-target="#PHP5" type="button" role="tab"
                                                                aria-controls="PHP5"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby5" type="button" role="tab"
                                                                aria-controls="Ruby5"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js5"
                                                                type="button" role="tab" aria-controls="Node-js5"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python5" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js5" role="tabpanel"
                                                     aria-labelledby="Node-js-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/sender/update',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'sender_id': '4',
    'from_name': 'Amazon',
    'from_email': 'amazon@gmail.com',
    'reply_to_email': 'amazon@gmail.com',
    'country_id': '18',
    'state_id': '348',
    'city_id': '7291',
    'zip_code': '6689',
    'company_address': 'New York',
    'company_address2': 'Sydney',
    'nickname': 'Ama'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python5" role="tabpanel"
                                                     aria-labelledby="Python-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/sender/update"

payload={'sender_id': '4',
'from_name': 'Amazon',
'from_email': 'amazon@gmail.com',
'reply_to_email': 'amazon@gmail.com',
'country_id': '18',
'state_id': '348',
'city_id': '7291',
'zip_code': '6689',
'company_address': 'New York',
'company_address2': 'Sydney',
'nickname': 'Ama'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP5" role="tabpanel"
                                                     aria-labelledby="PHP-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/sender/update',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('sender_id' => '4','from_name' => 'Amazon','from_email' => 'amazon@gmail.com','reply_to_email' => 'amazon@gmail.com','country_id' => '18',
                              'state_id' => '348','city_id' => '7291','zip_code' => '6689','company_address' => 'New York','company_address2' => 'Sydney','nickname' => 'Ama'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl5" role="tabpanel"
                                                     aria-labelledby="cUrl-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/sender/update' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'sender_id="4"' \
--form 'from_name="Amazon"' \
--form 'from_email="amazon@gmail.com"' \
--form 'reply_to_email="amazon@gmail.com"' \
--form 'country_id="18"' \
--form 'state_id="348"' \
--form 'city_id="7291"' \
--form 'zip_code="6689"' \
--form 'company_address="New York"' \
--form 'company_address2="Sydney"' \
--form 'nickname="Ama"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby5" role="tabpanel"
                                                     aria-labelledby="Ruby-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/sender/update")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['sender_id', '4'],['from_name', 'Amazon'],['from_email', 'amazon@gmail.com'],['reply_to_email', 'amazon@gmail.com'],['country_id', '18'],
            ['state_id', '348'],['city_id', '7291'],['zip_code', '6689'],['company_address', 'New York'],['company_address2', 'Sydney'],['nickname', 'Ama']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#OK5"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request5"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request5"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK5" role="tabpanel"
                                                     aria-labelledby="OK-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Updated Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request5" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "email_address": [
            "The email address field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="senderDelete" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Sender Delete')</h4>
                                <p>
                                    @lang("To delete sender follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>DELETE</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}sender/delete?sender_id={sender_id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl6" type="button" role="tab"
                                                                aria-controls="cUrl6"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab6" data-bs-toggle="pill"
                                                                data-bs-target="#PHP6" type="button" role="tab"
                                                                aria-controls="PHP6"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby6" type="button" role="tab"
                                                                aria-controls="Ruby6"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js6"
                                                                type="button" role="tab" aria-controls="Node-js6"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python6" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js6" role="tabpanel"
                                                     aria-labelledby="Node-js-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'DELETE',
  'url': 'BASE_URL/sender/delete?sender_id=5',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python6" role="tabpanel"
                                                     aria-labelledby="Python-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/sender/delete?sender_id=5"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("DELETE", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP6" role="tabpanel"
                                                     aria-labelledby="PHP-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/sender/delete?sender_id=5',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'DELETE',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl6" role="tabpanel"
                                                     aria-labelledby="cUrl-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request DELETE 'BASE_URL/sender/delete?sender_id=5' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby6" role="tabpanel"
                                                     aria-labelledby="Ruby-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/sender/delete?sender_id=5")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Delete.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#OK6"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request6"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request6"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK6" role="tabpanel"
                                                     aria-labelledby="OK-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "errors": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request6" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="resendVerification" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Resend Verification')</h4>
                                <p>
                                    @lang("To Resend Verification link follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}sender/resend-mail?sender_id={sender_id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl7" type="button" role="tab"
                                                                aria-controls="cUrl7"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab7" data-bs-toggle="pill"
                                                                data-bs-target="#PHP7" type="button" role="tab"
                                                                aria-controls="PHP7"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby7" type="button" role="tab"
                                                                aria-controls="Ruby7"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js7"
                                                                type="button" role="tab" aria-controls="Node-js7"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python7" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js7" role="tabpanel"
                                                     aria-labelledby="Node-js-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/sender/resend-mail?sender_id=4',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});




                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python7" role="tabpanel"
                                                     aria-labelledby="Python-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/sender/resend-mail?sender_id=4"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP7" role="tabpanel"
                                                     aria-labelledby="PHP-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/sender/resend-mail?sender_id=4',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl7" role="tabpanel"
                                                     aria-labelledby="cUrl-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/sender/resend-mail?sender_id=4' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby7" role="tabpanel"
                                                     aria-labelledby="Ruby-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/sender/resend-mail?sender_id=4")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#OK7"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request7"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request7"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK7" role="tabpanel"
                                                     aria-labelledby="OK-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Verification Mail Send"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request7" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include($theme.'partials.footer')
    </main>
@endsection

