@extends($theme . 'layouts.docx')
@section('title',trans('Contact Type'))
@section('content')
    @include($theme.'partials.api-sidebar')
    @php
        $baseUrl = url('/').'/api/'
    @endphp
    <main>
        <div class="main-wrapper">
            <div class="row g-4">
                <div class="col-12">
                    <div class="api-reference-section">
                        <div class="row g-4 mb-4" id="contactTypeList">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Type List')</h4>
                                <p>
                                    @lang("To get Contact Type List follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i></p>
                                <hr/>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts-type</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr/>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab"
                                                                data-bs-toggle="pill" data-bs-target="#cUrl"
                                                                type="button" role="tab" aria-controls="cUrl"
                                                                aria-selected="false">@lang("cURL")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab" data-bs-toggle="pill"
                                                                data-bs-target="#PHP" type="button" role="tab"
                                                                aria-controls="PHP"
                                                                aria-selected="false">@lang("PHP")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby" type="button" role="tab"
                                                                aria-controls="Ruby"
                                                                aria-selected="false">@lang("Ruby")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Node-js" type="button" role="tab"
                                                                aria-controls="Node-js"
                                                                aria-selected="true">@lang("Node.js")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Python" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js" role="tabpanel"
                                                     aria-labelledby="Node-js-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/contacts-type',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span>
                                                            <span>16</span>
                                                            <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python" role="tabpanel"
                                                     aria-labelledby="Python-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts-type"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP" role="tabpanel"
                                                     aria-labelledby="PHP-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts-type',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl" role="tabpanel"
                                                     aria-labelledby="cUrl-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/contacts-type' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby" role="tabpanel"
                                                     aria-labelledby="Ruby-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts-type")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab"
                                                                data-bs-toggle="pill" data-bs-target="#OK" type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request"
                                                                type="button" role="tab" aria-controls="Bad-Request"
                                                                aria-selected="false">
                                                            400 Bad Request
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK" role="tabpanel"
                                                     aria-labelledby="OK-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "contactTypes": [
            {
                "id": 3,
                "user_id": 6790,
                "name": "Friend Lists",
                "deleted_at": null,
                "created_at": "2023-11-02T09:02:47.000000Z",
                "updated_at": "2023-11-02T09:02:47.000000Z",
                "contacts_count": 6
            },
            {
                "id": 4,
                "user_id": 6790,
                "name": "Office Colleague",
                "deleted_at": null,
                "created_at": "2023-11-02T09:25:11.000000Z",
                "updated_at": "2023-11-02T09:25:11.000000Z",
                "contacts_count": 1
            },
        ]
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "PublicKey": [
            "The public key field is required."
        ],
        "SecretKey": [
            "The secret key field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="contactTypeAdd" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Type Add')</h4>
                                <p>
                                    @lang("To add contact type follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i></p>
                                <hr/>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts-type/add</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr/>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>name<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">name should be min character 2</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Friend List"/>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#cUrl2"
                                                                type="button" role="tab" aria-controls="cUrl2"
                                                                aria-selected="false">@lang("cURL")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#PHP2" type="button" role="tab"
                                                                aria-controls="PHP2"
                                                                aria-selected="false">@lang("PHP")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby2" type="button" role="tab"
                                                                aria-controls="Ruby2"
                                                                aria-selected="false">@lang("Ruby")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Node-js2" type="button" role="tab"
                                                                aria-controls="Node-js2"
                                                                aria-selected="true">@lang("Node.js")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Python2" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js2" role="tabpanel"
                                                     aria-labelledby="Node-js-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                    <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/contacts-type/add',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'name': 'Friend List'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                        <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                        <span>13</span><span>14</span><span>15</span>
                                                        <span>16</span>
                                                        <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                    </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python2" role="tabpanel"
                                                     aria-labelledby="Python-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                    <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts-type/add"

payload={'name': 'Friend List'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                        <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                        <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span>
                                                        <span>25</span><span>26</span>
                                                    </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP2" role="tabpanel"
                                                     aria-labelledby="PHP-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                    <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts-type/add',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('name' => 'Friend List'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                        <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                        <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span>
                                                        <span>25</span><span>26</span>
                                                    </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl2" role="tabpanel"
                                                     aria-labelledby="cUrl-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                    <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/contacts-type/add' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'name="Friend List"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                        <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                        <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span>
                                                        <span>25</span><span>26</span>
                                                    </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby2" role="tabpanel"
                                                     aria-labelledby="Ruby-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                    <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts-type/add")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['name', 'Friend List']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                        <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                        <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span>
                                                        <span>25</span><span>26</span>
                                                    </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#OK2"
                                                                type="button" role="tab" aria-controls="OK"
                                                                aria-selected="true">200 OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request2"
                                                                type="button" role="tab" aria-controls="Bad-Request2"
                                                                aria-selected="false">
                                                            400 Bad Request
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK2" role="tabpanel"
                                                     aria-labelledby="OK-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                    <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Added Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                        <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                        <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span>
                                                        <span>25</span><span>26</span>
                                                    </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request2" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                    <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "name": [
            "The name field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                        <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                        <span>13</span><span>14</span>
                                                    </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="contactTypeView" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Type View')</h4>
                                <p>
                                    @lang("To view details contact type follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr/>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary"> {{$baseUrl}}
                                        contacts-type/view?contact_type_id={contact_type_id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr/>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#cUrl3"
                                                                type="button" role="tab" aria-controls="cUrl3"
                                                                aria-selected="false">@lang("cURL")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab3" data-bs-toggle="pill"
                                                                data-bs-target="#PHP3" type="button" role="tab"
                                                                aria-controls="PHP3"
                                                                aria-selected="false">@lang("PHP")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Ruby3"
                                                                type="button" role="tab" aria-controls="Ruby3"
                                                                aria-selected="false">@lang("Ruby")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js3"
                                                                type="button" role="tab" aria-controls="Node-js3"
                                                                aria-selected="true">@lang("Node.js")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Python3"
                                                                type="button" role="tab" aria-controls="Python"
                                                                aria-selected="false">@lang("Python")</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js3" role="tabpanel"
                                                     aria-labelledby="Node-js-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/contacts-type/view?contact_type_id=5',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});
});




                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span>
                                                            <span>16</span>
                                                            <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python3" role="tabpanel"
                                                     aria-labelledby="Python-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts-type/view?contact_type_id=5"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP3" role="tabpanel"
                                                     aria-labelledby="PHP-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts-type/view?contact_type_id=5',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl3" role="tabpanel"
                                                     aria-labelledby="cUrl-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/contacts-type/view?contact_type_id=5' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby3" role="tabpanel"
                                                     aria-labelledby="Ruby-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts-type/view?contact_type_id=5")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#OK3"
                                                                type="button" role="tab" aria-controls="OK"
                                                                aria-selected="true">200 OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request3"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3" aria-selected="false">
                                                            400 Bad Request
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK3" role="tabpanel"
                                                     aria-labelledby="OK-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "contactType": {
            "id": 5,
            "user_id": 6790,
            "name": "Client List",
            "deleted_at": null,
            "created_at": "2023-11-08T05:16:49.000000Z",
            "updated_at": "2023-11-08T05:16:49.000000Z"
        }
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request3" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "field_name": [
            "The field name field is required."
        ],
        "field_type": [
            "The field type field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="contactTypeUpdate" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Type Update')</h4>
                                <p>
                                    @lang("To contact type follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr/>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts-type/update</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr/>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">This is contact type id</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="20"/>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>name<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">The name should be min 2 character</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Friend List"/>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#cUrl4"
                                                                type="button" role="tab" aria-controls="cUrl4"
                                                                aria-selected="false">@lang("cURL")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab4" data-bs-toggle="pill"
                                                                data-bs-target="#PHP4" type="button" role="tab"
                                                                aria-controls="PHP4"
                                                                aria-selected="false">@lang("PHP")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Ruby4"
                                                                type="button" role="tab" aria-controls="Ruby4"
                                                                aria-selected="false">@lang("Ruby")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js4"
                                                                type="button" role="tab" aria-controls="Node-js4"
                                                                aria-selected="true">@lang("Node.js")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Python4"
                                                                type="button" role="tab" aria-controls="Python"
                                                                aria-selected="false">@lang("Python")</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js4" role="tabpanel"
                                                     aria-labelledby="Node-js-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/contacts-type/update',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'id': '5',
    'name': 'Friend List'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span>
                                                            <span>16</span>
                                                            <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python4" role="tabpanel"
                                                     aria-labelledby="Python-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts-type/update"

payload={'id': '5',
'name': 'Friend List'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP4" role="tabpanel"
                                                     aria-labelledby="PHP-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts-type/update',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('id' => '5','name' => 'Friend List'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl4" role="tabpanel"
                                                     aria-labelledby="cUrl-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/contacts-type/update' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'id="5"' \
--form 'name="Friend List"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby4" role="tabpanel"
                                                     aria-labelledby="Ruby-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts-type/update")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['id', '5'],['name', 'Friend List']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#OK4"
                                                                type="button" role="tab" aria-controls="OK"
                                                                aria-selected="true">200 OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request4"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3" aria-selected="false">
                                                            400 Bad Request
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK4" role="tabpanel"
                                                     aria-labelledby="OK-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Updated Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request4" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="contactTypeDelete" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Type Delete')</h4>
                                <p>
                                    @lang("To delete contact type follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr/>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>DELETE</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary"> {{$baseUrl}}
                                        contacts-type/delete?contact_type_id={contact_type_id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr/>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#cUrl6"
                                                                type="button" role="tab" aria-controls="cUrl6"
                                                                aria-selected="false">@lang("cURL")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab6" data-bs-toggle="pill"
                                                                data-bs-target="#PHP6" type="button" role="tab"
                                                                aria-controls="PHP6"
                                                                aria-selected="false">@lang("PHP")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Ruby6"
                                                                type="button" role="tab" aria-controls="Ruby6"
                                                                aria-selected="false">@lang("Ruby")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js6"
                                                                type="button" role="tab" aria-controls="Node-js6"
                                                                aria-selected="true">@lang("Node.js")</button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Python6"
                                                                type="button" role="tab" aria-controls="Python"
                                                                aria-selected="false">@lang("Python")</button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js6" role="tabpanel"
                                                     aria-labelledby="Node-js-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'DELETE',
  'url': 'BASE_URL/contacts-type/delete?contact_type_id=15',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span>
                                                            <span>16</span>
                                                            <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python6" role="tabpanel"
                                                     aria-labelledby="Python-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts-type/delete?contact_type_id=15"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("DELETE", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP6" role="tabpanel"
                                                     aria-labelledby="PHP-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts-type/delete?contact_type_id=15',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'DELETE',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl6" role="tabpanel"
                                                     aria-labelledby="cUrl-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
curl --location --request DELETE 'BASE_URL/contacts-type/delete?contact_type_id=15' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby6" role="tabpanel"
                                                     aria-labelledby="Ruby-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts-type/delete?contact_type_id=15")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Delete.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#OK6"
                                                                type="button" role="tab" aria-controls="OK"
                                                                aria-selected="true">200 OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request6"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request6" aria-selected="false">
                                                            400 Bad Request
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK6" role="tabpanel"
                                                     aria-labelledby="OK-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "errors": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span><span>15</span> <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span>
                                                            <span>24</span><span>25</span><span>26</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request6" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                        <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                            <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span>
                                                            <span>13</span><span>14</span>
                                                        </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include($theme.'partials.footer')
    </main>

@endsection

