@extends($theme . 'layouts.docx')
@section('title',trans('Contact'))
@section('content')
    @include($theme.'partials.api-sidebar')
    @php
        $baseUrl = url('/').'/api/'
    @endphp
    <main>
        <div class="main-wrapper">
            <div class="row g-4">
                <div class="col-12">
                    <div class="api-reference-section">
                        <div id="contactList" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Contact List')</h4>
                                <p>
                                    @lang("To get contact list follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts/list</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl" type="button" role="tab"
                                                                aria-controls="cUrl" aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab" data-bs-toggle="pill"
                                                                data-bs-target="#PHP" type="button" role="tab"
                                                                aria-controls="PHP" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby" type="button" role="tab"
                                                                aria-controls="Ruby" aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js"
                                                                type="button" role="tab" aria-controls="Node-js"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Python" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js" role="tabpanel"
                                                     aria-labelledby="Node-js-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/contacts/list',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python" role="tabpanel"
                                                     aria-labelledby="Python-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/list"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP" role="tabpanel"
                                                     aria-labelledby="PHP-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/list',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl" role="tabpanel"
                                                     aria-labelledby="cUrl-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/contacts/list' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby" role="tabpanel"
                                                     aria-labelledby="Ruby-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/list")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab"
                                                                data-bs-toggle="pill" data-bs-target="#OK" type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request"
                                                                type="button" role="tab" aria-controls="Bad-Request"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK" role="tabpanel"
                                                     aria-labelledby="OK-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "contacts": [
            {
                "id": 24,
                "user_id": 6790,
                "contact_type_id": 3,
                "first_name": "Alex",
                "last_name": "Hels",
                "email": "alex@gmail.com",
                "alt_email": "",
                "country": "France",
                "state": "Corsica",
                "city": "Colmar",
                "address_line1": "agen",
                "address_line2": "",
                "state_province_region": "agen",
                "postal_code": "6301",
                "custom_field": null,
                "deleted_at": null,
                "created_at": "2023-11-26T05:25:00.000000Z",
                "updated_at": "2023-11-26T05:25:00.000000Z",
                "fullname": "Alex Hels",
                "contact_type": {
                    "id": 3,
                    "user_id": 6790,
                    "name": "Friend Lists",
                    "deleted_at": null,
                    "created_at": "2023-11-02T09:02:47.000000Z",
                    "updated_at": "2023-11-02T09:02:47.000000Z"
                }
            },
            {
                "id": 23,
                "user_id": 6790,
                "contact_type_id": 3,
                "first_name": "Test",
                "last_name": "Demo",
                "email": "testdemo@gmail.com",
                "alt_email": "testdemoalt@gmail.com",
                "country": "Antarctica",
                "state": "",
                "city": "",
                "address_line1": "",
                "address_line2": "",
                "state_province_region": "",
                "postal_code": "",
                "custom_field": {
                    "full_name": {
                        "field_name": "Full name",
                        "field_value": ""
                    },
                    "join_date": {
                        "field_name": "Join date",
                        "field_value": ""
                    },
                    "father_name": {
                        "field_name": "Father name",
                        "field_value": ""
                    },
                    "designation": {
                        "field_name": "Designation",
                        "field_value": ""
                    },
                    "age": {
                        "field_name": "Age",
                        "field_value": ""
                    }
                },
                "deleted_at": null,
                "created_at": "2023-11-26T05:14:10.000000Z",
                "updated_at": "2023-11-26T05:14:10.000000Z",
                "fullname": "Test Demo",
                "contact_type": {
                    "id": 3,
                    "user_id": 6790,
                    "name": "Friend Lists",
                    "deleted_at": null,
                    "created_at": "2023-11-02T09:02:47.000000Z",
                    "updated_at": "2023-11-02T09:02:47.000000Z"
                }
            },
        ]
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "PublicKey": [
            "The public key field is required."
        ],
        "SecretKey": [
            "The secret key field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>
                        <div id="singleAdd" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Single Add')</h4>
                                <p>
                                    @lang("To create new contact follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts/add</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>contact_type_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The contact type id you will get from contact type collection. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="25">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>first_name</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Your contact first name </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="John">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>last_name</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Your contact last name</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Doe">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>email<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Your contact email address</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="example@gmail.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>country<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The country id of your contact. you will find country it from get
                                                    country,state,city endpoint</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="18">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>state</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The state name of contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Dhaka">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>city</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The city name of contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Rajbari">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>address_line1</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Details address of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="123 some road">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>address_line2</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Details address of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="156 some road">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>state_province_region</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    State province region of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="123 some road">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>postal_code</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Postal code of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="6985">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab2"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl2" type="button" role="tab"
                                                                aria-controls="cUrl2"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#PHP2" type="button" role="tab"
                                                                aria-controls="PHP2" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby2" type="button" role="tab"
                                                                aria-controls="Ruby2"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js2"
                                                                type="button" role="tab" aria-controls="Node-js2"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Python2" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js2" role="tabpanel"
                                                     aria-labelledby="Node-js-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/contacts/add',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'contact_type_id': '3',
    'first_name': 'Seikh ',
    'last_name': 'Hasina',
    'email': 'hasina@gmail.com',
    'country': '10',
    'state': 'Belgium',
    'city': 'Beli',
    'address_line1': 'New jursey',
    'address_line2': '',
    'state_province_region': '',
    'postal_code': '2365'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python2" role="tabpanel"
                                                     aria-labelledby="Python-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/add"

payload={'contact_type_id': '3',
'first_name': 'Seikh ',
'last_name': 'Hasina',
'email': 'hasina@gmail.com',
'country': '10',
'state': 'Belgium',
'city': 'Beli',
'address_line1': 'New jursey',
'address_line2': '',
'state_province_region': '',
'postal_code': '2365'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP2" role="tabpanel"
                                                     aria-labelledby="PHP-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/add',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('contact_type_id' => '3','first_name' => 'Seikh ','last_name' => 'Hasina','email' => 'hasina@gmail.com',
                               'country' => '10','state' => 'Belgium','city' => 'Beli','address_line1' => 'New jursey','address_line2' => '','state_province_region' => '','postal_code' => '2365'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl2" role="tabpanel"
                                                     aria-labelledby="cUrl-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/contacts/add' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'contact_type_id="3"' \
--form 'first_name="Seikh "' \
--form 'last_name="Hasina"' \
--form 'email="hasina@gmail.com"' \
--form 'country="10"' \
--form 'state="Belgium"' \
--form 'city="Beli"' \
--form 'address_line1="New jursey"' \
--form 'address_line2=""' \
--form 'state_province_region=""' \
--form 'postal_code="2365"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby2" role="tabpanel"
                                                     aria-labelledby="Ruby-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/add")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['contact_type_id', '3'],['first_name', 'Seikh '],['last_name', 'Hasina'],['email', 'hasina@gmail.com'],
            ['country', '10'],['state', 'Belgium'],['city', 'Beli'],['address_line1', 'New jursey'],['address_line2', ''],['state_province_region', ''],['postal_code', '2365']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#OK2"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request2"
                                                                type="button" role="tab" aria-controls="Bad-Request2"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK2" role="tabpanel"
                                                     aria-labelledby="OK-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Contact Added Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request2" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "email": [
            "The email field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="sampleDownload" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Sample Download')</h4>
                                <p>
                                    @lang("To download sample of the contact list csv follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts/csv-sample/download</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl3" type="button" role="tab"
                                                                aria-controls="cUrl3"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab3" data-bs-toggle="pill"
                                                                data-bs-target="#PHP3" type="button" role="tab"
                                                                aria-controls="PHP3"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby3" type="button" role="tab"
                                                                aria-controls="Ruby3"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js3"
                                                                type="button" role="tab" aria-controls="Node-js3"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python3" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js3" role="tabpanel"
                                                     aria-labelledby="Node-js-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/contacts/csv-sample/download',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python3" role="tabpanel"
                                                     aria-labelledby="Python-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/csv-sample/download"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP3" role="tabpanel"
                                                     aria-labelledby="PHP-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/csv-sample/download',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl3" role="tabpanel"
                                                     aria-labelledby="cUrl-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/contacts/csv-sample/download' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby3" role="tabpanel"
                                                     aria-labelledby="Ruby-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/csv-sample/download")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#OK3"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request3"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK3" role="tabpanel"
                                                     aria-labelledby="OK-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{

}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request3" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="uploadCSV" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Upload CSV')</h4>
                                <p>
                                    @lang("To upload contact csv follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts/upload-csv</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>contact_type_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    You wull get contact type id from contact type endpoint </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="18">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>file<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">file</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    File should be type file and only csv extension allow. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="file">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl4" type="button" role="tab"
                                                                aria-controls="cUrl4"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab4" data-bs-toggle="pill"
                                                                data-bs-target="#PHP4" type="button" role="tab"
                                                                aria-controls="PHP4"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby4" type="button" role="tab"
                                                                aria-controls="Ruby4"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js4"
                                                                type="button" role="tab" aria-controls="Node-js4"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab4"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python4" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js4" role="tabpanel"
                                                     aria-labelledby="Node-js-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var fs = require('fs');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/contacts/upload-csv',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'contact_type_id': '3',
    'file': {
      'value': fs.createReadStream('/C:/Users/Ronnie/Downloads/contacts-upload-sample.csv'),
      'options': {
        'filename': '/C:/Users/Ronnie/Downloads/contacts-upload-sample.csv',
        'contentType': null
      }
    }
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python4" role="tabpanel"
                                                     aria-labelledby="Python-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/upload-csv"

payload={'contact_type_id': '3'}
files=[
  ('file',('contacts-upload-sample.csv',open('/C:/Users/Ronnie/Downloads/contacts-upload-sample.csv','rb'),'text/csv'))
]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP4" role="tabpanel"
                                                     aria-labelledby="PHP-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/upload-csv',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('contact_type_id' => '3','file'=> new CURLFILE('/C:/Users/Ronnie/Downloads/contacts-upload-sample.csv')),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl4" role="tabpanel"
                                                     aria-labelledby="cUrl-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/contacts/upload-csv' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'contact_type_id="3"' \
--form 'file=@"/C:/Users/Ronnie/Downloads/contacts-upload-sample.csv"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby4" role="tabpanel"
                                                     aria-labelledby="Ruby-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/upload-csv")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['contact_type_id', '3'],['file', File.open('/C:/Users/Ronnie/Downloads/contacts-upload-sample.csv')]]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#OK4"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab4"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request4"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK4" role="tabpanel"
                                                     aria-labelledby="OK-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Imported Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request4" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab4" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "contact_type_id": [
            "The contact type id field is required."
        ],
        "file": [
            "The file field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="contactDetails" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Contact Details')</h4>
                                <p>
                                    @lang("To get contact details follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts/details?contact_id={contact_id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl5" type="button" role="tab"
                                                                aria-controls="cUrl5"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab5" data-bs-toggle="pill"
                                                                data-bs-target="#PHP5" type="button" role="tab"
                                                                aria-controls="PHP5"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby5" type="button" role="tab"
                                                                aria-controls="Ruby5"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js5"
                                                                type="button" role="tab" aria-controls="Node-js5"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python5" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js5" role="tabpanel"
                                                     aria-labelledby="Node-js-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/contacts/details?contact_id=25',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python5" role="tabpanel"
                                                     aria-labelledby="Python-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/details?contact_id=25"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP5" role="tabpanel"
                                                     aria-labelledby="PHP-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/details?contact_id=25',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl5" role="tabpanel"
                                                     aria-labelledby="cUrl-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/contacts/details?contact_id=25' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby5" role="tabpanel"
                                                     aria-labelledby="Ruby-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/details?contact_id=25")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body

</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#OK5"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request5"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request5"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK5" role="tabpanel"
                                                     aria-labelledby="OK-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "contact": {
            "id": 25,
            "user_id": 6790,
            "contact_type_id": 3,
            "first_name": "Seikh",
            "last_name": "Hasina",
            "email": "hasina@gmail.com",
            "alt_email": null,
            "country": "10",
            "state": "Belgium",
            "city": "Beli",
            "address_line1": "New jursey",
            "address_line2": "",
            "state_province_region": "",
            "postal_code": "2365",
            "custom_field": {
                "full_name": {
                    "field_name": "Full name",
                    "field_value": null
                },
                "father_name": {
                    "field_name": "Father name",
                    "field_value": null
                },
                "designation": {
                    "field_name": "Designation",
                    "field_value": null
                },
                "age": {
                    "field_name": "Age",
                    "field_value": null
                },
                "company_name": {
                    "field_name": "Company name",
                    "field_value": null
                },
                "birth_date": {
                    "field_name": "Birth date",
                    "field_value": null
                },
                "join_date": {
                    "field_name": "Join date",
                    "field_value": null
                }
            },
            "deleted_at": null,
            "created_at": "2023-12-05T09:37:00.000000Z",
            "updated_at": "2023-12-05T09:37:00.000000Z",
            "fullname": "Seikh Hasina"
        }
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request5" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="contactUpdate" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Contact Update')</h4>
                                <p>
                                    @lang("To update contact follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">
                                        {{$baseUrl}}contacts/update</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>contact_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The contact id which contact you want to update. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="25">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>contact_type_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The contact type id you will get from contact type
                                                    collection. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="25">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>first_name</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Your contact first name </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="John">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>last_name</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Your contact last name</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Doe">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>email<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Your contact email address</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="example@gmail.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>country<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The country id of your contact. you will find country it from
                                                    get
                                                    country,state,city endpoint</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="18">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>state</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The state name of contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Dhaka">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>city</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The city name of contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Rajbari">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>address_line1</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Details address of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="123 some road">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>address_line2</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Details address of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="156 some road">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>state_province_region</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    State province region of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="123 some road">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>postal_code</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Postal code of your contact</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="6985">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl6" type="button" role="tab"
                                                                aria-controls="cUrl6"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab6" data-bs-toggle="pill"
                                                                data-bs-target="#PHP6" type="button" role="tab"
                                                                aria-controls="PHP6"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby6" type="button" role="tab"
                                                                aria-controls="Ruby6"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js6"
                                                                type="button" role="tab" aria-controls="Node-js6"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python6" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js6" role="tabpanel"
                                                     aria-labelledby="Node-js-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/contacts/update',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'contact_id': '25',
    'contact_type_id': '3',
    'first_name': 'Seikh ',
    'last_name': 'Hasina',
    'email': 'hasina@gmail.com',
    'country': '10',
    'state': 'Belgium',
    'city': 'Beli',
    'address_line1': 'New jursey',
    'address_line2': '',
    'state_province_region': '',
    'postal_code': '2365'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python6" role="tabpanel"
                                                     aria-labelledby="Python-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/update"

payload={'contact_id': '25',
'contact_type_id': '3',
'first_name': 'Seikh ',
'last_name': 'Hasina',
'email': 'hasina@gmail.com',
'country': '10',
'state': 'Belgium',
'city': 'Beli',
'address_line1': 'New jursey',
'address_line2': '',
'state_province_region': '',
'postal_code': '2365'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP6" role="tabpanel"
                                                     aria-labelledby="PHP-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/update',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('contact_id' => '25','contact_type_id' => '3','first_name' => 'Seikh ','last_name' => 'Hasina','email' => 'hasina@gmail.com',
                               'country' => '10','state' => 'Belgium','city' => 'Beli','address_line1' => 'New jursey','address_line2' => '','state_province_region' => '','postal_code' => '2365'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl6" role="tabpanel"
                                                     aria-labelledby="cUrl-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/contacts/update' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'contact_id="25"' \
--form 'contact_type_id="3"' \
--form 'first_name="Seikh "' \
--form 'last_name="Hasina"' \
--form 'email="hasina@gmail.com"' \
--form 'country="10"' \
--form 'state="Belgium"' \
--form 'city="Beli"' \
--form 'address_line1="New jursey"' \
--form 'address_line2=""' \
--form 'state_province_region=""' \
--form 'postal_code="2365"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby6" role="tabpanel"
                                                     aria-labelledby="Ruby-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/update")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['contact_id', '25'],['contact_type_id', '3'],['first_name', 'Seikh '],['last_name', 'Hasina'],['email', 'hasina@gmail.com'],
             ['country', '10'],['state', 'Belgium'],['city', 'Beli'],['address_line1', 'New jursey'],['address_line2', ''],['state_province_region', ''],['postal_code', '2365']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#OK6"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request6"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request6"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK6" role="tabpanel"
                                                     aria-labelledby="OK-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Contact Updated Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request6" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "email": [
            "The email field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="contactDelete" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Contact Delete')</h4>
                                <p>
                                    @lang("To delete contact follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>DELETE</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">
                                        {{$baseUrl}}contacts/delete?contact_id={contact_id}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl7" type="button" role="tab"
                                                                aria-controls="cUrl7"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab7" data-bs-toggle="pill"
                                                                data-bs-target="#PHP7" type="button" role="tab"
                                                                aria-controls="PHP7"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby7" type="button" role="tab"
                                                                aria-controls="Ruby7"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js7"
                                                                type="button" role="tab" aria-controls="Node-js7"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python7" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js7" role="tabpanel"
                                                     aria-labelledby="Node-js-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'DELETE',
  'url': 'BASE_URL/contacts/delete?contact_id=10',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python7" role="tabpanel"
                                                     aria-labelledby="Python-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/delete?contact_id=10"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("DELETE", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP7" role="tabpanel"
                                                     aria-labelledby="PHP-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/delete?contact_id=10',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'DELETE',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl7" role="tabpanel"
                                                     aria-labelledby="cUrl-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request DELETE 'BASE_URL/contacts/delete?contact_id=10' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby7" role="tabpanel"
                                                     aria-labelledby="Ruby-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/delete?contact_id=10")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Delete.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#OK7"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request7"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request7"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK7" role="tabpanel"
                                                     aria-labelledby="OK-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request7" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="contactMultipleDelete" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Contact Bulk Delete')</h4>
                                <p>
                                    @lang("To bulk delete contact follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}contacts/bulk-delete</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY</code> and <code>YOUR_SECRET_KEY</code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>strIds<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">array</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    strIds must be type array.</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="[10,25]">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl8" type="button" role="tab"
                                                                aria-controls="cUrl8"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab8" data-bs-toggle="pill"
                                                                data-bs-target="#PHP8" type="button" role="tab"
                                                                aria-controls="PHP8"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby8" type="button" role="tab"
                                                                aria-controls="Ruby8"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js8"
                                                                type="button" role="tab" aria-controls="Node-js8"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python8" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js8" role="tabpanel"
                                                     aria-labelledby="Node-js-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/contacts/bulk-delete',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY',
    'Content-Type': 'application/x-www-form-urlencoded'
  },
  form: {
    'strIds[0]': '8',
    'strIds[1]': '44'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python8" role="tabpanel"
                                                     aria-labelledby="Python-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/contacts/bulk-delete"

payload='strIds%5B0%5D=8&strIds%5B1%5D=44'
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY',
  'Content-Type': 'application/x-www-form-urlencoded'
}

response = requests.request("POST", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP8" role="tabpanel"
                                                     aria-labelledby="PHP-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/contacts/bulk-delete',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'strIds%5B0%5D=8&strIds%5B1%5D=44',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY',
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl8" role="tabpanel"
                                                     aria-labelledby="cUrl-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/contacts/bulk-delete' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--header 'Content-Type: application/x-www-form-urlencoded' \
--data-urlencode 'strIds[0]=8' \
--data-urlencode 'strIds[1]=44'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby8" role="tabpanel"
                                                     aria-labelledby="Ruby-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/contacts/bulk-delete")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
request["Content-Type"] = "application/x-www-form-urlencoded"
request.body = "strIds%5B0%5D=8&strIds%5B1%5D=44"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#OK8"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request8"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request8"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK8" role="tabpanel"
                                                     aria-labelledby="OK-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request8" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include($theme.'partials.footer')
    </main>
@endsection

