@extends($theme . 'layouts.docx')
@section('title',trans('Automation'))
@section('content')
    @include($theme.'partials.api-sidebar')
    @php
        $baseUrl = url('/').'/api/'
    @endphp
    <main>
        <div class="main-wrapper">
            <div class="row g-4">
                <div class="col-12">
                    <div class="api-reference-section">
                        <div id="getAllAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Get All Automation')</h4>
                                <p>
                                    @lang("To get all the automation list follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">
                                        {{$baseUrl}}automations</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Response Body")</h5>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>id:</b> <span> automation id</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>user_id:</b> <span> owner id of the specific automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_for:</b>
                                            <span> it should be contact type id or segment id which you targeting</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_for_table:</b> <span> table name of you targeting</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_name:</b> <span> name of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>exit_criteria:</b> <span> when the automation exit</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>unsubscribe_group_id:</b> <span> which unsubscribe group perform for the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_type:</b> <span> the type of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>utr:</b>
                                            <span> the unique uuid of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>status:</b>
                                            <span> status of the automation. Two types of status allow. 0 stand for draft, and 1 stand for live</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>live_at:</b>
                                            <span> the live at time of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>total_triggered,total_delivered,total_unique_opens,total_opens,total_bounces,total_unsubscribe:</b>
                                            <span> the total number of statics </span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_schedule_count:</b>
                                            <span> number of email automation has</span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab7"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl7" type="button" role="tab"
                                                                aria-controls="cUrl7"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab7" data-bs-toggle="pill"
                                                                data-bs-target="#PHP7" type="button" role="tab"
                                                                aria-controls="PHP7" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab7" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby7" type="button" role="tab"
                                                                aria-controls="Ruby7"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js7"
                                                                type="button" role="tab" aria-controls="Node-js7"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab7" data-bs-toggle="pill"
                                                                data-bs-target="#Python7" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js7" role="tabpanel"
                                                     aria-labelledby="Node-js-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/automations',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python7" role="tabpanel"
                                                     aria-labelledby="Python-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)

</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP7" role="tabpanel"
                                                     aria-labelledby="PHP-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl7" role="tabpanel"
                                                     aria-labelledby="cUrl-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/automations' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby7" role="tabpanel"
                                                     aria-labelledby="Ruby-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#OK7"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab7"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request7"
                                                                type="button" role="tab" aria-controls="Bad-Request7"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK7" role="tabpanel"
                                                     aria-labelledby="OK-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "automations": [
            {
                "id": 5,
                "user_id": 6790,
                "automation_for": 3,
                "automation_for_table": "contacts_",
                "automation_name": "Test Automation",
                "exit_criteria": 1,
                "unsubscribe_group_id": "3",
                "automation_type": 0,
                "utr": "e9c7ff00-8d1c-11ee-91c4-b42e9970e591",
                "status": 0,
                "live_at": null,
                "total_triggered": 0,
                "total_delivered": 0,
                "total_unique_opens": 0,
                "total_opens": 0,
                "total_bounces": 0,
                "total_unsubscribe": 0,
                "deleted_at": null,
                "created_at": "2023-11-27T12:03:01.000000Z",
                "updated_at": "2023-11-27T12:03:01.000000Z",
                "automation_schedule_count": 3
            },
            {
                "id": 3,
                "user_id": 6790,
                "automation_for": 3,
                "automation_for_table": "contacts_",
                "automation_name": "Test Automation",
                "exit_criteria": 1,
                "unsubscribe_group_id": "3",
                "automation_type": 0,
                "utr": "4dce63f6-8825-11ee-a739-b42e9970e591",
                "status": 1,
                "live_at": "2023-11-28 12:16:59",
                "total_triggered": 3,
                "total_delivered": 3,
                "total_unique_opens": 2,
                "total_opens": 16,
                "total_bounces": 0,
                "total_unsubscribe": 1,
                "deleted_at": null,
                "created_at": "2023-11-21T04:20:29.000000Z",
                "updated_at": "2023-11-28T06:16:59.000000Z",
                "automation_schedule_count": 3
            },
            ...
        ]
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request7" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab7" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="createAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Create Automation')</h4>
                                <p>
                                    @lang("To create a new automation follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/create</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>type<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">enum</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">Two type are available now. For building automation type
                                                    should be welcome and custom automation type should be custom</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="custom">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_for</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Which recipient do you want to targeting. you can target contact and
                                                    segment recipients.
                                                    for contact recipients contacts_{contact_type_id} e.g. contacts_10
                                                    and
                                                    for segment recipient segments_{segment_id} e.g. segments_25
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="contacts_10">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_name</b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Name of the automation</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Untitled Automation">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>unsubscribe_group_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    The Unsubscribe group what you want to assign for this
                                                    automation</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="3">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab9"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl9" type="button" role="tab"
                                                                aria-controls="cUrl9"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab9" data-bs-toggle="pill"
                                                                data-bs-target="#PHP9" type="button" role="tab"
                                                                aria-controls="PHP9" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab9" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby9" type="button" role="tab"
                                                                aria-controls="Ruby9"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab9"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js9"
                                                                type="button" role="tab" aria-controls="Node-js9"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab9" data-bs-toggle="pill"
                                                                data-bs-target="#Python9" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js9" role="tabpanel"
                                                     aria-labelledby="Node-js-tab9" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/automations/create',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'type': 'custom',
    'automation_for': 'contacts_3',
    'automation_name': 'Api Automation',
    'unsubscribe_group_id': '3'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});





                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python9" role="tabpanel"
                                                     aria-labelledby="Python-tab9" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/create"

payload={'type': 'custom',
'automation_for': 'contacts_3',
'automation_name': 'Api Automation',
'unsubscribe_group_id': '3'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)

</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP9" role="tabpanel"
                                                     aria-labelledby="PHP-tab9" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/create',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('type' => 'custom','automation_for' => 'contacts_3','automation_name' => 'Api Automation','unsubscribe_group_id' => '3'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl9" role="tabpanel"
                                                     aria-labelledby="cUrl-tab9" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/automations/create' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'type="custom"' \
--form 'automation_for="contacts_3"' \
--form 'automation_name="Api Automation"' \
--form 'unsubscribe_group_id="3"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby9" role="tabpanel"
                                                     aria-labelledby="Ruby-tab9" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/create")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['type', 'custom'],['automation_for', 'contacts_3'],['automation_name', 'Api Automation'],['unsubscribe_group_id', '3']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab9"
                                                                data-bs-toggle="pill" data-bs-target="#OK9"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab9"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request9"
                                                                type="button" role="tab" aria-controls="Bad-Request9"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK9" role="tabpanel"
                                                     aria-labelledby="OK-tab9" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "utr": "affe4624-9674-11ee-8139-b42e9970e591"
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request9" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab9" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "automation_name": [
            "The automation name field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="duplicateAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Duplicate Automation')</h4>
                                <p>
                                    @lang("To duplicate a automation follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/duplicate?utr={utr}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Request Body")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl" type="button" role="tab"
                                                                aria-controls="cUrl" aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab" data-bs-toggle="pill"
                                                                data-bs-target="#PHP" type="button" role="tab"
                                                                aria-controls="PHP" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby" type="button" role="tab"
                                                                aria-controls="Ruby" aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js"
                                                                type="button" role="tab" aria-controls="Node-js"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab" data-bs-toggle="pill"
                                                                data-bs-target="#Python" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js" role="tabpanel"
                                                     aria-labelledby="Node-js-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/automations/duplicate?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e592',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python" role="tabpanel"
                                                     aria-labelledby="Python-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/duplicate?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e592"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP" role="tabpanel"
                                                     aria-labelledby="PHP-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/duplicate?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e592',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl" role="tabpanel"
                                                     aria-labelledby="cUrl-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/automations/duplicate?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e592' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby" role="tabpanel"
                                                     aria-labelledby="Ruby-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/duplicate?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e592")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab"
                                                                data-bs-toggle="pill" data-bs-target="#OK" type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request"
                                                                type="button" role="tab" aria-controls="Bad-Request"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK" role="tabpanel"
                                                     aria-labelledby="OK-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "utr": "ee482778-9657-11ee-bb6c-b42e9970e591"
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "PublicKey": [
            "The public key field is required."
        ],
        "SecretKey": [
            "The secret key field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>
                        <div id="detailsAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Get Automation Details')</h4>
                                <p>
                                    @lang("To get Automation Details follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/details?utr={utr}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Response Body")</h5>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>id:</b> <span> automation id</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>user_id:</b> <span> owner id of the specific automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_for:</b>
                                            <span> it should be contact type id or segment id which you targeting</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_for_table:</b> <span> table name of you targeting</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_name:</b> <span> name of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>exit_criteria:</b> <span> when the automation exit</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>unsubscribe_group_id:</b> <span> which unsubscribe group perform for the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>automation_type:</b> <span> the type of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>utr:</b>
                                            <span> the unique uuid of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>status:</b>
                                            <span> status of the automation. Two types of status allow. 0 stand for draft, and 1 stand for live</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>live_at:</b>
                                            <span> the live at time of the automation</span>
                                        </p>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>total_triggered,total_delivered,total_unique_opens,total_opens,total_bounces,total_unsubscribe:</b>
                                            <span> the total number of statics </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab2"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl2" type="button" role="tab"
                                                                aria-controls="cUrl2"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#PHP2" type="button" role="tab"
                                                                aria-controls="PHP2" aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Ruby2" type="button" role="tab"
                                                                aria-controls="Ruby2"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js2"
                                                                type="button" role="tab" aria-controls="Node-js2"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab2" data-bs-toggle="pill"
                                                                data-bs-target="#Python2" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js2" role="tabpanel"
                                                     aria-labelledby="Node-js-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/automations/details?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python2" role="tabpanel"
                                                     aria-labelledby="Python-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/details?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP2" role="tabpanel"
                                                     aria-labelledby="PHP-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/details?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl2" role="tabpanel"
                                                     aria-labelledby="cUrl-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/automations/details?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby2" role="tabpanel"
                                                     aria-labelledby="Ruby-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/details?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#OK2"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab2"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request2"
                                                                type="button" role="tab" aria-controls="Bad-Request2"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK2" role="tabpanel"
                                                     aria-labelledby="OK-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "automation": {
            "id": 5,
            "user_id": 6790,
            "automation_for": 3,
            "automation_for_table": "contacts_",
            "automation_name": "Test Automation",
            "exit_criteria": 1,
            "unsubscribe_group_id": "3",
            "automation_type": 0,
            "utr": "e9c7ff00-8d1c-11ee-91c4-b42e9970e591",
            "status": 0,
            "live_at": null,
            "total_triggered": 0,
            "total_delivered": 0,
            "total_unique_opens": 0,
            "total_opens": 0,
            "total_bounces": 0,
            "total_unsubscribe": 0,
            "deleted_at": null,
            "created_at": "2023-11-27T12:03:01.000000Z",
            "updated_at": "2023-11-27T12:03:01.000000Z"
        }
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request2" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab2" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record Not Found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="pauseAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Pause Automation')</h4>
                                <p>
                                    @lang("To pause automation follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/pause?utr={utr}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Note: We allow pause only live automation")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl8" type="button" role="tab"
                                                                aria-controls="cUrl8"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab8" data-bs-toggle="pill"
                                                                data-bs-target="#PHP8" type="button" role="tab"
                                                                aria-controls="PHP8"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby8" type="button" role="tab"
                                                                aria-controls="Ruby8"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js8"
                                                                type="button" role="tab" aria-controls="Node-js8"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab8"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python8" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js8" role="tabpanel"
                                                     aria-labelledby="Node-js-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/automations/pause?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python8" role="tabpanel"
                                                     aria-labelledby="Python-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/pause?utr=4dce63f6-8825-11ee-a739-b42e9970e591"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP8" role="tabpanel"
                                                     aria-labelledby="PHP-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/pause?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl8" role="tabpanel"
                                                     aria-labelledby="cUrl-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/automations/pause?utr=4dce63f6-8825-11ee-a739-b42e9970e591' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby8" role="tabpanel"
                                                     aria-labelledby="Ruby-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/pause?utr=4dce63f6-8825-11ee-a739-b42e9970e591")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#OK8"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab8"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request8"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request8"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK8" role="tabpanel"
                                                     aria-labelledby="OK-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Automation Paused Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request8" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab8" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record not found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="setLiveAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Set Live Automation')</h4>
                                <p>
                                    @lang("To set live automation follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/set-live?utr={utr}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl5" type="button" role="tab"
                                                                aria-controls="cUrl5"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab5" data-bs-toggle="pill"
                                                                data-bs-target="#PHP5" type="button" role="tab"
                                                                aria-controls="PHP5"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby5" type="button" role="tab"
                                                                aria-controls="Ruby5"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js5"
                                                                type="button" role="tab" aria-controls="Node-js5"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab5"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python5" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js5" role="tabpanel"
                                                     aria-labelledby="Node-js-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/automations/set-live?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});




                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python5" role="tabpanel"
                                                     aria-labelledby="Python-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/set-live?utr=4dce63f6-8825-11ee-a739-b42e9970e591"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP5" role="tabpanel"
                                                     aria-labelledby="PHP-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/set-live?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl5" role="tabpanel"
                                                     aria-labelledby="cUrl-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/automations/set-live?utr=4dce63f6-8825-11ee-a739-b42e9970e591' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby5" role="tabpanel"
                                                     aria-labelledby="Ruby-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/set-live?utr=4dce63f6-8825-11ee-a739-b42e9970e591")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body

</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#OK5"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab5"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request5"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request5"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK5" role="tabpanel"
                                                     aria-labelledby="OK-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Automation has been set live"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request5" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab5" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Unsubscribe group require to live automation"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="deleteAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Delete Automation')</h4>
                                <p>
                                    @lang("To delete automation follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>DELETE</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/delete?utr={utr}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab12"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl12" type="button" role="tab"
                                                                aria-controls="cUrl12"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab12"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#PHP12" type="button" role="tab"
                                                                aria-controls="PHP12"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab12"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby12" type="button" role="tab"
                                                                aria-controls="Ruby12"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab12"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js12"
                                                                type="button" role="tab" aria-controls="Node-js12"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab12"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python12" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js12" role="tabpanel"
                                                     aria-labelledby="Node-js-tab12" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'DELETE',
  'url': 'BASE_URL/automations/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python12" role="tabpanel"
                                                     aria-labelledby="Python-tab12" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("DELETE", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP12" role="tabpanel"
                                                     aria-labelledby="PHP-tab12" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'DELETE',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl12" role="tabpanel"
                                                     aria-labelledby="cUrl-tab12" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request DELETE 'BASE_URL/automations/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby12" role="tabpanel"
                                                     aria-labelledby="Ruby-tab12" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Delete.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab12"
                                                                data-bs-toggle="pill" data-bs-target="#OK12"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab12"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Bad-Request12"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request12"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK12" role="tabpanel"
                                                     aria-labelledby="OK-tab12" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request12" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab12" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record not found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="bulkDeleteAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Bulk Delete Automation')</h4>
                                <p>
                                    @lang("To multiple delete of automation follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/bulk-delete</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>strIds<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">array</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    strIds must be type array.</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="[10,25]">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl6" type="button" role="tab"
                                                                aria-controls="cUrl6"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab6" data-bs-toggle="pill"
                                                                data-bs-target="#PHP6" type="button" role="tab"
                                                                aria-controls="PHP6"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby6" type="button" role="tab"
                                                                aria-controls="Ruby6"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js6"
                                                                type="button" role="tab" aria-controls="Node-js6"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab6"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python6" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js6" role="tabpanel"
                                                     aria-labelledby="Node-js-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/automations/bulk-delete',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY',
    'Content-Type': 'application/x-www-form-urlencoded'
  },
  form: {
    'strIds[0]': '8',
    'strIds[1]': '44'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python6" role="tabpanel"
                                                     aria-labelledby="Python-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/bulk-delete"

payload='strIds%5B0%5D=8&strIds%5B1%5D=44'
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY',
  'Content-Type': 'application/x-www-form-urlencoded'
}

response = requests.request("POST", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP6" role="tabpanel"
                                                     aria-labelledby="PHP-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/bulk-delete',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'strIds%5B0%5D=8&strIds%5B1%5D=44',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY',
    'Content-Type: application/x-www-form-urlencoded'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl6" role="tabpanel"
                                                     aria-labelledby="cUrl-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/automations/bulk-delete' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--header 'Content-Type: application/x-www-form-urlencoded' \
--data-urlencode 'strIds[0]=8' \
--data-urlencode 'strIds[1]=44'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby6" role="tabpanel"
                                                     aria-labelledby="Ruby-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/bulk-delete")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
request["Content-Type"] = "application/x-www-form-urlencoded"
request.body = "strIds%5B0%5D=8&strIds%5B1%5D=44"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#OK6"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab6"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request6"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request6"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK6" role="tabpanel"
                                                     aria-labelledby="OK-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request6" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab6" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record not found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="getScheduleAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Get Automation Schedules')</h4>
                                <p>
                                    @lang("To get automation schedules list follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>GET</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/schedule?utr={utr}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Note: utr should be automation utr")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl3" type="button" role="tab"
                                                                aria-controls="cUrl3"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab3" data-bs-toggle="pill"
                                                                data-bs-target="#PHP3" type="button" role="tab"
                                                                aria-controls="PHP3"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby3" type="button" role="tab"
                                                                aria-controls="Ruby3"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js3"
                                                                type="button" role="tab" aria-controls="Node-js3"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab3"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python3" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js3" role="tabpanel"
                                                     aria-labelledby="Node-js-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'GET',
  'url': 'BASE_URL/automations/schedule?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python3" role="tabpanel"
                                                     aria-labelledby="Python-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/schedule?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("GET", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP3" role="tabpanel"
                                                     aria-labelledby="PHP-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/schedule?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl3" role="tabpanel"
                                                     aria-labelledby="cUrl-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request GET 'BASE_URL/automations/schedule?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby3" role="tabpanel"
                                                     aria-labelledby="Ruby-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/schedule?utr=e9c7ff00-8d1c-11ee-91c4-b42e9970e591")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Get.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#OK3"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab3"
                                                                data-bs-toggle="pill" data-bs-target="#Bad-Request3"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request3"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK3" role="tabpanel"
                                                     aria-labelledby="OK-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": {
        "automation_schedules": [
            {
                "id": 10,
                "user_id": 6790,
                "automation_id": 5,
                "sender_id": 2,
                "subject": "How is your days goes to",
                "waiting_period": 1,
                "waiting_type": "instantly",
                "utr": "5a24b56e-89de-11ee-ae43-b42e9970e591",
                "template_id": 2,
                "preview_img": "verify_email.png",
                "template_json": ...,
                "template_html": ...,
                "created_at": "2023-11-27T12:03:01.000000Z",
                "updated_at": "2023-11-27T12:03:01.000000Z",
                "design_url": "BASE_URL/user/automations/schedule/email/design/5a24b56e-89de-11ee-ae43-b42e9970e591",
                "image": "BASE_URL/assets/sample_template/verify_email.png"
            },
            ...
        ]
    }
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request3" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab3" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record not found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="createScheduleAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Create Automation Schedule')</h4>
                                <p>
                                    @lang("To create automation schedule follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>POST</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/schedule/create</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Body Params")</h5>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>utr<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">string</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">Which automation you want to add schedule</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control"
                                                       value="381da846-8780-11ee-835d-b42e9970e591">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>sender_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Which sender you want to use for email. you get sender_id from
                                                    sender list endpoint
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="3">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>subject<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">text</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">
                                                    Subject of your mail</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="Welcome to our team">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>waiting_period<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">How many days or hours you want to wait for email.
                                                    For
                                                    instant email send keep waiting_period 1. </p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="2">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>waiting_type<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">enum</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">3 type of waiting_type. instantly,days,hours</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="days">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>template_id<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">integer</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">The design template id. you will get template id
                                                    from
                                                    Get All Template endpoint</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="13">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>preview_img<span class="text-danger">*</span></b>
                                            <span class="badge text-bg-info">text</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">The design preview img. you will get preview img
                                                    from
                                                    Get All Template endpoint</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="verify_email.png">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>template_json</b>
                                            <span class="badge text-bg-info">longText</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">The design template json code. if you provide json code
                                                    then make template_html empty</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row g-2 mb-2">
                                    <div class="col-12">
                                        <p class="mb-0">
                                            <b>template_html</b>
                                            <span class="badge text-bg-info">longText</span>
                                        </p>
                                    </div>
                                    <div class="col-12">
                                        <div class="row align-items-center">
                                            <div class="col-md-8">
                                                <p class="mb-0">The design template html code. if you provide html code
                                                    then make template_json empty</p>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control" value="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab13"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl13" type="button" role="tab"
                                                                aria-controls="cUrl13"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab13"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#PHP13" type="button" role="tab"
                                                                aria-controls="PHP13"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab13"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby13" type="button" role="tab"
                                                                aria-controls="Ruby13"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab13"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js13"
                                                                type="button" role="tab" aria-controls="Node-js13"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab13"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python13" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js13" role="tabpanel"
                                                     aria-labelledby="Node-js-tab13" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'POST',
  'url': 'BASE_URL/automations/schedule/create',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  },
  formData: {
    'utr': '381da846-8780-11ee-835d-b42e9970e591',
    'sender_id': '2',
    'subject': 'Test Api Subject',
    'waiting_period': '1',
    'waiting_type': 'instantly',
    'template_id': '2',
    'preview_img': 'verify_email.png',
    'template_json': 'abc',
    'template_html': 'xyz'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});





                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python13" role="tabpanel"
                                                     aria-labelledby="Python-tab13" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/schedule/create"

payload={'utr': '381da846-8780-11ee-835d-b42e9970e591',
'sender_id': '2',
'subject': 'Test Api Subject',
'waiting_period': '1',
'waiting_type': 'instantly',
'template_id': '2',
'preview_img': 'verify_email.png',
'template_json': 'abc',
'template_html': 'xyz'}
files=[

]
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("POST", url, headers=headers, data=payload, files=files)

print(response.text)

</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP13" role="tabpanel"
                                                     aria-labelledby="PHP-tab13" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/schedule/create',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('utr' => '381da846-8780-11ee-835d-b42e9970e591','sender_id' => '2','subject' => 'Test Api Subject','waiting_period' => '1',
                              'waiting_type' => 'instantly','template_id' => '2','preview_img' => 'verify_email.png','template_json' => 'abc','template_html' => 'xyz'),
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;


                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl13" role="tabpanel"
                                                     aria-labelledby="cUrl-tab13" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request POST 'BASE_URL/automations/schedule/create' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY' \
--form 'utr="381da846-8780-11ee-835d-b42e9970e591"' \
--form 'sender_id="2"' \
--form 'subject="Test Api Subject"' \
--form 'waiting_period="1"' \
--form 'waiting_type="instantly"' \
--form 'template_id="2"' \
--form 'preview_img="verify_email.png"' \
--form 'template_json="abc"' \
--form 'template_html="xyz"'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby13" role="tabpanel"
                                                     aria-labelledby="Ruby-tab13" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/schedule/create")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Post.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"
form_data = [['utr', '381da846-8780-11ee-835d-b42e9970e591'],['sender_id', '2'],['subject', 'Test Api Subject'],['waiting_period', '1'],['waiting_type', 'instantly'],
              ['template_id', '2'],['preview_img', 'verify_email.png'],['template_json', 'abc'],['template_html', 'xyz']]
request.set_form form_data, 'multipart/form-data'
response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab13"
                                                                data-bs-toggle="pill" data-bs-target="#OK13"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab13"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Bad-Request13"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request13"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK13" role="tabpanel"
                                                     aria-labelledby="OK-tab13" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Schedule Added"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request13" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab13" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": {
        "sender_id": [
            "The sender id field is required."
        ],
        "subject": [
            "The subject field is required."
        ],
        "waiting_type": [
            "The waiting type field is required."
        ]
    }
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="deleteScheduleAutomation" class="row g-4 mb-4">
                            <div class="col-lg-6">
                                <h4 class="mt-0">@lang('Delete Automation Schedule')</h4>
                                <p>
                                    @lang("To delete automation schedule follow the example code and be careful with the parameters.")
                                </p>
                                <p><span class="badge text-bg-success">@lang("Base Url")</span><i>{{$baseUrl}}</i>
                                </p>
                                <hr>
                                <p>
                                    <b>@lang("HTTP Method:")</b>
                                    <code><span>DELETE</span></code>
                                </p>
                                <p>
                                    <b>@lang("API URL:")</b>
                                    <i class="text-primary">{{$baseUrl}}automations/schedule/delete?utr={utr}</i>
                                </p>
                                <p>
                                    <b>@lang("API Key:")</b>
                                    <span>@lang("Get <code>YOUR_PUBLIC_KEY </code> and <code>YOUR_SECRET_KEY </code> from the account page")</span>
                                </p>
                                <p>
                                    <b>@lang("Response format:")</b>
                                    <span>@lang("JSON")</span>
                                </p>
                                <hr>
                                <h5 class="mb-3">@lang("Note: you get utr from Get Automation Schedule endpoint")</h5>
                            </div>
                            <div class="col-lg-6">
                                <div class="row g-4">
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cUrl-tab15"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#cUrl15" type="button" role="tab"
                                                                aria-controls="cUrl15"
                                                                aria-selected="false">@lang("cURL")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="PHP-tab15"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#PHP15" type="button" role="tab"
                                                                aria-controls="PHP15"
                                                                aria-selected="false">@lang("PHP")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Ruby-tab15"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Ruby15" type="button" role="tab"
                                                                aria-controls="Ruby15"
                                                                aria-selected="false">@lang("Ruby")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Node-js-tab15"
                                                                data-bs-toggle="pill" data-bs-target="#Node-js15"
                                                                type="button" role="tab" aria-controls="Node-js15"
                                                                aria-selected="true">@lang("Node.js")
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Python-tab15"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Python15" type="button" role="tab"
                                                                aria-controls="Python"
                                                                aria-selected="false">@lang("Python")
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade" id="Node-js15" role="tabpanel"
                                                     aria-labelledby="Node-js-tab15" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
var request = require('request');
var options = {
  'method': 'DELETE',
  'url': 'BASE_URL/automations/schedule/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  'headers': {
    'PublicKey': 'YOUR_PUBLIC_KEY',
    'SecretKey': 'YOUR_SECRET_KEY'
  }
};
request(options, function (error, response) {
  if (error) throw new Error(error);

});



                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span>
                                                                <span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>

                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Python15" role="tabpanel"
                                                     aria-labelledby="Python-tab15" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
import requests

url = "BASE_URL/automations/schedule/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591"

payload={}
headers = {
  'PublicKey': 'YOUR_PUBLIC_KEY',
  'SecretKey': 'YOUR_SECRET_KEY'
}

response = requests.request("DELETE", url, headers=headers, data=payload)

print(response.text)
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="PHP15" role="tabpanel"
                                                     aria-labelledby="PHP-tab15" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
?php

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'BASE_URL/automations/schedule/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'DELETE',
  CURLOPT_HTTPHEADER => array(
    'PublicKey: YOUR_PUBLIC_KEY',
    'SecretKey: YOUR_SECRET_KEY'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;

                                                                </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade show active" id="cUrl15" role="tabpanel"
                                                     aria-labelledby="cUrl-tab15" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
curl --location --request DELETE 'BASE_URL/automations/schedule/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591' \
--header 'PublicKey: YOUR_PUBLIC_KEY' \
--header 'SecretKey: YOUR_SECRET_KEY'</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Ruby15" role="tabpanel"
                                                     aria-labelledby="Ruby-tab15" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
require "uri"
require "net/http"

url = URI("BASE_URL/automations/schedule/delete?utr=4dce63f6-8825-11ee-a739-b42e9970e591")

http = Net::HTTP.new(url.host, url.port);
request = Net::HTTP::Delete.new(url)
request["PublicKey"] = "YOUR_PUBLIC_KEY"
request["SecretKey"] = "YOUR_SECRET_KEY"

response = http.request(request)
puts response.read_body
</code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-12">
                                        <div class="editor-header">
                                            <div class="cmn-tabs2">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="OK-tab15"
                                                                data-bs-toggle="pill" data-bs-target="#OK15"
                                                                type="button"
                                                                role="tab" aria-controls="OK" aria-selected="true">
                                                            200
                                                            OK
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="Bad-Request-tab15"
                                                                data-bs-toggle="pill"
                                                                data-bs-target="#Bad-Request15"
                                                                type="button" role="tab"
                                                                aria-controls="Bad-Request15"
                                                                aria-selected="false">400 Bad
                                                            Request
                                                        </button>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="editor-content-area">
                                            <div class="tab-content" id="pills-tabContent">
                                                <div class="tab-pane fade show active" id="OK15" role="tabpanel"
                                                     aria-labelledby="OK-tab15" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre"><code class="docs-code">
{
    "status": "success",
    "message": "Deleted Successfully"
}
                                                        </code></pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span><span>15</span>
                                                                <span>16</span><span>17</span><span>18</span><span>19</span><span>20</span><span>21</span><span>22</span><span>23</span><span>24</span><span>25</span><span>26</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Bad-Request15" role="tabpanel"
                                                     aria-labelledby="Bad-Request-tab15" tabindex="0">
                                                    <div class="language-bash">
                                                        <div class="language-bash-inner">
                                                            <pre class="docs-pre">
                                                                <code class="docs-code">
{
    "status": "failed",
    "errors": "Record not found"
}
                                                            </code>
                                                            </pre>
                                                            <span class="line-numbers-rows">
                                                                <span>1</span><span>2</span><span>3</span><span>4</span><span>5</span><span>6</span><span>7</span><span>8</span><span>9</span><span>10</span><span>11</span><span>12</span><span>13</span><span>14</span>
                                                            </span>
                                                        </div>
                                                        <button onclick="copyTextFunc()" class="copy-code"
                                                                type="button"><i class="fa-regular fa-copy"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include($theme.'partials.footer')
    </main>
@endsection

