@extends($theme.'layouts.app')
@section('title',trans('Register'))
@push('css-lib')
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/intlTelInput.min.css')}}"/>
@endpush
@section('content')
    <section class="login-signup-page">
        <div class="container">
            <div class="row g-lg-5 justify-content-between align-items-center">
                <div class="col-xl-5 col-md-6 order-2 order-md-1">
                    <div class="login-signup-form">
                        <form action="{{ route('register') }}" method="post" class="php-email-form">
                            @csrf
                            <div class="section-header">
                                <h4>{{@$template->description->register_heading}}</h4>
                                <div class="description">{{@$template->description->register_sub_heading}}</div>
                            </div>
                            <div class="row g-4">
                                <div class="col-12">
                                    <input type="text" name="first_name" value="{{old('first_name')}}" class="form-control"
                                           id="first_name"
                                           placeholder="@lang('First Name')">
                                    @error('first_name')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <input type="text" name="last_name" value="{{old('last_name')}}" class="form-control"
                                           id="last_name"
                                           placeholder="@lang('Last Name')">
                                    @error('last_name')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <input type="email" name="email" value="{{old('email')}}" class="form-control"
                                           id="exampleInputEmail4"
                                           placeholder="@lang('Email')">
                                    @error('email')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <input type="text" name="username" value="{{old('username')}}" class="form-control"
                                           id="exampleInputEmail3"
                                           placeholder="@lang('Username')">
                                    @error('username')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <input type="hidden" id="country" name="phone_code" value="+1">
                                    <input id="telephone" class="form-control" name="phone" type="tel">
                                    <div class="text-danger">@error('phone') @lang($message) @enderror</div>
                                    <div class="text-danger">@error('phone_code') @lang($message) @enderror</div>
                                </div>
                                <div class="col-12">
                                    <div class="password-box">
                                        <input type="password" name="password" value="{{ old('password') }}"
                                               class="form-control password" id="password"
                                               placeholder="@lang('Password')">
                                        <i class="password-icon fa-regular fa-eye"></i>
                                    </div>
                                    @error('password')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-12">

                                    <div class="password-box">
                                        <input type="password" name="password_confirmation" value="{{ old('password_confirmation') }}"
                                               class="form-control  confirm-password" id="password_confirmation"
                                               placeholder="@lang('Confirm Password')">
                                        <i class="password-icon confirm-password-icon fa-regular fa-eye"></i>
                                    </div>
                                </div>
                                @if((basicControl()->google_recaptcha == 1) && (basicControl()->google_reCaptcha_status_registration))

                                    <div class="form-group">
                                        {!! NoCaptcha::renderJs() !!}
                                        {!! NoCaptcha::display() !!}
                                        @error('g-recaptcha-response')
                                        <div class="text-danger">@lang($message)</div>
                                        @enderror
                                    </div>
                                @endif

                                @if(basicControl()->manual_recaptcha &&  basicControl()->reCaptcha_status_registration)
                                    <div class="input-box mb-4">
                                        <input type="text" tabindex="2"
                                               class="form-control @error('captcha') is-invalid @enderror"
                                               name="captcha" id="captcha" autocomplete="off"
                                               placeholder="@lang('Enter captcha code')" >

                                        @error('captcha')
                                        <div class="text-danger">@lang($message)</div>
                                        @enderror
                                    </div>

                                    <div class="mb-4">
                                        <div
                                            class="input-group input-group-merge d-flex justify-content-between"
                                            data-hs-validation-validate-class>
                                            <img src="{{route('captcha').'?rand='. rand()}}"
                                                 id='captcha_image2'>
                                            <a class="input-group-append input-group-text"
                                               href='javascript: refreshCaptcha2();'>
                                                <i class="fal fa-sync"></i>
                                            </a>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <button type="submit" class="btn cmn-btn mt-30 w-100">@lang('signup')</button>
                        </form>
                    </div>
                </div>
                <div class="col-xl-6 col-md-6 order-1 order-md-2 d-none d-md-block">
                    <div class="login-signup-thums">
                        <img
                            src="{{getFile(@$template->content->media->register_page_image->driver,@$template->content->media->register_page_image->path)}}"
                            alt="...">
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@push('js-lib')
    <script src="{{ asset($themeTrue . 'js/intlTelInput.min.js')}}"></script>
 @if((basicControl()->google_recaptcha == 1) && (basicControl()->google_reCaptcha_status_login == 1))
    <script src="{{ asset($themeTrue . 'js/google.com_recaptcha_api.js') }}"></script>
    @endif
@endpush

@push('extra_scripts')
    <script>
        'use strict'
        const input = document.querySelector("#telephone");
        window.intlTelInput(input, {
            initialCountry: "us",
            separateDialCode: true,
        });

        $('.iti__country-list li').on('click', function () {
            $("#country").val($(this).data('dial-code'));
        })

        const password = document.querySelector('.password');
        const passwordIcon = document.querySelector('.password-icon');

        passwordIcon.addEventListener("click", function () {
            if (password.type == 'password') {
                password.type = 'text';
                passwordIcon.classList.add('fa-eye-slash');
            } else {
                password.type = 'password';
                passwordIcon.classList.remove('fa-eye-slash');
            }
        })
        const confirmPassword = document.querySelector('.confirm-password');
        const confirmPasswordIcon = document.querySelector('.confirm-password-icon');

        confirmPasswordIcon.addEventListener("click", function () {
            if (confirmPassword.type == 'password') {
                confirmPassword.type = 'text';
                confirmPasswordIcon.classList.add('fa-eye-slash');
            } else {
                confirmPassword.type = 'password';
                confirmPasswordIcon.classList.remove('fa-eye-slash');
            }
        })

        function refreshCaptcha() {
            let img = document.images['captcha_image'];
            img.src = img.src.substring(
                0, img.src.lastIndexOf("?")
            ) + "?rand=" + Math.random() * 1000;
        }

        function refreshCaptcha2() {
            let img = document.images['captcha_image2'];
            img.src = img.src.substring(
                0, img.src.lastIndexOf("?")
            ) + "?rand=" + Math.random() * 1000;
        }

        $(document).on('click', '.btn-custom', function () {
            $('.text-danger').html('');
            refreshCaptcha();
        })

    </script>
@endpush
