@extends($theme.'layouts.app')
@section('title',trans('Login'))
@section('content')
    <section class="login-signup-page">
        <div class="container">
            <div class="row g-lg-5 justify-content-between align-items-center">
                <div class="col-xl-5 col-md-6 order-2 order-md-1">
                    <div class="login-signup-form">
                        <form action="{{ route('login') }}" method="post">
                            @csrf
                            <div class="section-header">
                                <h4>{{@$template->description->login_heading}}</h4>
                                <div class="description">{{@$template->description->login_sub_heading}}</div>
                            </div>
                            <div class="row g-4">
                                <div class="col-12">
                                    <input type="text" name="username" value="{{old('username')}}" class="form-control" id="exampleInputEmail1"
                                           placeholder="@lang("Email or Username")">
                                    @error('username')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <div class="password-box">
                                        <input type="password" name="password" value="{{old('password')}}" class="form-control password"
                                               id="password"
                                               placeholder="@lang('Password')">
                                        <i class="password-icon fa-regular fa-eye"></i>
                                    </div>
                                    @error('password')
                                    <span class="text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                @if((basicControl()->manual_recaptcha && basicControl()->reCaptcha_status_login))
                                    <div class="input-box mb-4">
                                        <input type="text" tabindex="2"
                                               class="form-control @error('captcha') is-invalid @enderror"
                                               name="captcha" id="captcha" autocomplete="off"
                                               placeholder="@lang('Enter captcha code')" required>
                                        @error('captcha')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="mb-4">
                                        <div class="input-group input-group-merge d-flex justify-content-between"
                                             data-hs-validation-validate-class>
                                            <img src="{{route('captcha').'?rand='. rand()}}" id='captcha_image'>
                                            <a class="input-group-append input-group-text"
                                               href='javascript: refreshCaptcha();'>
                                                <i class="fas fa-sync  "></i>
                                            </a>
                                        </div>
                                    </div>
                                @endif

                                @if((basicControl()->google_recaptcha == 1) && (basicControl()->google_reCaptcha_status_login == 1))
                                    <div class="form-group">
                                        {!! NoCaptcha::renderJs() !!}
                                        {!! NoCaptcha::display() !!}
                                        @error('g-recaptcha-response')
                                        <div class="text-danger mt-1 mb-1">@lang($message)</div>
                                        @enderror
                                    </div>
                                @endif

                                <div class="col-12">
                                    <div class="form-check d-flex justify-content-between">
                                        <div class="check">
                                            <input type="checkbox" name="remember" class="form-check-input"
                                                   id="exampleCheck1" {{ old('remember') ? 'checked' : '' }}>
                                            <label class="form-check-label"
                                                   for="exampleCheck1">@lang('Remember me')</label>
                                        </div>
                                        <div class="forgot highlight">
                                            <a href="{{ route('password.request') }}">@lang('Forgot password?')</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn cmn-btn mt-30 w-100">@lang('Log In')</button>
                            @if(config('socialite.google_status') && config('socialite.facebook_status') && config('socialite.github_status'))
                                <hr class="divider">
                            @endif
                            <div class="cmn-btn-group">
                                <div class="row g-2">
                                    @if(config('socialite.google_status'))
                                        <div class="col-sm-4">
                                            <a href="{{route('socialiteLogin','google')}}"
                                               class="btn cmn-btn3 w-100 social-btn"><img
                                                    src="{{$themeTrue.'img/login_signup/google.png'}}"
                                                    alt="...">@lang('Google')
                                            </a>
                                        </div>
                                    @endif
                                    @if(config('socialite.facebook_status'))
                                        <div class="col-sm-4">
                                            <a href="{{route('socialiteLogin','facebook')}}"
                                               class="btn cmn-btn3 w-100 social-btn"><img
                                                    src="{{$themeTrue.'img/login_signup/facebook.png'}}"
                                                    alt="...">@lang('Facebook')
                                            </a>
                                        </div>
                                    @endif
                                    @if(config('socialite.github_status'))
                                        <div class="col-sm-4">
                                            <a href="{{route('socialiteLogin','github')}}"
                                               class="btn cmn-btn3 w-100 social-btn"><img
                                                    src="{{$themeTrue.'img/login_signup/github.png'}}"
                                                    alt="...">@lang('Github')
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="pt-20 text-center">
                                @lang("Don't have an account?")
                                <p class="mb-0 highlight"><a
                                        href="{{ route('register') }}">@lang('Create an account')</a></p>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-xl-6 col-md-6 order-1 order-md-2 d-none d-md-block">
                    <div class="login-signup-thums">
                        <img
                            src="{{getFile(@$template->content->media->login_page_image->driver,@$template->content->media->login_page_image->path)}}"
                            alt="...">
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js-lib')
    @if((basicControl()->google_recaptcha == 1) && (basicControl()->google_reCaptcha_status_login == 1))
    <script src="{{ asset($themeTrue . 'js/google.com_recaptcha_api.js') }}"></script>
    @endif
@endpush

@push('extra_scripts')
    <script>
        'use strict';
        // input field show hide password start
        const password = document.querySelector('.password');
        const passwordIcon = document.querySelector('.password-icon');

        passwordIcon.addEventListener("click", function () {
            if (password.type == 'password') {
                password.type = 'text';
                passwordIcon.classList.add('fa-eye-slash');
            } else {
                password.type = 'password';
                passwordIcon.classList.remove('fa-eye-slash');
            }
        })

        function refreshCaptcha() {
            let img = document.images['captcha_image'];
            img.src = img.src.substring(
                0, img.src.lastIndexOf("?")
            ) + "?rand=" + Math.random() * 1000;
        }
    </script>
@endpush
