@extends('admin.layouts.app')
@section('page_title',__('Create Plan'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);">@lang('Subscription Plan')</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">@yield('page_title')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@yield('page_title')</h1>
                </div>
            </div>
        </div>
        <div class="row mx-4">
            <span class="text-danger"> <i class="fal fa-exclamation-triangle"></i> @lang('If your automatic payment subscription is active, kindly verify that the correct plan_id/price_id is configured for your plan. You have the option to update the plan_id/price_id by visiting the Plan Update Page.')</span>
        </div>
        <div class="content container-fluid">
            <div class="row justify-content-lg-center">
                <div class="col-lg-12">
                    <div class="d-grid gap-3 gap-lg-5">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4 class="card-title mt-2">@lang("Create Plan")</h4>
                            </div>
                            <div class="card-body mt-2">
                                <form action="{{ route('admin.planStore') }}" method="post"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Plan Name')</label>
                                                <input type="text" class="form-control" name="plan_name"
                                                       value="{{old('plan_name')}}"
                                                       id="plan_name"
                                                       placeholder="@lang('Premium')" aria-label="@lang('plan_name')"
                                                       autocomplete="off">
                                                @error('plan_name')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Frequency')</label>
                                                <div class="tom-select-custom">
                                                    <select
                                                        class="js-select form-select @error('payment_frequency') is-invalid @enderror"
                                                        id="payment_frequency" name="payment_frequency">
                                                        <option
                                                            value="monthly" {{old('payment_frequency') == 'monthly' ? 'selected':''}}>@lang('Monthly')</option>
                                                        <option
                                                            value="yearly" {{old('payment_frequency') == 'yearly' ? 'selected':''}}>@lang('Yearly')</option>
                                                    </select>
                                                </div>
                                                @error('payment_frequency')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Price')</label>
                                                <div class="input-group">
                                                    <input type="number" step="0.01" class="form-control" name="price"
                                                           value="{{old('price')}}"
                                                           placeholder="15"
                                                           aria-label="@lang('price')"
                                                           autocomplete="off">
                                                    <span class="input-group-text"
                                                          id="basic-addon2">{{basicControl()->base_currency}}</span>
                                                </div>
                                                @error('price')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Number of Contacts')</label>
                                                <input type="number" class="form-control" name="number_of_contacts"
                                                       value="{{old('number_of_contacts')}}"
                                                       id="number_of_contacts"
                                                       placeholder="10000"
                                                       aria-label="@lang('number_of_contacts')"
                                                       autocomplete="off">
                                                @error('number_of_contacts')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Number of Emails')</label>
                                                <input type="number" class="form-control" name="number_of_emails"
                                                       id="number_of_emails"
                                                       value="{{old('number_of_emails')}}"
                                                       placeholder="5000"
                                                       aria-label="@lang('number_of_emails')"
                                                       autocomplete="off">
                                                @error('number_of_emails')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Sending Server')</label>
                                                <div class="tom-select-custom">
                                                    <select
                                                        class="js-select form-select @error('sending_server') is-invalid @enderror"
                                                        id="sending_server" name="sending_server">
                                                        <option
                                                            value="mailchimp" {{old('frequency') == 'mailchimp' ? 'selected':''}}>@lang('Mailchimp')</option>
                                                        <option
                                                            value="mailersend" {{old('frequency') == 'mailersend' ? 'selected':''}}>@lang('Mailersend')</option>
                                                        <option
                                                            value="mailgun" {{old('frequency') == 'mailgun' ? 'selected':''}}>@lang('Mailgun')</option>
                                                        <option
                                                            value="postmark" {{old('frequency') == 'postmark' ? 'selected':''}}>@lang('Postmark')</option>
                                                        <option
                                                            value="sendgrid" {{old('frequency') == 'sendgrid' ? 'selected':''}}>@lang('Sendgrid')</option>
                                                        <option
                                                            value="sendinblue" {{old('frequency') == 'sendinblue' ? 'selected':''}}>@lang('Sendinblue')</option>
                                                        <option
                                                            value="ses" {{old('frequency') == 'ses' ? 'selected':''}}>@lang('SES')</option>
                                                        <option
                                                            value="smtp" {{old('frequency') == 'smtp' ? 'selected':''}}>@lang('SMTP')</option>
                                                    </select>
                                                </div>
                                                @error('sending_server')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label"
                                                       for="subjectLabel">@lang('Short Description')</label>
                                                <textarea class="form-control"
                                                          name="description"></textarea>
                                                @error('description')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <label class="row form-check form-switch my-4"
                                                   for="status">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Status")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Display the status of the plan (active or inactive) prominently on the front page.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="status"/>
                                                    <input
                                                        class="form-check-input @error('status') is-invalid @enderror"
                                                        type="checkbox" name="status"
                                                        id="status" value="1"
                                                        {{old('status') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('status')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="row form-check form-switch my-4"
                                                   for="design_and_code_editors">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Design and code editors")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users can customize and enhance the design of their emails to better suit their preferences.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="design_and_code_editors"/>
                                                    <input
                                                        class="form-check-input @error('design_and_code_editors') is-invalid @enderror"
                                                        type="checkbox" name="design_and_code_editors"
                                                        id="design_and_code_editors" value="1" {{old('design_and_code_editors') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('design_and_code_editors')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>

                                            <label class="row form-check form-switch my-4"
                                                   for="automation">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Automation")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users have the flexibility to personalize and establish their own automation processes.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="automation"/>
                                                    <input
                                                        class="form-check-input @error('automation') is-invalid @enderror"
                                                        type="checkbox" name="automation"
                                                        id="automation" value="1" {{old('automation') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('automation')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>

                                            <label class="row form-check form-switch my-4"
                                                   for="single_send">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Single send")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users have the flexibility to personalize and establish their own single send processes.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="single_send"/>
                                                    <input
                                                        class="form-check-input @error('single_send') is-invalid @enderror"
                                                        type="checkbox" name="single_send"
                                                        id="single_send" value="1" {{old('single_send') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('single_send')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>

                                            <label class="row form-check form-switch my-4"
                                                   for="segmentation">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Segmentation")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users have the flexibility to personalize and establish their own segmentation processes.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="segmentation"/>
                                                    <input
                                                        class="form-check-input @error('segmentation') is-invalid @enderror"
                                                        type="checkbox" name="segmentation"
                                                        id="segmentation" value="1" {{old('segmentation') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('segmentation')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>

                                            <label class="row form-check form-switch my-4"
                                                   for="custom_field">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Custom field")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users have the flexibility to personalize and establish their own custom field.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="custom_field"/>
                                                    <input
                                                        class="form-check-input @error('custom_field') is-invalid @enderror"
                                                        type="checkbox" name="custom_field"
                                                        id="custom_field" value="1" {{old('custom_field') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('custom_field')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>

                                            <label class="row form-check form-switch my-4"
                                                   for="notify_recipient">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Notify Recipient")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users have the flexibility to add own notify recipients.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="notify_recipient"/>
                                                    <input
                                                        class="form-check-input @error('notify_recipient') is-invalid @enderror"
                                                        type="checkbox" name="notify_recipient"
                                                        id="notify_recipient" value="1" {{old('notify_recipient') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('notify_recipient')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>

                                            <label class="row form-check form-switch my-4"
                                                   for="api_uses">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Api Recipient")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users possess the capability to utilize and interact with their API.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="api_uses"/>
                                                    <input
                                                        class="form-check-input @error('api_uses') is-invalid @enderror"
                                                        type="checkbox" name="api_uses"
                                                        id="activities" value="1" {{old('api_uses') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('api_uses')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>

                                            <label class="row form-check form-switch my-4"
                                                   for="activities">
                                            <span class="col-8 col-sm-9 ms-0">
                                              <span class="d-block text-dark">@lang("Activities")</span>
                                              <span
                                                  class="d-block fs-5">@lang("Users have the ability to view their own activities.")</span>
                                            </span>
                                                <span class="col-4 col-sm-3 text-end">
                                                    <input type="hidden" value="0" name="activities"/>
                                                    <input
                                                        class="form-check-input @error('activities') is-invalid @enderror"
                                                        type="checkbox" name="activities"
                                                        id="activities" value="1" {{old('activities') == '1' ? 'checked':''}}>
                                                </span>
                                                @error('activities')
                                                <span class="invalid-feedback d-block">{{ $message }}</span>
                                                @enderror
                                            </label>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-start">
                                        <button type="submit" class="btn btn-primary">@lang('Create')</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('css-lib')
@endpush

@push('js-lib')
@endpush

@push('script')
    <script>
        'use strict';
        (function () {
            HSCore.components.HSTomSelect.init('.js-select', {
                maxOptions: 500
            })
        })();
    </script>
@endpush










