@extends('admin.layouts.app')
@section('page_title', __('Add Country'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0)">@lang('Dashboard')</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">@yield('page_title')</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="row payment_method">
            <div class="col-lg-12">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <h2 class="card-title h4">@lang('Add New')</h2>
                            <a href="{{route('admin.country.index')}}" class="btn btn-sm btn-info">
                                <i class="bi-arrow-left"></i> @lang('Back')
                            </a>
                        </div>
                        <div class="card-body">
                            <form action="{{route('admin.country.store')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row mb-4 d-flex align-items-center">

                                    <div class="col-md-6">
                                        <label for="name" class="form-label">@lang('Country Name')</label>
                                        <input type="text" class="form-control  @error('name') is-invalid @enderror"
                                               name="name" id="name" placeholder="@lang("Bangladesh")" aria-label="name"
                                               autocomplete="off" value="{{ old('name') }}">
                                        @error('name')<span class="invalid-feedback">{{ $message }}</span>@enderror
                                    </div>

                                    <div class="col-md-2">
                                        <label for="iso2" class="form-label">@lang('Country ISO 2')</label>
                                        <input type="text" class="form-control  @error('iso2') is-invalid @enderror"
                                               name="iso2" id="iso2" placeholder="@lang("BD")" aria-label="iso2"
                                               autocomplete="off" value="{{ old('iso2') }}">
                                        @error('iso2')<span class="invalid-feedback">{{ $message }}</span>@enderror
                                    </div>

                                    <div class="col-md-2">
                                        <label for="iso3" class="form-label">@lang('Country ISO 3')</label>
                                        <input type="text" class="form-control  @error('iso3') is-invalid @enderror"
                                               name="iso3" id="iso3" placeholder="@lang("BGD")" aria-label="iso3"
                                               autocomplete="off" value="{{ old('iso3') }}">
                                        @error('iso3')<span class="invalid-feedback">{{ $message }}</span>@enderror
                                    </div>

                                    <div class="col-md-2">
                                        <label for="phone_code" class="form-label">@lang('Country Phone Code')</label>
                                        <input type="text" class="form-control  @error('phone_code') is-invalid @enderror"
                                               name="phone_code" id="phone_code" placeholder="@lang("+880")" aria-label="phone_code"
                                               autocomplete="off" value="{{ old('phone_code') }}">
                                        @error('phone_code')<span class="invalid-feedback">{{ $message }}</span>@enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-8">
                                        <label class="row form-check form-switch mt-3" for="country_status">
                                            <span class="col-4 col-sm-9 ms-0 ">
                                                <span class="d-block text-dark">@lang("Country Status")</span>
                                                <span class="d-block fs-5">@lang("Click on this Switch for change the status.")</span>
                                            </span>

                                            <span class="col-2 col-sm-3 text-end">
                                                <input type='hidden' value='0' name='status'>
                                                <input class="form-check-input @error('status') is-invalid @enderror"
                                                       type="checkbox" name="status" id="countryStatus" value="1" checked>
                                                <label class="form-check-label text-center" for="countryStatus"></label>
                                            </span>
                                            @error('status')<span class="invalid-feedback d-block">{{ $message }}</span>@enderror
                                        </label>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-start mt-4">
                                    <button type="submit" class="btn btn-primary">@lang('Save')</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection



@push('js-lib')
    <script src="{{ asset('assets/admin/js/hs-file-attach.min.js') }}"></script>
@endpush

@push('script')
    <script>
        'use strict';
        $(document).ready(function () {
            new HSFileAttach('.js-file-attach')
            HSCore.components.HSTomSelect.init('.js-select')
        });
    </script>
@endpush



