@extends('admin.layouts.app')
@section('page_title', __('OpenAi Settings'))
@section('content')
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="{{ route('admin.dashboard')  }}">@lang('Dashboard')</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">@lang('Settings')</li>
                            <li class="breadcrumb-item active"
                                aria-current="page">@lang('OpenAi Settings')</li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title">@lang('OpenAi Settings')</h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-3">
                @include('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'])
            </div>
            <div class="col-lg-6 seo-setting">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header">
                            <h2 class="card-title h4">@lang('OpenAi Settings')</h2>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.openAi.update') }}" method="post"
                                  enctype="multipart/form-data">
                                @csrf
                                <div class="row mb-4 mt-5">
                                    <label for="currency_layer_access_key"
                                           class="col-sm-4 col-form-label form-label">@lang("OpenAi Api Key")</label>
                                    <div class="col-sm-8">
                                        <div class="input-group input-group-merge">
                                            <input type="password"
                                                   class="js-toggle-password form-control   @error('open_ai_key') is-invalid @enderror"
                                                   name="open_ai_key" id="open_ai_key"
                                                   autocomplete="off"
                                                   placeholder="open_ai_key"
                                                   aria-label="open_ai_key"
                                                   value="{{ old('open_ai_key',  $basicControl->open_ai_key) }}">
                                            <button type="button" class="input-group-append input-group-text clickShowPassword">
                                                <i class="bi-eye-slash"></i>
                                            </button>
                                        </div>
                                        @error('open_ai_key')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <label for="currency_layer_auto_update_at"
                                           class="col-sm-4 col-form-label form-label">@lang("Open AI Model") <i
                                            class="bi-question-circle text-body ms-1" data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            aria-label="@lang("Open AI Mode")"
                                            data-bs-original-title="@lang("You can also import your model by writing search box")"></i></label>
                                    <div class="col-sm-8">
                                        <div class="tom-select-custom">
                                            <select class="form-control ai-model" name="open_ai_model"
                                                    required>
                                                <option
                                                    value="gpt-3.5-turbo" {{$basicControl->open_ai_model == 'gpt-3.5-turbo'?'selected':''}}>
                                                    gpt-3.5-turbo
                                                </option>
                                                <option
                                                    value="gpt-4" {{$basicControl->open_ai_model == 'gpt-4'?'selected':''}}>
                                                    gpt-4
                                                </option>
                                                <option
                                                    value="gpt-4-32k" {{$basicControl->open_ai_model == 'gpt-4-32k'?'selected':''}}>
                                                    gpt-4-32k
                                                </option>
                                            </select>
                                        </div>
                                        @error('open_ai_model')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>


                                <label class="row form-check form-switch mb-4" for="open_ai_status">
                                        <span class="col-8 col-sm-9 ms-0">
                                          <span class="d-block text-dark">@lang("Open AI Status")</span>
                                          <span
                                              class="d-block fs-5">@lang("If you leave it on, your AI-generated content will be tailored to your user preferences and subject matter.")</span>
                                        </span>
                                    <span class="col-4 col-sm-3 text-end">
                                           <input type='hidden' value='0' name='coin_market_cap_auto_update'>

                                               <input
                                                   class="form-check-input @error('open_ai_status') is-invalid @enderror"
                                                   type="checkbox"
                                                   name="open_ai_status"
                                                   id="open_ai_status"
                                                   value="1" {{ $basicControl->open_ai_status == 1 ? 'checked' : '' }}>
                                        </span>
                                    @error('open_ai_status')
                                    <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                </label>

                                <div class="d-flex justify-content-end mt-4">
                                    <button type="submit" class="btn btn-primary">@lang('Save changes')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('css-lib')
    <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js-lib')
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
@endpush

@push('script')
    <script>
        'use strict';
        $(document).ready(function () {
            $('.ai-model').select2({
                tags: true
            });
        });

        $(document).on('click', '.clickShowPassword', function () {
            let passInput = $(this).closest('.input-group-merge').find('input');
            if (passInput.attr('type') === 'password') {
                $(this).children().removeClass('bi-eye-slash');
                $(this).children().addClass('bi-eye');
                passInput.attr('type', 'text');
            } else {
                $(this).children().removeClass('bi-eye');
                $(this).children().addClass('bi-eye-slash');
                passInput.attr('type', 'password');
            }
        })
    </script>
@endpush


