<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prepaid_plans', function (Blueprint $table) {
            $table->id();
            $table->string('plan_name')->nullable();
            $table->double('plan_price')->nullable();
            $table->integer('number_of_contacts')->default(0);
            $table->integer('number_of_emails')->default(0);
            $table->boolean('design_and_code_editors')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('automation')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('single_send')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('segmentation')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('custom_field')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('notify_recipient')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('activities')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('api_uses')->default(1)->comment('0=>no,1=>yes');
            $table->boolean('status')->default(1)->comment('0=>no,1=>yes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prepaid_plans');
    }
};
