<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('single_sends', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->index();
            $table->foreignId('template_id')->index()->nullable()->comment('which template select in template table');
            $table->foreignId('sender_id')->index()->nullable()->comment('which sender use for send in sender table');
            $table->foreignId('recipient_id')->index()->nullable()->comment('which recipient get the mail. would be contact or test segment id');
            $table->tinyInteger('recipient_type')->nullable()->comment('0=>global,1=>any list,2=>segment');
            $table->foreignId('exclude_specific_recipient_id')->index()->nullable()->comment('which recipients do you want to avoid would be contact or test segment id');
            $table->tinyInteger('exclude_specific_recipient_type')->nullable()->comment('0=>any list,1=>segment');
            $table->foreignId('unsubscribe_group_id')->index()->nullable()->comment('0=>for global unsubscribe');
            $table->string('single_send_name')->nullable();
            $table->string('from_sender')->nullable();
            $table->text('subject')->nullable();
            $table->text('preheader')->nullable();
            $table->boolean('schedule_type')->default(0)->comment("0=>immediately,1=>schedule");
            $table->date('schedule_date')->nullable();
            $table->time('schedule_time')->nullable();
            $table->tinyInteger('status')->default(0)->comment("0=>initiate,1=>ready to send,2=>ready");
            $table->text('utr')->nullable();
            $table->longText('template_json')->nullable()->comment('template design json data');
            $table->longText('template_html')->nullable()->comment('template design html data');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('single_sends');
    }
};
