<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Exception;

class OpenAIService
{
    public static function textGenerator($request)
    {
        $model = basicControl()->open_ai_model ?? 'gpt-3.5-turbo';
        $OPENAI_API_KEY = basicControl()->open_ai_key;

        $template = new OpenAIService();
        $url = $template->getUrl($model);
        $prompt = "Write a email subject on this topic:\n\n" . $request->email_about . "\n\nTone of voice of the subject must be:\n" . $request->tone_of_voice . "\n\n";

        $max_tokens = (int)$request->max_result;
        $temperature = (float)$request->creativity;

        if ($model == 'gpt-3.5-turbo' || $model == 'gpt-4' || $model == 'gpt-4-32k') {
            $postParams = [
                'model' => $model,
                'messages' => [
                    [
                        "role" => "system",
                        "content" => "You are a helpful assistant.",
                    ],
                    [
                        "role" => "user",
                        "content" => $prompt,
                    ],
                ],
                'temperature' => $temperature,
                'max_tokens' => $max_tokens,
                'n' => 1,
            ];
        } else {
            $postParams = [
                'model' => $model,
                'prompt' => $prompt,
                'temperature' => $temperature,
                'max_tokens' => $max_tokens,
                'n' => 1,
            ];
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $OPENAI_API_KEY ?? '',
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postParams));

        $res = curl_exec($ch);
        curl_close($ch);

        $response = json_decode($res);

        if (isset($response->choices)) {
            return [
                'status' => 'success',
                'data' => $response
            ];
        } else {
            return [
                'status' => 'error',
                'message' => $response->error->message ?? 'something went wrong',
            ];
        }
    }

    public function getUrl($model)
    {
        if ($model == 'gpt-4' || $model == 'gpt-4-0314' || $model == 'gpt-4-32k' || $model == 'gpt-4-32k-0314' || $model == 'gpt-3.5-turbo' || $model == 'gpt-3.5-turbo-0301') {
            return 'https://api.openai.com/v1/chat/completions';
        } elseif ($model == 'text-davinci-003' || $model == 'text-davinci-002' || $model == 'text-curie-001' || $model == ' text-babbage-001' || $model == 'text-ada-001') {
            return 'https://api.openai.com/v1/completions';
        } elseif ($model == 'text-davinci-edit-001' || $model == 'code-davinci-edit-001') {
            return 'https://api.openai.com/v1/edits';
        } else {
            return 'https://api.openai.com/v1/chat/completions';
        }
    }

}
