<?php

namespace App\Rules;

use App\Models\CustomField;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class UniqueFieldName implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        if (
            CustomField::where(function ($query) use ($value) {
                $query->where('is_reserved', 1)
                    ->where('field_name', $value);
            })
                ->orWhere(function ($query) use ($value) {
                    $query->where('field_name', $value)
                        ->where('user_id', auth()->id());
                })
                ->exists()
        ) {
            $fail('The :attribute already exists');
        }
    }

}
