<?php

namespace App\Rules;

use App\Models\SegmentEmail;
use Illuminate\Support\Facades\Request;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class UniqueEmailForSegment implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $segmentId = Request::input('segmentId');
        if (SegmentEmail::where('email', $value)
            ->where('segment_id', $segmentId)
            ->exists()) {
            $fail('The :attribute has already been taken.');
        }
    }
}
