<?php

namespace App\Models;

use App\Traits\TimeZone;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserActivity extends Model
{
    use HasFactory, TimeZone;

    protected $guarded = ['id'];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function apiClient()
    {
        return $this->belongsTo(ApiClient::class, 'ip', 'ip');
    }

    public function getCreatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }
}
