<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UnsubscribeGroup extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'group_name', 'description', 'is_display', 'rand_id'];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function UnsubscribeClients()
    {
        return $this->hasMany(UnsubscribeClient::class, 'unsubscribe_groups_id');
    }

    public function isEmailExit($email)
    {
        if ($this->UnsubscribeClients->where('email_address', $email)->count() > 0) {
            return true;
        }
        return false;
    }
}
