<?php

namespace App\Models;

use App\Traits\TimeZone;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubscriptionPurchase extends Model
{
    use HasFactory, TimeZone;

    protected $guarded = ['id'];
    protected $casts = [
        'extra_api_response' => 'object'
    ];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function subscriptionPlan()
    {
        return $this->belongsTo(Plan::class, 'plan_id');
    }

    public function gateway()
    {
        return $this->belongsTo(Gateway::class, 'payment_method_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function getCreatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }

    public function getSubsExpiredAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }
}
