<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sender extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['user_id', 'from_name', 'from_email', 'reply_to_email', 'country_id',
        'state_id', 'city_id', 'zip_code', 'company_address', 'company_address2', 'nickname', 'is_verified', 'utr', 'send_at'];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function state()
    {
        return $this->belongsTo(CountryState::class, 'state_id');
    }

    public function city()
    {
        return $this->belongsTo(CountryCity::class, 'city_id');
    }

    public function fullAddress()
    {
        return $this->company_address . ' ' . $this->company_address2 . ', ' . optional($this->city)->name . ', ' . optional($this->state)->name . ', ' . optional($this->country)->name;
    }

    public function nameWithEmail()
    {
        return $this->from_name . '<' . $this->from_email . '>';
    }
}
