<?php

namespace App\Models;

use App\Traits\TimeZone;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SegmentEmail extends Model
{
    use HasFactory, TimeZone;

    protected $fillable = ['user_id', 'segment_id', 'contact_id', 'first_name', 'last_name',
        'email', 'country', 'state', 'city', 'address_line1'];
    protected $appends = ['fullname'];

    public function getFullNameAttribute()
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function contact()
    {
        return $this->belongsTo(Contact::class, 'contact_id')->withTrashed();
    }

    public function segment()
    {
        return $this->belongsTo(Segment::class, 'segment_id')->withTrashed();
    }

    public function recipientData()
    {
        $contacts['first_name'] = $this->first_name;
        $contacts['last_name'] = $this->last_name;
        $contacts['email'] = $this->email;
        $contacts['alt_email'] = $this->alt_email;
        $contacts['country'] = $this->country;
        $contacts['state'] = $this->state;
        $contacts['city'] = $this->city;
        $contacts['address_line1'] = $this->address_line1;

        return $contacts;
    }

    public function getCreatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }

    public function getUpdatedAtAttribute($value)
    {
        return $this->localDateFormat($value);
    }
}
