<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $fillable = [
        'plan_name',
        'payment_frequency',
        'price',
        'number_of_contacts',
        'number_of_emails',
        'sending_server',
        'design_and_code_editors',
        'automation',
        'single_send',
        'segmentation',
        'custom_field',
        'notify_recipient',
        'activities',
        'api_uses',
        'status',
        'description',
        'gateway_plan_id'
    ];

    protected $casts = [
        'gateway_plan_id' => 'object'
    ];
}
