<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailAutomationMap extends Model
{
    use HasFactory;

    protected $guarded = ['id'];
    protected $casts = [
        'field_data' => 'object'
    ];

    public function scopeOwn($query)
    {
        return $query->where('user_id', auth()->id());
    }

    public function automation()
    {
        return $this->belongsTo(Automation::class, 'automation_id')->withTrashed();
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
