<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory;

    public $timestamps = false;
    protected $table = 'countries';

    protected $guarded = ['id'];

    public function states()
    {
        return $this->hasMany(CountryState::class, 'country_id');
    }

    public function cities()
    {
        return $this->hasMany(CountryCity::class, 'country_id');
    }


    public function countryImage()
    {
        $image = $this->image;
        $name = $this->name;
        if (!$image) {
            $firstLetter = substr($this->name, 0, 1);
            return '<div class="avatar avatar-sm avatar-soft-primary avatar-circle">
                        <span class="avatar-initials">' . $firstLetter . '</span>
                     </div>';

        } else {
            $url = getFile($this->image_driver, $this->image);
            return '<div class="avatar avatar-sm avatar-circle">
                        <img class="avatar-img" src="' . $url . '" alt="' . $name . '">
                     </div>';

        }
    }

    public function getStatusMessageAttribute()
    {
        if ($this->status == 0) {
            return '<span class="badge bg-soft-warning text-warning"> <span class="legend-indicator bg-warning"></span>' . trans('Inactive') . '</span>';
        }
        return '<span class="badge bg-soft-success text-success"> <span class="legend-indicator bg-success"></span>' . trans('Active') . '</span>';
    }


    public function getStatusBadge()
    {
        switch ($this->status) {
            case 0:
                $status = 'warning';
                $statusText = trans('Pending');
                break;
            case 1:
                $status = 'success';
                $statusText = trans('Approved');
                break;
            case 2:
                $status = 'danger';
                $statusText = trans('Rejected');
                break;
            case 3:
                $status = 'info';
                $statusText = trans('On-Going');
                break;
            case 4:
                $status = 'secondary';
                $statusText = trans('Canceled');
                break;
            default:
                return '';
        }

        return '<span class="badge bg-soft-' . $status . ' text-' . $status . '"> <span class="legend-indicator bg-' . $status . '"></span>' . trans($statusText) . '</span>';

    }


}
