<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SingleSendSaveRequest extends BaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'single_send_name' => 'required|min:2',
            'sender_id' => 'required|numeric',
            'subject' => 'required|min:2',
            'preheader' => 'required|min:2',
            'unsubscribe_group_id' => 'required|numeric',
            'schedule_type' => 'required|in:0,1',
            'schedule_date' => 'required_if:schedule_type,1',
            'schedule_time' => 'required_if:schedule_type,1',
            'recipient_id' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'schedule_date' => 'The schedule date field is required when schedule type Specific Date and Time',
            'schedule_time' => 'The schedule date field is required when schedule type Specific Date and Time',
        ];
    }
}
