<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SenderSaveRequest extends BaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'from_name' => 'required|min:2',
            'from_email' => 'required|email',
            'reply_to_email' => 'required|email',
            'country_id' => 'required|numeric',
            'company_address' => 'required|min:3',
            'nickname' => 'required|min:2',
        ];
    }
}
