<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PrepaidCreditStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->method() == 'GET') {
            return [];
        }
        return [
            'credits' => 'required|min:1|integer',
            'price' => 'required|min:0|not_in:0',
        ];
    }
}
