<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Models\PrepaidCredit;
use App\Traits\PaymentValidationCheck;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Stevebauman\Purify\Facades\Purify;

class PrepaidCreditController extends Controller
{
    use PaymentValidationCheck;

    public function __construct()
    {
        $this->theme = template();
    }

    public function creditsPurchase(Request $request)
    {
        $prepaidCredit = PrepaidCredit::where('status', 1)->findOrFail($request->id);
        if ($request->method() == 'GET') {
            $methods = Gateway::orderBy('sort_by', 'ASC')->where('status', 1)->where('code', '!=', 'paddle')->get();
            return view($this->theme . 'user.prepaid.create', compact('methods', 'prepaidCredit'));
        } elseif ($request->method() == 'POST') {
            $purifiedData = Purify::clean($request->all());

            $validationRules = [
                'methodId' => 'required|integer|min:1|not_in:0',
                'supported_currency' => 'required',
            ];

            $validate = Validator::make($purifiedData, $validationRules);
            if ($validate->fails()) {
                return back()->withErrors($validate)->withInput();
            }

            $purifiedData = (object)$purifiedData;

            $amount = $prepaidCredit->price;
            $methodId = $purifiedData->methodId;
            $currency = $purifiedData->supported_currency;

            $checkAmountValidate = $this->validationCheck($amount, $methodId, $currency);

            if ($checkAmountValidate['status'] == 'error') {
                return back()->with('error', $checkAmountValidate['msg']);
            }

            $method = Gateway::where('status', 1)->findOrFail($methodId);

            $deposit = Deposit::create([
                'user_id' => Auth::user()->id,
                'payment_method_id' => $checkAmountValidate['data']['gateway_id'],
                'payment_method_currency' => $checkAmountValidate['data']['currency'],
                'amount' => $amount,
                'percentage' => $checkAmountValidate['data']['percentage'],
                'charge_percentage' => $checkAmountValidate['data']['percentage_charge'],
                'charge_fixed' => $checkAmountValidate['data']['fixed_charge'],
                'charge' => $checkAmountValidate['data']['charge'],
                'payable_amount' => $checkAmountValidate['data']['payable_amount'],
                'payable_amount_base_currency' => $checkAmountValidate['data']['payable_amount_baseCurrency'],
                'trx_id' => strRandom(),
                'status' => 0,
                'depositable_type' => PrepaidCredit::class,
                'depositable_id' => $prepaidCredit->id,
            ]);

            return redirect(route('payment.process', $deposit->trx_id));
        }
    }
}
