<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Http\Requests\CustomFieldStoreRequest;
use App\Models\CustomField;
use App\Traits\Activity;
use Illuminate\Http\Request;

class CustomFieldsController extends Controller
{
    use Activity;

    public function __construct()
    {
        $this->middleware(['auth']);
        $this->middleware(function ($request, $next) {
            $this->user = auth()->user();
            return $next($request);
        });
        $this->theme = template();
    }

    public function index()
    {
        $data['reservedFields'] = CustomField::where('user_id', null)->get();
        $data['customFields'] = CustomField::own()->orderBy('id', 'desc')->get();
        return view($this->theme . 'user.customField.index', $data);
    }

    public function customFieldSave(CustomFieldStoreRequest $request)
    {
        $customField = new CustomField();
        $fillData = $request->only($customField->getFillable());
        $fillData['user_id'] = $this->user->id;
        $customField->fill($fillData)->save();

        $this->userActivity("You have finished processing to create custom field!");

        session()->flash('success', 'Added Successfully');
        return response()->json(['status' => 'success']);
    }

    public function customFieldDelete($id)
    {
        $customField = CustomField::own()->findOrFail($id);
        $customField->delete();

        $this->userActivity("You have finished processing to delete custom field!");
        return back()->with('success', 'Custom Field Deleted Successfully');
    }

    public function customFieldBulkDelete(Request $request)
    {
        if ($request->strIds == null) {
            session()->flash('error', 'You do not select ID.');
            return response()->json(['error' => 1]);
        } else {
            CustomField::own()->whereIn('id', $request->strIds)->get()->map(function ($query) {
                $query->delete();
            });

            $this->userActivity("You have finished processing to delete multiple custom field!");
            session()->flash('success', 'Deleted Successfully');
            return response()->json(['status' => 'success']);
        }
    }
}
