<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\NotificationRequest;
use App\Models\Notification;
use App\Traits\Activity;
use App\Traits\ApiValidation;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    use ApiValidation, Activity;

    public function index(Request $request)
    {
        $user = $this->user($request->header('publicKey'), $request->header('SecretKey'), $request->ip());
        if ($user) {
            $data['notifications'] = Notification::where('user_id', $user->id)->orderBy('id', 'desc')
                ->get();
            return response()->json($this->withSuccess($data));
        }
        return response()->json($this->withErrors('Record Not Found'));
    }

    public function emailNotificationSave(NotificationRequest $request)
    {
        $user = $this->user($request->header('publicKey'), $request->header('SecretKey'), $request->ip());
        if ($user) {
            $notification = new Notification();
            $fillData = $request->only($notification->getFillable());
            $fillData['user_id'] = $user->id;
            $notification->fill($fillData)->save();

            $route = route('user.emailNotification');
            $this->userActivity(
                "You have finished processing to create <a href='$route' class='text-primary'>notification</a>!",
                $user->id, $request->ip()
            );

            return response()->json($this->withSuccess('Added Successfully'));
        }
        return response()->json($this->withErrors('Record Not Found'));
    }

    public function emailNotificationDelete(Request $request)
    {
        $user = $this->user($request->header('publicKey'), $request->header('SecretKey'), $request->ip());
        if ($user) {
            $notification = Notification::where('user_id', $user->id)->find($request->id);
            if ($notification) {
                $notification->delete();

                $route = route('user.emailNotification');
                $this->userActivity(
                    "You have finished processing to delete <a href='$route' class='text-primary'>notification</a>!",
                    $user->id, $request->ip()
                );

                return response()->json($this->withSuccess('Deleted Successfully'));
            }
        }
        return response()->json($this->withErrors('Record Not Found'));
    }

    public function emailNotificationBulkDelete(Request $request)
    {
        $user = $this->user($request->header('publicKey'), $request->header('SecretKey'), $request->ip());
        if ($user) {
            if ($request->strIds == null) {
                return response()->json($this->withErrors('Id not found'));
            } else {
                Notification::where('user_id', $user->id)->whereIn('id', $request->strIds)->get()->map(function ($query) {
                    $query->delete();
                });

                $route = route('user.emailNotification');
                $this->userActivity(
                    "You have finished processing to multiple delete <a href='$route' class='text-primary'>notification</a>!",
                    $user->id, $request->ip()
                );

                return response()->json($this->withSuccess('Deleted Successfully'));
            }
        }
        return response()->json($this->withErrors('Record Not Found'));
    }
}
