<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\CustomFieldStoreRequest;
use App\Models\CustomField;
use App\Traits\Activity;
use App\Traits\ApiValidation;
use Illuminate\Http\Request;

class CustomFieldsController extends Controller
{
    use ApiValidation, Activity;

    public function reserveField()
    {
        $data['reservedFields'] = CustomField::where('user_id', null)->get();
        return response()->json($this->withSuccess($data));
    }

    public function customField(Request $request)
    {
        $user = $this->user($request->header('publicKey'), $request->header('SecretKey'), $request->ip());
        if ($user) {
            $data['customFields'] = CustomField::where('user_id', $user->id)->orderBy('id', 'desc')->get();
            return response()->json($this->withSuccess($data));
        }
        return response()->json($this->withErrors('Record not found'));
    }

    public function customFieldSave(CustomFieldStoreRequest $request)
    {
        $user = $this->user($request->header('publicKey'), $request->header('SecretKey'), $request->ip());
        if ($user) {
            $customField = new CustomField();
            $fillData = $request->only($customField->getFillable());
            $fillData['user_id'] = $user->id;
            $customField->fill($fillData)->save();
            $this->userActivity("You have finished processing to create custom field!", $user->id, $request->ip());
            return response()->json($this->withSuccess('Added Successfully'));
        }
        return response()->json($this->withErrors('Record not found'));
    }

    public function customFieldDelete(Request $request)
    {
        $user = $this->user($request->header('publicKey'), $request->header('SecretKey'), $request->ip());
        if ($user) {
            $customField = CustomField::where('user_id', $user->id)->find($request->id);
            if ($customField) {
                $customField->delete();

                $this->userActivity("You have finished processing to delete custom field!", $user->id, $request->ip());
                return response()->json($this->withSuccess('Deleted Successfully'));
            }
        }
        return response()->json($this->withErrors('Record not found'));
    }
}
