<?php

namespace App\Http\Controllers\Admin\GeneratedHistory;

use App\Http\Controllers\Controller;
use App\Models\Segment;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class SegmentController extends Controller
{
    public function index()
    {
        return view('admin.segment.list');
    }

    public function segmentSearch(Request $request)
    {
        $segments = Segment::withCount('segmentEmails')
            ->whereHas('user')
            ->when(!empty($request->search['value']), function ($query) use ($request) {
                $query->where(function ($subquery) use ($request) {
                    $subquery->where('segment_name', 'LIKE', '%' . $request->search['value'] . '%')
                        ->orWhereHas('user', function ($userQuery) use ($request) {
                            $userQuery->where('firstname', 'LIKE', '%' . $request->search['value'] . '%')
                                ->orWhere('lastname', 'LIKE', '%' . $request->search['value'] . '%')
                                ->orWhere('username', 'LIKE', '%' . $request->search['value'] . '%');
                        });
                });
            })
            ->orderBy('id', 'DESC');


        return DataTables::of($segments)
            ->addColumn('checkbox', function ($item) {
                return '<input type="checkbox" id="chk-' . $item->id . '"
                                       class="form-check-input row-tic tic-check" name="check" value="' . $item->id . '"
                                       data-id="' . $item->id . '">';
            })
            ->addColumn('no', function () {
                static $counter = 0;
                $counter++;
                return $counter;
            })
            ->addColumn('name', function ($item) {
                return $item->segment_name;
            })
            ->addColumn('emails', function ($item) {
                return '<span class="badge bg-soft-dark text-dark">' . $item->segment_emails_count . '</span>';
            })
            ->addColumn('creator', function ($item) {
                $userProfileRoute = route('admin.user.view.profile', $item->user_id);
                return '<a class="d-flex align-items-center me-2" href="' . $userProfileRoute . '">
                                <div class="flex-shrink-0">
                                  ' . optional($item->user)->profilePicture() . '
                                </div>
                                <div class="flex-grow-1 ms-3">
                                  <h5 class="text-hover-primary mb-0">' . optional($item->user)->firstname . ' ' . optional($item->user)->lastname . '</h5>
                                  <span class="fs-6 text-body">' . optional($item->user)->username . '</span>
                                </div>
                              </a>';
            })
            ->addColumn('created_at', function ($item) {
                return dateTime($item->created_at, basicControl()->date_time_format);
            })
            ->addColumn('action', function ($item) {
                $delete = route('admin.segmentDelete', $item->id);
                return '<div class="btn-group" role="group">
                      <a href="javascript:void(0)" class="btn btn-white btn-sm delete_btn" data-bs-target="#delete"
                           data-bs-toggle="modal" data-route="' . $delete . '">
                        <i class="fal fa-trash me-1"></i> ' . trans("Delete") . '
                      </a>
                  </div>';
            })
            ->rawColumns(['checkbox', 'name', 'emails', 'creator', 'created_at', 'action'])
            ->make(true);
    }

    public function segmentDelete($id)
    {
        $segment = Segment::findOrFail($id);
        $segment->delete();
        return back()->with('success', 'Deleted Successfully');
    }

    public function segmentMultipleDelete(Request $request)
    {
        if ($request->strIds == null) {
            session()->flash('error', 'You do not select User.');
            return response()->json(['error' => 1]);
        } else {
            Segment::whereIn('id', $request->strIds)->delete();
            session()->flash('success', 'Segment has been deleted successfully');
            return response()->json(['success' => 1]);
        }
    }
}
